/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.bat_buckets;

import java.util.List;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3966;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.annotation.Config;
import svenhjol.charm.api.event.PlayerTickCallback;
import svenhjol.charm.helper.ItemNbtHelper;
import svenhjol.charm.init.CharmAdvancements;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.bat_buckets.BatBucketItem;
import svenhjol.charm.module.bat_buckets.EcholocationEffect;
import svenhjol.charm.module.extra_wandering_trades.ExtraWanderingTrades;
import svenhjol.charm.registry.CommonRegistry;

@CommonModule(mod="charm", description="Right-click a bat with a bucket to capture it. Right-click again to release it and locate entities around you.")
public class BatBuckets
extends CharmModule {
    private static final int PLAYER_CHECK_TICKS = 10;
    public static final class_2960 TRIGGER_CAPTURED_BAT = new class_2960("charm", "captured_bat");
    public static final class_2960 TRIGGER_USED_BAT_BUCKET = new class_2960("charm", "used_bat_bucket");
    public static class_3414 GRAB_SOUND;
    public static class_3414 RELEASE_SOUND;
    public static BatBucketItem BAT_BUCKET_ITEM;
    public static EcholocationEffect ECHOLOCATION;
    @Config(name="Glowing time", description="Number of seconds that entities will receive the glowing effect.")
    public static int glowingTime;
    @Config(name="Viewing range", description="Range (in blocks) in which entities will glow.")
    public static int glowingRange;
    @Config(name="Damage bat", description="If true, the bat will take half a heart of damage when released from the bucket.")
    public static boolean damageBat;

    @Override
    public void register() {
        BAT_BUCKET_ITEM = new BatBucketItem(this);
        ECHOLOCATION = new EcholocationEffect(this);
        GRAB_SOUND = CommonRegistry.sound(new class_2960("charm", "bat_bucket_grab"));
        RELEASE_SOUND = CommonRegistry.sound(new class_2960("charm", "bat_bucket_release"));
    }

    @Override
    public void runWhenEnabled() {
        UseEntityCallback.EVENT.register(this::tryCapture);
        PlayerTickCallback.EVENT.register(this::handlePlayerTick);
        ExtraWanderingTrades.registerRareItem((class_1935)BAT_BUCKET_ITEM, 1, 8);
    }

    private void handlePlayerTick(class_1657 player) {
        if (!player.field_6002.field_9236 && player.field_6002.method_8510() % 10L == 0L && player.method_6059((class_1291)ECHOLOCATION)) {
            class_238 box = player.method_5829().method_1009((double)glowingRange, (double)glowingRange / 2.0, (double)glowingRange);
            class_1293 effect = new class_1293(class_1294.field_5912, 10);
            List entities = player.field_6002.method_18467(class_1309.class, box);
            for (class_1309 entity : entities) {
                if (entity.method_5667().equals(player.method_5667()) || !entity.method_6049(effect)) continue;
                entity.method_37222(new class_1293(class_1294.field_5912, 15, 0, false, true), (class_1297)player);
            }
        }
    }

    private class_1269 tryCapture(class_1657 player, class_1937 level, class_1268 hand, class_1297 entity, class_3966 hitResult) {
        class_1420 bat;
        if (!entity.field_6002.field_9236 && entity instanceof class_1420 && (bat = (class_1420)entity).method_6032() > 0.0f) {
            class_1799 held = player.method_5998(hand);
            if (held.method_7960() || held.method_7909() != class_1802.field_8550) {
                return class_1269.field_5811;
            }
            class_1799 batBucket = new class_1799((class_1935)BAT_BUCKET_ITEM);
            class_2487 tag = new class_2487();
            ItemNbtHelper.setCompound(batBucket, "StoredBat", bat.method_5647(tag));
            if (held.method_7947() == 1) {
                player.method_6122(hand, batBucket);
            } else {
                held.method_7934(1);
                player.method_31548().method_7398(batBucket);
            }
            BatBuckets.playGrabSound((class_3218)bat.field_6002, bat.method_24515());
            player.method_7357().method_7906((class_1792)BAT_BUCKET_ITEM, 30);
            player.method_6104(hand);
            entity.method_31472();
            BatBuckets.triggerCapturedBat((class_3222)player);
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public static void playGrabSound(class_3218 level, class_2338 pos) {
        level.method_8396(null, pos, GRAB_SOUND, class_3419.field_15248, 0.6f, 0.95f + level.method_8409().method_43057() * 0.2f);
    }

    public static void playReleaseSound(class_3218 level, class_2338 pos) {
        level.method_8396(null, pos, RELEASE_SOUND, class_3419.field_15248, 0.6f, 0.95f + level.method_8409().method_43057() * 0.2f);
    }

    public static void playLaunchSound(class_3218 level, class_2338 pos) {
        level.method_8396(null, pos, class_3417.field_14610, class_3419.field_15248, 0.25f, 1.0f);
    }

    public static void triggerCapturedBat(class_3222 player) {
        CharmAdvancements.ACTION_PERFORMED.trigger(player, TRIGGER_CAPTURED_BAT);
    }

    public static void triggerUsedBatBucket(class_3222 player) {
        CharmAdvancements.ACTION_PERFORMED.trigger(player, TRIGGER_USED_BAT_BUCKET);
    }

    static {
        glowingTime = 10;
        glowingRange = 24;
        damageBat = true;
    }
}

