/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.loader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import svenhjol.charm.helper.ClassHelper;
import svenhjol.charm.helper.DebugHelper;
import svenhjol.charm.helper.LogHelper;
import svenhjol.charm.helper.StringHelper;
import svenhjol.charm.loader.CharmModule;

public abstract class ModuleLoader<T extends CharmModule> {
    private static final List<String> MOD_IDS = new ArrayList<String>();
    private final Map<String, T> MODULES = new TreeMap<String, T>();
    private final Map<Class<? extends T>, Boolean> ENABLED_CLAZZ_CACHE = new HashMap<Class<? extends T>, Boolean>();
    private final Map<String, Boolean> ENABLED_STRING_CACHE = new HashMap<String, Boolean>();
    private final String modId;
    private final String basePackage;

    public ModuleLoader(String modId, String basePackage) {
        this.modId = modId;
        this.basePackage = basePackage;
        MOD_IDS.add(modId);
    }

    public void init() {
        this.register();
        this.dependencies();
        this.run();
    }

    protected void register() {
        this.prepareModules().forEach((id, module) -> {
            LogHelper.debug(ModuleLoader.class, "Registering " + module.getName(), new Object[0]);
            this.MODULES.put(StringHelper.upperCamelToSnake(module.getName()), module);
            module.register();
        });
    }

    protected void dependencies() {
        this.getModules().forEach(module -> {
            boolean debug = DebugHelper.isDebugMode();
            boolean enabledInConfig = module.isEnabledInConfig();
            boolean passedDependencyCheck = module.getDependencies().isEmpty() || module.getDependencies().stream().allMatch(dep -> dep.test(module));
            module.setEnabled(enabledInConfig && passedDependencyCheck);
            if (!enabledInConfig) {
                if (debug) {
                    LogHelper.warn(ModuleLoader.class, "Disabled in configuration: " + module.getName(), new Object[0]);
                }
            } else if (!passedDependencyCheck) {
                if (debug) {
                    LogHelper.warn(ModuleLoader.class, "Failed dependency check: " + module.getName(), new Object[0]);
                }
            } else if (!module.isEnabled()) {
                if (debug) {
                    LogHelper.warn(ModuleLoader.class, "Disabled automatically: " + module.getName(), new Object[0]);
                }
            } else {
                LogHelper.info(ModuleLoader.class, "Enabled " + module.getName(), new Object[0]);
            }
        });
    }

    protected void run() {
        this.getEnabledModules().forEach(module -> {
            LogHelper.info(ModuleLoader.class, "Running " + module.getName(), new Object[0]);
            module.runWhenEnabled();
        });
        this.getDisabledModules().forEach(module -> {
            LogHelper.debug(ModuleLoader.class, "Running disabled tasks: " + module.getName(), new Object[0]);
            module.runWhenDisabled();
        });
    }

    public boolean isEnabled(Class<? extends T> clazz) {
        if (!this.ENABLED_CLAZZ_CACHE.containsKey(clazz)) {
            boolean enabled = this.getModules().stream().anyMatch(module -> module.getClass().equals(clazz) && module.isEnabled());
            this.ENABLED_CLAZZ_CACHE.put(clazz, enabled);
        }
        return this.ENABLED_CLAZZ_CACHE.get(clazz);
    }

    public boolean isEnabled(String moduleName) {
        if (!this.ENABLED_STRING_CACHE.containsKey(moduleName)) {
            T module;
            if (DebugHelper.isDebugMode() && moduleName.contains(":")) {
                LogHelper.warn(ModuleLoader.class, "Deprecated: Module `" + moduleName + "` no longer requires namespace", new Object[0]);
                moduleName = moduleName.split(":")[1];
            }
            boolean enabled = (module = this.getModule(moduleName)) != null && ((CharmModule)module).isEnabled();
            this.ENABLED_STRING_CACHE.put(moduleName, enabled);
        }
        return this.ENABLED_STRING_CACHE.get(moduleName);
    }

    public List<T> getModules() {
        return this.MODULES.values().stream().toList();
    }

    public List<T> getEnabledModules() {
        return this.MODULES.values().stream().filter(CharmModule::isEnabled).collect(Collectors.toList());
    }

    public List<T> getDisabledModules() {
        return this.MODULES.values().stream().filter(m -> !m.isEnabled()).collect(Collectors.toList());
    }

    @Nullable
    public T getModule(String moduleName) {
        String name;
        if (moduleName.contains(".")) {
            String[] split = moduleName.split("\\.");
            name = split[split.length - 1];
        } else {
            name = moduleName;
        }
        String lower = StringHelper.upperCamelToSnake(name);
        return (T)((CharmModule)this.MODULES.getOrDefault(lower, null));
    }

    protected Map<String, T> prepareModules() {
        LinkedHashMap<String, CharmModule> discoveredModules = new LinkedHashMap<String, CharmModule>();
        List discoveredClasses = ClassHelper.getClassesInPackage(this.getBasePackage(), this.getModuleAnnotation());
        if (discoveredClasses.isEmpty()) {
            LogHelper.warn(ModuleLoader.class, "Seems no module classes were processed... this is probably bad.", new Object[0]);
        }
        TreeMap<String, CharmModule> loaded = new TreeMap<String, CharmModule>();
        for (Class clazz : discoveredClasses) {
            try {
                CharmModule module = (CharmModule)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.setupModuleAnnotations(clazz, module);
                String moduleName = module.getName();
                loaded.put(moduleName, module);
            }
            catch (Exception e) {
                LogHelper.error(ModuleLoader.class, "Error loading module " + clazz.toString() + ": " + e.getMessage(), new Object[0]);
            }
        }
        this.setupModuleConfig(new LinkedList(loaded.values()));
        ArrayList modList = new ArrayList(loaded.values());
        modList.sort((mod1, mod2) -> {
            if (mod1.getPriority() == mod2.getPriority()) {
                return mod1.getName().compareTo(mod2.getName());
            }
            return Integer.compare(mod2.getPriority(), mod1.getPriority());
        });
        block3: for (CharmModule mod : modList) {
            for (Map.Entry entry : loaded.entrySet()) {
                if (!((CharmModule)entry.getValue()).equals(mod)) continue;
                discoveredModules.put((String)entry.getKey(), mod);
                continue block3;
            }
        }
        return discoveredModules;
    }

    protected String getModId() {
        return this.modId;
    }

    protected String getBasePackage() {
        return this.basePackage;
    }

    protected abstract String getModuleAnnotation();

    protected abstract void setupModuleAnnotations(Class<T> var1, T var2) throws IllegalStateException;

    protected void setupModuleConfig(List<T> modules) {
    }

    public static List<String> getModIds() {
        return MOD_IDS;
    }
}

