/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.integration.rei;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.SimpleDisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import svenhjol.charm.helper.TextHelper;
import svenhjol.charm.integration.rei.FiringDisplay;

@Environment(value=EnvType.CLIENT)
public class FiringCategory
implements DisplayCategory<FiringDisplay> {
    private final CategoryIdentifier<? extends FiringDisplay> identifier;
    private final EntryStack<?> logo;
    private final String categoryName;

    public FiringCategory(CategoryIdentifier<? extends FiringDisplay> identifier, EntryStack<?> logo, String categoryName) {
        this.identifier = identifier;
        this.logo = logo;
        this.categoryName = categoryName;
    }

    public List<Widget> setupDisplay(FiringDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.y + 10);
        double cookingTime = display.getCookingTime();
        DecimalFormat df = new DecimalFormat("###.##");
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 61, startPoint.y + 9)));
        widgets.add(Widgets.createBurningFire((Point)new Point(startPoint.x + 1, startPoint.y + 20)).animationDurationMS(10000.0));
        widgets.add(Widgets.createLabel((Point)new Point(bounds.x + bounds.width - 5, bounds.y + 5), (class_2561)TextHelper.translatable("category.rei.cooking.time&xp", df.format(display.getXp()), df.format(cookingTime / 20.0))).noShadow().rightAligned().color(-12566464, -4473925));
        widgets.add(Widgets.createArrow((Point)new Point(startPoint.x + 24, startPoint.y + 8)).animationDurationTicks(cookingTime));
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 61, startPoint.y + 9)).entries((Collection)display.getOutputEntries().get(0)).disableBackground().markOutput());
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 1, startPoint.y + 1)).entries((Collection)display.getInputEntries().get(0)).markInput());
        return widgets;
    }

    public DisplayRenderer getDisplayRenderer(FiringDisplay display) {
        return SimpleDisplayRenderer.from(Collections.singletonList((EntryIngredient)display.getInputEntries().get(0)), (List)display.getOutputEntries());
    }

    public int getDisplayHeight() {
        return 49;
    }

    public CategoryIdentifier<? extends FiringDisplay> getCategoryIdentifier() {
        return this.identifier;
    }

    public Renderer getIcon() {
        return this.logo;
    }

    public class_2561 getTitle() {
        return TextHelper.translatable(this.categoryName);
    }
}

