/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.helper;

import com.google.common.base.CaseFormat;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.commons.lang3.StringUtils;
import svenhjol.charm.helper.LogHelper;
import svenhjol.charm.loader.ModuleLoader;

public class StringHelper {
    private static final Map<String, JsonObject> languageStrings = new HashMap<String, JsonObject>();

    public static String snakeToUpperCamel(String string) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, string);
    }

    public static String upperCamelToSnake(String string) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, string);
    }

    public static String capitalize(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String splitOverLines(String string) {
        return StringHelper.splitOverLines(string, 20);
    }

    public static String splitOverLines(String string, int lineLength) {
        StringBuilder out = new StringBuilder();
        int lineSize = 0;
        for (int i = 0; i < string.length(); ++i) {
            int currentChar = string.charAt(i);
            if (lineSize++ >= lineLength && currentChar == 32 && string.length() - i > 4) {
                currentChar = 10;
                lineSize = 0;
            }
            out.append((char)currentChar);
        }
        return out.toString();
    }

    public static Optional<String> tryResolveLanguageKey(String modId, String key) {
        JsonElement el;
        if (!languageStrings.containsKey(modId)) {
            FabricLoader.getInstance().getModContainer(modId).ifPresent(container -> {
                Path path = container.getPath("assets/" + modId + "/lang/en_us.json");
                try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), StandardCharsets.UTF_8));){
                    JsonElement parsed = JsonParser.parseReader((JsonReader)reader);
                    languageStrings.put(modId, parsed.getAsJsonObject());
                    LogHelper.debug(StringHelper.class, "Successfully opened language file for `" + modId + "`", new Object[0]);
                }
                catch (IOException e) {
                    LogHelper.error(StringHelper.class, "Failed to open language file: " + e.getMessage(), new Object[0]);
                }
            });
        }
        if (languageStrings.containsKey(modId) && (el = languageStrings.get(modId).get(key)) != null) {
            LogHelper.debug(StringHelper.class, "Resolved `" + key + "` for mod `" + modId + "`", new Object[0]);
            return Optional.of(el.getAsString());
        }
        return Optional.empty();
    }

    public static Optional<String> tryTranslateServerComponent(class_2561 message) {
        List<String> modIds = ModuleLoader.getModIds();
        if (!(message instanceof class_5250)) {
            return Optional.empty();
        }
        class_5250 translatable = (class_5250)message;
        String useModId = "";
        for (String modId : modIds) {
            if (!message.getString().contains(modId + ".")) continue;
            useModId = modId;
        }
        if (useModId.isEmpty()) {
            return Optional.empty();
        }
        String reduced = message.getString();
        if (reduced.startsWith("[") && reduced.endsWith("]")) {
            reduced = reduced.substring(1, reduced.length() - 1);
        }
        try {
            Optional<String> opt;
            String key;
            int i = reduced.lastIndexOf("[");
            int j = reduced.lastIndexOf("]");
            String string = key = i >= 0 && j >= 0 ? reduced.substring(i + 1, j) : reduced;
            if (!key.isEmpty() && key.contains(useModId) && (opt = StringHelper.tryResolveLanguageKey(useModId, key)).isPresent()) {
                LogHelper.debug(StringHelper.class, "Resolved key `" + key + "` to `" + opt.get() + "`", new Object[0]);
                return Optional.of(reduced.replace(key, opt.get()));
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            LogHelper.debug(StringHelper.class, "Index out of bounds when trying to process `" + reduced + "`: " + e.getMessage(), new Object[0]);
        }
        return Optional.empty();
    }

    public static OptionalLong parseSeed(String seed) {
        OptionalLong opt1;
        if (StringUtils.isEmpty((CharSequence)seed)) {
            opt1 = OptionalLong.empty();
        } else {
            OptionalLong opt2;
            try {
                opt2 = OptionalLong.of(Long.parseLong(seed));
            }
            catch (NumberFormatException var4) {
                opt2 = OptionalLong.empty();
            }
            opt1 = opt2.isPresent() && opt2.getAsLong() != 0L ? opt2 : OptionalLong.of(seed.hashCode());
        }
        return opt1;
    }

    public static List<String> splitConfigEntry(String entry) {
        return Arrays.stream(entry.split("->")).map(s -> s.trim().toLowerCase(Locale.ROOT)).collect(Collectors.toList());
    }

    public static String snakeToPretty(String string) {
        return StringHelper.snakeToPretty(string, false);
    }

    public static String snakeToPretty(String string, boolean capitalizeEveryWord) {
        if (capitalizeEveryWord) {
            return Arrays.stream(string.split("_")).map(StringHelper::capitalize).collect(Collectors.joining(" "));
        }
        return StringHelper.capitalize(string.replace("_", " "));
    }
}

