/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.helper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3518;
import net.minecraft.class_39;
import net.minecraft.server.MinecraftServer;
import svenhjol.charm.helper.LogHelper;

public class LootHelper {
    public static List<class_2960> CUSTOM_LOOT_TABLES = new ArrayList<class_2960>();
    public static Map<String, class_2960> CACHED_LOOT_TABLES_NAMES = new HashMap<String, class_2960>();

    public static List<class_2960> getAllLootTables() {
        ArrayList<class_2960> allLootTables = new ArrayList<class_2960>();
        allLootTables.addAll(class_39.method_270());
        allLootTables.addAll(CUSTOM_LOOT_TABLES);
        return allLootTables;
    }

    public static List<class_2960> getVanillaVillageLootTables() {
        return LootHelper.getVanillaLootTables("/village/");
    }

    public static List<class_2960> getVanillaLootTables(String pattern) {
        return class_39.method_270().stream().filter(t -> t.method_12832().contains(pattern)).collect(Collectors.toList());
    }

    public static class_2960 getLootTable(String loot, class_2960 fallback) {
        class_2960 lootTable = fallback;
        if (CACHED_LOOT_TABLES_NAMES.isEmpty()) {
            List<class_2960> tables = LootHelper.getAllLootTables();
            for (class_2960 table : tables) {
                String[] s = table.method_12832().split("/");
                String last = s[s.length - 1];
                CACHED_LOOT_TABLES_NAMES.put(last, table);
            }
        }
        if (!loot.isEmpty()) {
            for (String s : CACHED_LOOT_TABLES_NAMES.keySet()) {
                if (!s.contains(loot)) continue;
                lootTable = CACHED_LOOT_TABLES_NAMES.get(s);
                break;
            }
        }
        return lootTable;
    }

    @Nullable
    public static Map<Integer, List<class_1792>> loadItemsFromResource(MinecraftServer server, class_2960 table) {
        InputStream inputStream;
        HashMap<Integer, List<class_1792>> map = new HashMap<Integer, List<class_1792>>();
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        class_3298 resource = server.method_34864().method_14486(table).orElse(null);
        if (resource == null) {
            return null;
        }
        try {
            inputStream = resource.method_14482();
        }
        catch (IOException e) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        JsonObject obj = (JsonObject)class_3518.method_15276((Gson)gson, (Reader)reader, JsonObject.class);
        if (obj == null) {
            return null;
        }
        JsonArray pools = class_3518.method_15261((JsonObject)obj, (String)"pools");
        for (int p = 0; p < pools.size(); ++p) {
            JsonArray elements = class_3518.method_15261((JsonObject)((JsonObject)pools.get(p)), (String)"entries");
            for (int e = 0; e < elements.size(); ++e) {
                JsonObject entry = (JsonObject)elements.get(e);
                String name = entry.get("name").getAsString();
                class_2960 res = new class_2960(name);
                if (class_2378.field_11142.method_17966(res).isPresent()) {
                    map.computeIfAbsent(p, a -> new LinkedList()).add((class_1792)class_2378.field_11142.method_10223(res));
                    continue;
                }
                LogHelper.debug(LootHelper.class, "Could not find item in registry: " + res, new Object[0]);
            }
        }
        return map;
    }
}

