/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.helper;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import svenhjol.charm.helper.DebugHelper;
import svenhjol.charm.helper.StringHelper;

public class LogHelper {
    public static String DEFAULT_INSTANCE;
    public static Map<String, Logger> INSTANCES;

    public static Logger instance(String modId) {
        return INSTANCES.computeIfAbsent(modId, m -> LogManager.getFormatterLogger((String)StringHelper.capitalize(modId)));
    }

    public static void info(Class<?> source, String message, Object ... args) {
        if (DEFAULT_INSTANCE != null) {
            LogHelper.info(DEFAULT_INSTANCE, source, message, args);
        }
    }

    public static void info(String modId, Class<?> source, String message, Object ... args) {
        LogHelper.instance(modId).info(LogHelper.assembleMessage(source, message), args);
    }

    public static void warn(Class<?> source, String message, Object ... args) {
        if (DEFAULT_INSTANCE != null) {
            LogHelper.warn(DEFAULT_INSTANCE, source, message, args);
        }
    }

    public static void warn(String modId, Class<?> source, String message, Object ... args) {
        LogHelper.instance(modId).warn(LogHelper.assembleMessage(source, message), args);
    }

    public static void error(Class<?> source, String message, Object ... args) {
        if (DEFAULT_INSTANCE != null) {
            LogHelper.error(DEFAULT_INSTANCE, source, message, args);
        }
    }

    public static void error(String modId, Class<?> source, String message, Object ... args) {
        LogHelper.instance(modId).error(LogHelper.assembleMessage(source, message), args);
    }

    public static void debug(Class<?> source, String message, Object ... args) {
        if (DEFAULT_INSTANCE != null) {
            LogHelper.debug(DEFAULT_INSTANCE, source, message, args);
        }
    }

    public static void debug(String modId, Class<?> source, String message, Object ... args) {
        if (DebugHelper.isDebugMode()) {
            LogHelper.instance(modId).info(LogHelper.assembleMessage(source, message), args);
        }
    }

    private static String assembleMessage(Class<?> source, String message) {
        return "[" + source.getSimpleName() + "] " + message;
    }

    static {
        INSTANCES = new HashMap<String, Logger>();
    }
}

