/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import svenhjol.charm.enums.IWoodMaterial;

public enum VanillaWoodMaterial implements IWoodMaterial
{
    ACACIA(true),
    BIRCH(true),
    CRIMSON(false),
    DARK_OAK(true),
    JUNGLE(true),
    MANGROVE(true),
    OAK(true),
    SPRUCE(true),
    WARPED(false);

    private final boolean flammable;

    private VanillaWoodMaterial(boolean flammable) {
        this.flammable = flammable;
    }

    @Override
    public boolean isFlammable() {
        return this.flammable;
    }

    public static List<IWoodMaterial> getTypes() {
        return Arrays.stream(VanillaWoodMaterial.values()).collect(Collectors.toList());
    }

    public static List<IWoodMaterial> getTypesWithout(IWoodMaterial ... types) {
        ArrayList<IWoodMaterial> typesList = new ArrayList<IWoodMaterial>(Arrays.asList(types));
        return Arrays.stream(VanillaWoodMaterial.values()).filter(t -> !typesList.contains(t)).collect(Collectors.toList());
    }
}

