/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import svenhjol.charm.enums.IMetalMaterial;

public enum VanillaMetalMaterial implements IMetalMaterial
{
    IRON(5.0f, 6.0f, true, false),
    COPPER(3.5f, 6.0f, false, false),
    GOLD(3.5f, 3.5f, true, false),
    NETHERITE(50.0f, 2500.0f, false, true);

    private final float destroyTime;
    private final float resistance;
    private final boolean immuneToLava;
    private final boolean hasNuggets;

    private VanillaMetalMaterial(float destroyTime, float resistance, boolean hasNuggets, boolean immuneToLava) {
        this.destroyTime = destroyTime;
        this.resistance = resistance;
        this.hasNuggets = hasNuggets;
        this.immuneToLava = immuneToLava;
    }

    @Override
    public float getDestroyTime() {
        return this.destroyTime;
    }

    @Override
    public float getResistance() {
        return this.resistance;
    }

    @Override
    public boolean isFireResistant() {
        return this.immuneToLava;
    }

    @Override
    public boolean hasNuggets() {
        return this.hasNuggets;
    }

    public static List<IMetalMaterial> getTypes() {
        return Arrays.stream(VanillaMetalMaterial.values()).collect(Collectors.toList());
    }

    public static List<IMetalMaterial> getTypesWithout(IMetalMaterial ... types) {
        ArrayList<IMetalMaterial> typesList = new ArrayList<IMetalMaterial>(Arrays.asList(types));
        return Arrays.stream(VanillaMetalMaterial.values()).filter(t -> !typesList.contains(t)).collect(Collectors.toList());
    }
}

