/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.module.biome_ambience;

import net.minecraft.class_1657;
import svenhjol.charmonium.helper.WorldHelper;
import svenhjol.charmonium.module.biome_ambience.BiomeAmbience;
import svenhjol.charmonium.module.biome_ambience.BiomeSound;

public abstract class SurfaceBiomeSound
extends BiomeSound {
    protected boolean playWhenThundering;

    protected SurfaceBiomeSound(class_1657 player, boolean playWhenThundering) {
        super(player);
        this.playWhenThundering = playWhenThundering;
    }

    @Override
    public boolean isValidPlayerCondition() {
        if (WorldHelper.isThundering(this.getPlayer()) && !this.playWhenThundering) {
            return false;
        }
        return WorldHelper.isOutside(this.getPlayer());
    }

    @Override
    public float getVolumeScaling() {
        int cullDistance = BiomeAmbience.cullSoundAboveGround;
        if (cullDistance > 0) {
            float distanceFromGround = WorldHelper.distanceFromGround(this.getPlayer(), cullDistance);
            float multiplier = 1.0f - distanceFromGround / (float)cullDistance;
            return super.getVolumeScaling() * Math.max(0.0f, multiplier);
        }
        return super.getVolumeScaling();
    }
}

