/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.module.biome_ambience;

import java.util.ConcurrentModificationException;
import java.util.List;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import svenhjol.charmonium.helper.LogHelper;
import svenhjol.charmonium.iface.IAmbientSound;
import svenhjol.charmonium.module.biome_ambience.BiomeAmbience;
import svenhjol.charmonium.sounds.LoopingSound;

public abstract class BiomeSound
implements IAmbientSound {
    protected class_310 client = class_310.method_1551();
    protected boolean isValid = false;
    protected class_1657 player;
    protected class_638 level;
    protected LoopingSound soundInstance = null;
    protected float blendScaling = 1.0f;
    protected float volumeScaleFade = 0.005f;

    protected BiomeSound(class_1657 player) {
        this.player = player;
        this.level = (class_638)player.field_6002;
    }

    public abstract boolean isValidBiomeCondition(class_6880<class_1959> var1, class_5321<class_1959> var2);

    @Override
    public void updatePlayer(class_1657 player) {
        this.player = player;
        this.level = (class_638)player.field_6002;
    }

    @Override
    public class_638 getLevel() {
        return this.level;
    }

    @Override
    public class_1657 getPlayer() {
        return this.player;
    }

    @Override
    public class_1101 getSoundInstance() {
        return this.soundInstance;
    }

    @Override
    public void tick() {
        boolean nowValid = this.isValid();
        if (this.isValid && !nowValid) {
            this.isValid = false;
        }
        if (!this.isValid && nowValid) {
            this.isValid = true;
        }
        if (this.isValid) {
            float volume = this.getVolume() * this.getVolumeScaling() * this.blendScaling;
            if (!this.isPlaying()) {
                this.soundInstance = new LoopingSound(this.player, this.getSound(), volume, this.getPitch(), p -> this.isValid);
                try {
                    this.getSoundManager().method_4873((class_1113)this.soundInstance);
                }
                catch (ConcurrentModificationException e) {
                    LogHelper.debug(this.getClass(), "Exception in tick", new Object[0]);
                }
            } else if (this.soundInstance.maxVolume != volume) {
                this.soundInstance.maxVolume = this.soundInstance.maxVolume < volume ? (this.soundInstance.maxVolume += this.volumeScaleFade) : (this.soundInstance.maxVolume -= this.volumeScaleFade);
            }
        }
    }

    @Override
    public boolean isValid() {
        if (this.client.field_1687 == null || this.level == null) {
            return false;
        }
        if (!this.player.method_5805()) {
            return false;
        }
        if (!this.isValidPlayerCondition()) {
            return false;
        }
        if (!BiomeAmbience.VALID_DIMENSIONS.contains(this.level.method_27983().method_29177())) {
            return false;
        }
        class_2338 pos = this.player.method_24515();
        float blend = BiomeAmbience.biomeBlend;
        if (blend > 0.0f) {
            List<class_2350> directions = List.of(class_2350.field_11034, class_2350.field_11039, class_2350.field_11043, class_2350.field_11035);
            for (class_2350 direction : directions) {
                int i = 0;
                while ((float)i < blend) {
                    class_5321<class_1959> key;
                    class_2338 relativePos = pos.method_10079(direction, i);
                    class_6880<class_1959> holder = this.getBiomeHolder(relativePos);
                    if (this.isValidBiomeCondition(holder, key = this.getBiomeKey(relativePos))) {
                        this.blendScaling = 1.0f - (float)i / blend;
                        return true;
                    }
                    i += 2;
                }
            }
        } else {
            class_5321<class_1959> key;
            class_6880<class_1959> holder = this.getBiomeHolder(pos);
            if (this.isValidBiomeCondition(holder, key = this.getBiomeKey(pos))) {
                this.blendScaling = 1.0f;
                return true;
            }
        }
        return false;
    }
}

