/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.helper;

import com.google.common.collect.Lists;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import svenhjol.charmonium.Charmonium;

public class ClassHelper {
    public static List<String> getClassesInPackage(String packageName) throws IOException, URISyntaxException {
        String path = packageName.replace(".", "/");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        ArrayList<String> classes = new ArrayList<String>();
        URL classLoaderResource = classLoader.getResource(path);
        if (classLoaderResource == null) {
            throw new IOException("Could not create class loader resource URL for package: " + packageName);
        }
        URL url = new URL(classLoaderResource.toString());
        if (url.toString().startsWith("jar:")) {
            try {
                JarURLConnection connection = (JarURLConnection)url.openConnection();
                File file = new File(connection.getJarFileURL().toURI());
                packageName = packageName.replaceAll("\\.", "/");
                try {
                    JarEntry jarEntry;
                    JarInputStream jarFile = new JarInputStream(new FileInputStream(file));
                    while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                        if (!jarEntry.getName().startsWith(packageName) || !jarEntry.getName().endsWith(".class")) continue;
                        classes.add(jarEntry.getName().replaceAll("/", "\\.").replace(".class", ""));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                throw new IOException("Failed to open jar file: " + e.getMessage());
            }
        } else {
            File dir = new File(classLoaderResource.toURI());
            classes.addAll(ClassHelper.findClasses(dir, packageName));
        }
        return classes.stream().distinct().collect(Collectors.toList());
    }

    public static List<String> findClasses(File directory, String packageName) throws IOException {
        ArrayList<String> classes = new ArrayList<String>();
        if (!directory.exists()) {
            return classes;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Could not get files from class directory: " + directory);
        }
        for (File file : files) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(ClassHelper.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(packageName + "." + file.getName().substring(0, file.getName().length() - 6));
        }
        return classes;
    }

    public static Iterable<ClassPath.ClassInfo> getClassesInPackage(ClassLoader classLoader, String packageName) {
        try {
            List<String> classes = ClassHelper.getClassesInPackage(packageName);
            Constructor constructor = ClassPath.ClassInfo.class.getDeclaredConstructor(File.class, String.class, ClassLoader.class);
            constructor.setAccessible(true);
            ArrayList out = Lists.newArrayList();
            File file = new File(Charmonium.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            for (String c : classes) {
                if (!c.startsWith(packageName)) continue;
                String resource = c.replace('.', '/') + ".class";
                out.add((ClassPath.ClassInfo)constructor.newInstance(file, resource, classLoader));
            }
            return out;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static <T> List<Class<T>> getClassesInPackage(String packageName, String matchAnnotation) {
        Logger logger = LogManager.getLogger();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Iterable<ClassPath.ClassInfo> packageClasses = ClassHelper.getClassesInPackage(classLoader, packageName);
        ArrayList<Class<T>> discoveredClasses = new ArrayList<Class<T>>();
        for (ClassPath.ClassInfo c : packageClasses) {
            String className = c.getName();
            String truncatedName = className.substring(packageName.length() + 1);
            try {
                ClassReader classReader = new ClassReader(c.asByteSource().read());
                ClassNode node = new ClassNode();
                classReader.accept((ClassVisitor)node, 7);
                if (node.visibleAnnotations == null || node.visibleAnnotations.isEmpty()) continue;
                for (AnnotationNode annotation : node.visibleAnnotations) {
                    if (!annotation.desc.equals(matchAnnotation)) continue;
                    discoveredClasses.add(Class.forName(c.getName()));
                }
            }
            catch (Exception e) {
                logger.error("Error occurred while processing class " + truncatedName + ": " + e.getMessage());
            }
        }
        return discoveredClasses;
    }
}

