function minecraftify(str) {
    str = str.replace(/^\s+|\s+$/g, ''); // trim leading/trailing white space
    str = str.toLowerCase(); // convert string to lowercase
    str = str.replace(/[^a-z0-9 -]/g, '') // remove any non-alphanumeric characters
        .replace(/\s+/g, '_') // replace spaces with underscore
        .replace(/-+/g, '_'); // remove consecutive underscore
    return str;
}

RecipeViewerEvents.removeEntries("item", event => {
    event.remove([
        /railways:.+_incomplete_conductor_cap/,
        /railways:track_incomplete/,
        /^storagedrawers:.+upgrade_bound$/
    ])
})

RecipeViewerEvents.groupEntries("item", event => {
    // Combine items that are identical with NBT differences.
    const nbtitems = ["minecraft:painting", "minecraft:suspicious_stew", "minecraft:goat_horn"];

    nbtitems.forEach(id => {
        const item = Item.of(id)
        event.group(id, `roughlyenoughitems:${item.idLocation.path}`, item.displayName)
    });

    // Combine items using regex
    const regexitems = {
        "Pottery Sherd": /_pottery_sherd$/,
        "Armor Trim Smithing Templates": /_armor_trim_smithing_template$/,
        "Glyphs": /^ars_nouveau:glyph_/,
        "Tablets": /^ars_nouveau:ritual_/,
        "Threads": /^ars_nouveau:thread_/,
        "Upgrades": /^storagedrawers:.*upgrade$/
    }

    Object.entries(regexitems).forEach(([k, v]) => {
        event.group(v, `roughlyenoughitems:${minecraftify(k)}`, k)
    })

    // Combine items using tags
    const chippedTags = ["cyan_carpet", "special_lantern", "acacia_planks", "orange_wool", "glass", "cherry_planks",
        "end_stone", "stripped_oak_log", "spruce_leaves", "white_concrete", "crimson_door", "coal_block", "black_wool",
        "ladder", "blue_stained_glass", "pointed_dripstone", "purple_terracotta", "oak_door", "lantern", "packed_ice",
        "black_terracotta", "waxed_weathered_copper", "red_glazed_terracotta", "purple_glazed_terracotta",
        "red_sandstone", "warped_wart_block", "spruce_planks", "special_soul_lantern", "prismarine", "magenta_wool",
        "birch_log", "mangrove_trapdoor", "orange_concrete", "cherry_log", "bricks", "nether_bricks", "yellow_concrete",
        "bamboo_planks", "mangrove_roots", "deepslate", "brown_terracotta", "blue_concrete", "magenta_stained_glass",
        "raw_copper_block", "diamond_block", "gravel", "light_gray_stained_glass_pane", "yellow_stained_glass_pane",
        "orange_carpet", "magenta_concrete", "hay_block", "waxed_exposed_copper_block", "blue_terracotta",
        "white_carpet", "black_stained_glass_pane", "green_concrete", "blue_wool", "redstone_block", "dirt",
        "light_gray_stained_glass", "amethyst_block", "red_nether_bricks", "iron_bars", "pink_stained_glass_pane",
        "warped_planks", "warped_trapdoor", "cyan_terracotta", "dark_oak_door", "acacia_leaves", "brown_wool",
        "blue_ice", "lime_stained_glass_pane", "black_glazed_terracotta", "purple_wool", "glowstone", "barrel",
        "light_blue_concrete", "lime_terracotta", "yellow_wool", "cyan_glazed_terracotta", "lodestone", "spruce_log",
        "ochre_froglight", "cyan_stained_glass", "red_wool", "sandstone", "white_stained_glass",
        "cyan_stained_glass_pane", "redstone_lamp", "brown_glazed_terracotta", "lily_pad", "orange_terracotta",
        "crimson_trapdoor", "crimson_planks", "dark_oak_planks", "light_gray_concrete", "warped_roots", "birch_planks",
        "oak_leaves", "jungle_door", "shroomlight", "stripped_cherry_log", "melon", "red_mushroom", "tuff",
        "green_glazed_terracotta", "soul_lantern", "orange_glazed_terracotta", "brown_stained_glass", "brown_mushroom",
        "orange_stained_glass", "pink_terracotta", "moss_block", "cherry_trapdoor", "crimson_fungus", "magenta_carpet",
        "light_gray_terracotta", "basalt", "red_stained_glass", "verdant_froglight", "raw_iron_block", "pink_carpet",
        "gray_stained_glass_pane", "pink_wool", "magenta_terracotta", "gilded_blackstone", "white_terracotta",
        "purple_stained_glass", "mangrove_planks", "light_gray_glazed_terracotta", "warped_door", "ancient_debris",
        "soul_sand", "magenta_stained_glass_pane", "calcite", "granite", "warped_stem", "cobblestone", "blue_carpet",
        "yellow_glazed_terracotta", "jack_o_lantern", "dried_kelp_block", "white_wool", "crimson_roots",
        "mushroom_stem", "terracotta", "light_gray_carpet", "light_blue_glazed_terracotta", "yellow_terracotta",
        "oak_planks", "andesite", "bone_block", "purpur_block", "emerald_block", "warped_fungus", "gray_terracotta",
        "stripped_acacia_log", "sponge", "dark_oak_leaves", "black_concrete", "blue_stained_glass_pane",
        "lime_glazed_terracotta", "gray_wool", "red_concrete", "cyan_concrete", "diorite", "sand",
        "blue_glazed_terracotta", "sea_lantern", "red_terracotta", "dripstone_block", "lime_wool", "gray_concrete",
        "vine", "cobweb", "yellow_stained_glass", "green_stained_glass_pane", "netherrack", "brown_mushroom_block",
        "stripped_jungle_log", "bookshelf", "borderless_bricks", "brown_carpet", "pumpkin", "pink_stained_glass",
        "dark_oak_trapdoor", "light_gray_wool", "mud", "red_carpet", "purple_stained_glass_pane",
        "light_blue_stained_glass", "crimson_stem", "waxed_copper_block", "cherry_door", "jungle_planks",
        "dark_prismarine", "red_stained_glass_pane", "oak_log", "quartz_block", "lime_concrete", "bamboo_door",
        "pink_glazed_terracotta", "waxed_oxidized_copper", "mossy_stone_bricks", "pearlescent_froglight",
        "jungle_leaves", "stripped_spruce_log", "green_terracotta", "clay", "acacia_door", "snow_block",
        "gray_glazed_terracotta", "nether_wart_block", "torch", "stripped_warped_stem", "black_stained_glass",
        "nether_sprouts", "acacia_log", "dark_oak_log", "packed_mud", "mossy_cobblestone", "spruce_trapdoor",
        "gray_carpet", "lime_stained_glass", "lapis_block", "light_blue_stained_glass_pane", "carved_pumpkin",
        "purple_concrete", "green_stained_glass", "green_wool", "jungle_trapdoor", "white_stained_glass_pane",
        "spruce_door", "brown_concrete", "blackstone", "crying_obsidian", "magma_block", "stripped_dark_oak_log",
        "acacia_trapdoor", "oak_trapdoor", "red_mushroom_block", "ice", "orange_stained_glass_pane", "birch_leaves",
        "redstone_torch", "magenta_glazed_terracotta", "jungle_log", "birch_door", "gray_stained_glass",
        "stripped_mangrove_log", "raw_gold_block", "stripped_birch_log", "light_blue_wool", "smooth_stone",
        "yellow_carpet", "glass_pane", "brown_stained_glass_pane", "stripped_crimson_stem", "purple_carpet",
        "pink_concrete", "lime_carpet", "iron_block", "black_carpet", "mud_bricks", "birch_trapdoor", "cyan_wool",
        "mangrove_door", "light_blue_terracotta", "green_carpet", "obsidian", "mangrove_log", "white_glazed_terracotta",
        "stone", "bamboo_trapdoor", "gold_block", "light_blue_carpet", "netherite_block"];

    chippedTags.forEach(tag =>
        event.group(`#chipped:${tag}`, `kubejs:chipped/${tag}`, tag.split("_").filter(x => x.length > 0).map((x) => (x.charAt(0).toUpperCase() + x.slice(1))).join(" ")))

    // Combine the tags that aren't chipped.
    const tags = ["minecraft:trim_templates", "minecraft:shulker_boxes", "minecraft:signs", "minecraft:hanging_signs",
        "supplementaries:concrete_powders", "minecraft:decorated_pot_sherds", "create:tracks", "railways:locometal",
        "storagedrawers:drawers", "comforts:sleeping_bags", "comforts:hammocks", "fwaystones:waystones",
        "supplementaries:flags", "supplementaries:presents", "supplementaries:trapped_presents",
        "supplementaries:awnings", "supplementaries:candle_holders", "supplementaries:sign_posts",
        "handcrafted:cushions", "handcrafted:sheets", "handcrafted:benches", "handcrafted:couches",
        "handcrafted:chairs", "handcrafted:dining_benches", "handcrafted:side_tables", "handcrafted:desks",
        "handcrafted:nightstands", "handcrafted:tables", "handcrafted:fancy_beds", "handcrafted:counters",
        "handcrafted:cupboards", "handcrafted:drawers", "handcrafted:shelves", "handcrafted:trims", "handcrafted:pots",
        "handcrafted:trophies", "handcrafted:crockery", "minecraft:candles", "railways:palettes/dye_groups/slashed",
        "railways:palettes/dye_groups/riveted", "railways:palettes/dye_groups/pillar",
        "railways:palettes/dye_groups/smokebox", "railways:palettes/dye_groups/plated",
        "railways:palettes/dye_groups/flat_slashed", "railways:palettes/dye_groups/flat_riveted",
        "railways:palettes/dye_groups/brass_wrapped_slashed", "railways:palettes/dye_groups/copper_wrapped_slashed",
        "railways:palettes/dye_groups/iron_wrapped_slashed", "railways:locometal_boilers", "create:toolboxes",
        "dramaticdoors:tall_doors", "minecraft:boats", "supplementaries:bamboo_spikes",
        "travelersbackpack:custom_travelers_backpack", "storagedrawers:keyrings", "supplementaries:way_signs",
        "supplementaries:cannon_boats", "supplementaries:buntings"
    ];

    tags.forEach(tag =>
        event.group(`#${tag}`, `kubejs:${tag.split(":").join("/")}`, tag.split(":")[1].split("_").filter(x => x.length > 0).map((x) => (x.charAt(0).toUpperCase() + x.slice(1))).join(" ")))
})
