/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.item;

import com.nick.chimes.block.ChimesBlocks;
import com.nick.chimes.block.WindBellBlock;
import com.nick.chimes.component.ChimesComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.WaterFluid;
import net.minecraft.world.phys.BlockHitResult;

public class WindBellItem
extends BlockItem {
    public WindBellItem(WindBellBlock p_40565_, Item.Properties p_40566_) {
        super((Block)p_40565_, p_40566_);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        this.washOffDye(level, player, hand);
        return super.use(level, player, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        this.washOffDye(context.getLevel(), context.getPlayer(), context.getHand());
        return super.useOn(context);
    }

    public void washOffDye(Level level, Player player, InteractionHand hand) {
        BlockHitResult hitResult = WindBellItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.WATER);
        BlockPos blockpos = hitResult.getBlockPos();
        ItemStack playerHandItem = player.getItemInHand(hand);
        BlockState blockState = level.getBlockState(blockpos);
        FluidState fluidState = level.getFluidState(blockpos);
        if ((playerHandItem.has(ChimesComponents.GLASS_BELL_BASE_COLOR) || playerHandItem.has(ChimesComponents.GLASS_BELL_TAG_COLOR)) && (fluidState.getType() instanceof WaterFluid || blockState.is(Blocks.WATER_CAULDRON)) && level.getBlockState(blockpos.above()).isAir()) {
            player.swing(hand, false);
            playerHandItem.shrink(1);
            player.getCommandSenderWorld().playSound(null, WindBellItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY).getBlockPos(), SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 0.5f, 2.0f);
            if (player.getItemInHand(hand).getCount() == 0) {
                player.setItemInHand(hand, new ItemStack((ItemLike)ChimesBlocks.GLASSBELLSITEM, 1));
            } else if (!player.getInventory().add(new ItemStack((ItemLike)ChimesBlocks.GLASSBELLSITEM, 1))) {
                player.drop(new ItemStack((ItemLike)ChimesBlocks.GLASSBELLSITEM, 1), false);
            }
            if (level.getBlockState(blockpos.above()).isAir() && !player.isUnderWater()) {
                for (int i = 0; i < 10; ++i) {
                    level.addParticle((ParticleOptions)ParticleTypes.SPLASH, hitResult.getLocation().get(Direction.Axis.X) + Math.random() * 0.5 - 0.25, level.getBlockState(blockpos).is(Blocks.WATER_CAULDRON) ? (double)(WindBellItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.WATER).getBlockPos().getY() + 1) : WindBellItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.WATER).getLocation().get(Direction.Axis.Y), WindBellItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.WATER).getLocation().get(Direction.Axis.Z) + Math.random() * 0.5 - 0.25, 0.0, 0.1, 0.0);
                }
            }
            if (level.getBlockState(blockpos).is(Blocks.WATER_CAULDRON) && !player.isCreative()) {
                if ((Integer)level.getBlockState(blockpos).getValue((Property)BlockStateProperties.LEVEL_CAULDRON) > 1) {
                    level.setBlock(blockpos, (BlockState)level.getBlockState(blockpos).setValue((Property)BlockStateProperties.LEVEL_CAULDRON, (Comparable)Integer.valueOf((Integer)level.getBlockState(blockpos).getValue((Property)BlockStateProperties.LEVEL_CAULDRON) - 1)), 1);
                } else {
                    level.setBlock(blockpos, Blocks.CAULDRON.defaultBlockState(), 35);
                }
            }
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
        CompoundTag compoundtag = new CompoundTag();
        if (itemStack.getComponents().has(ChimesComponents.GLASS_BELL_BASE_COLOR) || itemStack.getComponents().has(ChimesComponents.GLASS_BELL_TAG_COLOR)) {
            if (itemStack.getComponents().has(ChimesComponents.GLASS_BELL_BASE_COLOR)) {
                list.add((Component)Component.translatable((String)("block.glass_wind_bell." + (String)itemStack.getComponents().get(ChimesComponents.GLASS_BELL_BASE_COLOR) + ".base")).withStyle(ChatFormatting.GRAY));
            }
            if (itemStack.getComponents().has(ChimesComponents.GLASS_BELL_TAG_COLOR)) {
                list.add((Component)Component.translatable((String)("block.glass_wind_bell." + (String)itemStack.getComponents().get(ChimesComponents.GLASS_BELL_TAG_COLOR) + ".tag")).withStyle(ChatFormatting.GRAY));
            }
        } else {
            list.add((Component)Component.translatable((String)"Customizable").withStyle(ChatFormatting.GRAY));
        }
    }
}

