/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.block;

import com.mojang.serialization.MapCodec;
import com.nick.chimes.block.ChimesBlocks;
import com.nick.chimes.block.entity.WindChimeBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindChimeBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public WindChimeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, WATERLOGGED, FACING});
    }

    protected static void removeBottomHalf(Level world, BlockPos pos, BlockState state, Player player) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER && world.getBlockState(pos.above()).getBlock() == state.getBlock() && world.getBlockState(pos.above()).getValue(HALF) == DoubleBlockHalf.UPPER) {
            if (!((Boolean)world.getBlockState(pos.above()).getValue((Property)WATERLOGGED)).booleanValue()) {
                world.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 35);
            } else {
                world.setBlock(pos.above(), Blocks.WATER.defaultBlockState(), 35);
            }
        }
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.isClientSide) {
            if (player.isCreative()) {
                WindChimeBlock.removeBottomHalf(worldIn, pos, state, player);
            } else {
                WindChimeBlock.dropResources((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        super.playerWillDestroy(worldIn, pos, state, player);
        return state;
    }

    public void playerDestroy(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.playerDestroy(worldIn, player, pos, Blocks.AIR.defaultBlockState(), te, stack);
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.setBlock(pos, (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 10);
        worldIn.setBlock(pos.below(), (BlockState)((BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.getFluidState(pos.below()).is((Fluid)Fluids.WATER))), 10);
    }

    public void entityInside(BlockState p_60495_, Level p_60496_, BlockPos p_60497_, Entity p_60498_) {
        super.entityInside(p_60495_, p_60496_, p_60497_, p_60498_);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((DoubleBlockHalf)stateIn.getValue(HALF)).equals((Object)DoubleBlockHalf.UPPER) ? worldIn.getBlockState(currentPos.below()).getBlock() != this || !this.canSurvive(facingState, (LevelReader)worldIn, currentPos) : worldIn.getBlockState(currentPos.above()).getBlock() != this) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        if (pos.getY() < context.getLevel().getMaxBuildHeight() && context.getLevel().getBlockState(pos.below()).canBeReplaced(context)) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(pos).is((Fluid)Fluids.WATER)));
        }
        return null;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return !worldIn.getBlockState(pos.above()).getCollisionShape((BlockGetter)worldIn, pos).getFaceShape(Direction.DOWN).isEmpty() || worldIn.getBlockState(pos.above()).isFaceSturdy((BlockGetter)worldIn, pos, Direction.DOWN);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean triggerEvent(BlockState state, Level worldIn, BlockPos pos, int id, int param) {
        super.triggerEvent(state, worldIn, pos, id, param);
        return worldIn.getBlockEntity(pos) == null ? false : worldIn.getBlockEntity(pos).triggerEvent(id, param);
    }

    public RenderShape getRenderShape(BlockState p_49753_) {
        return RenderShape.MODEL;
    }

    protected boolean chime(Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (!world.isClientSide && tileentity instanceof WindChimeBE) {
            ((WindChimeBE)tileentity).chime();
            return true;
        }
        return false;
    }

    public void playChimeSound(Level world, BlockPos pos) {
        this.playChimeSound(world, pos);
    }

    public void playTieSound(Level world, BlockPos pos) {
        this.playTieSound(world, pos);
    }

    public void setChiming(BlockState state, Level level, BlockPos pos) {
        this.chime(level, pos);
        this.playChimeSound(level, pos);
        if (((DoubleBlockHalf)state.getValue(HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
            this.chime(level, pos.below());
        } else {
            this.chime(level, pos.above());
        }
    }

    public void attack(BlockState state, Level level, BlockPos pos, Player player) {
        if (!player.getMainHandItem().is(Items.STICK)) {
            this.playChimeSound(level, pos);
        }
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level worldIn, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (!(player.getMainHandItem().getItem() instanceof AxeItem)) {
            this.playChimeSound(worldIn, pos);
            this.chime(worldIn, pos);
            if (worldIn.getBlockState(pos).getValue(HALF) == DoubleBlockHalf.UPPER && worldIn.getBlockState(pos.below()).getBlock() == ChimesBlocks.AMETHYSTCHIMES) {
                this.chime(worldIn, pos.below());
            } else if (worldIn.getBlockState(pos).getValue(HALF) == DoubleBlockHalf.LOWER && worldIn.getBlockState(pos.above()).getBlock() == ChimesBlocks.AMETHYSTCHIMES) {
                this.chime(worldIn, pos.above());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    public boolean isPathfindable(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    public void onProjectileHit(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos pos = hit.getBlockPos();
        this.chime(worldIn, pos);
        this.playChimeSound(worldIn, pos);
        this.setChiming(state, worldIn, pos);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level p_153212_, @NotNull BlockState p_153213_, @NotNull BlockEntityType<T> p_153214_) {
        return (p_155253_, p_155254_, p_155255_, p_155256_) -> ((WindChimeBE)p_155256_).tick();
    }
}

