/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.block;

import com.mojang.serialization.MapCodec;
import com.nick.chimes.block.ChimesBlocks;
import com.nick.chimes.block.entity.WindBellBE;
import com.nick.chimes.sound.ChimesSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WindBellBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape glass = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    private static final VoxelShape rim = Block.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0);
    private static final VoxelShape glasschime = Shapes.or((VoxelShape)glass, (VoxelShape)rim);

    public WindBellBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return glasschime;
    }

    public void setPlacedBy(Level p_48668_, BlockPos p_48669_, BlockState p_48670_, LivingEntity p_48671_, ItemStack p_48672_) {
        if (p_48668_.isClientSide) {
            p_48668_.getBlockEntity(p_48669_, ChimesBlocks.WIND_BELL_BLOCK_ENTITY).ifPresent(p_187404_ -> p_187404_.fromItem(p_48672_));
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        if (pos.getY() < context.getLevel().getMaxBuildHeight() && context.getLevel().getBlockState(pos).canBeReplaced(context)) {
            return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(pos).is((Fluid)Fluids.WATER)));
        }
        return null;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        return blockentity instanceof WindBellBE ? ((WindBellBE)blockentity).getItem() : super.getCloneItemStack(level, pos, state);
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return super.getRenderShape(blockState);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!this.canSurvive(facingState, (LevelReader)worldIn, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected boolean isValidGround(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return !state.getCollisionShape(worldIn, pos).getFaceShape(Direction.DOWN).isEmpty() || state.isFaceSturdy(worldIn, pos, Direction.DOWN);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return this.isValidGround(worldIn.getBlockState(pos.above()), (BlockGetter)worldIn, pos.above());
    }

    public boolean triggerEvent(BlockState state, Level worldIn, BlockPos pos, int id, int param) {
        BlockEntity tileentity = worldIn.getBlockEntity(pos);
        super.triggerEvent(state, worldIn, pos, id, param);
        return tileentity == null ? false : tileentity.triggerEvent(id, param);
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource randomSource) {
        if (level.isClientSide) {
            float chance;
            float f = chance = pos.getX() * 4 % 2 == 0 ? 1.0f : 1.0f;
            if (randomSource.nextDouble() < 0.25) {
                level.playLocalSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), ChimesSounds.GLASSCHIME, SoundSource.AMBIENT, 1.0f, 1.45f, false);
            }
        }
    }

    public boolean chime(Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (!world.isClientSide && tileentity instanceof WindBellBE) {
            ((WindBellBE)tileentity).chime();
            return true;
        }
        return false;
    }

    public void attack(BlockState state, Level level, BlockPos pos, Player player) {
        level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f), ChimesSounds.GLASSCHIME, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    protected InteractionResult useWithoutItem(BlockState p_60503_, Level p_60504_, BlockPos p_60505_, Player p_60506_, BlockHitResult p_60508_) {
        this.chime(p_60504_, p_60505_);
        p_60504_.playSound(null, (double)((float)p_60505_.getX() + 0.5f), (double)p_60505_.getY(), (double)((float)p_60505_.getZ() + 0.5f), ChimesSounds.GLASSCHIME, SoundSource.BLOCKS, 0.5f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    public void onProjectileHit(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockpos = hit.getBlockPos();
        if (projectile instanceof ThrownTrident || projectile instanceof Arrow) {
            worldIn.destroyBlock(hit.getBlockPos(), true);
        } else {
            worldIn.playSound(null, (double)((float)blockpos.getX() + 0.5f), (double)blockpos.getY(), (double)((float)blockpos.getZ() + 0.5f), ChimesSounds.GLASSCHIME, SoundSource.BLOCKS, 1.2f, 1.0f);
            this.chime(worldIn, blockpos);
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return (p_155253_, p_155254_, p_155255_, p_155256_) -> ((WindBellBE)p_155256_).tick();
    }

    public BlockEntity newBlockEntity(BlockPos p_152198_, BlockState p_152199_) {
        return new WindBellBE(p_152198_, p_152199_);
    }
}

