/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.IEditing;
import com.mrcrayfish.configured.client.screen.TooltipScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.tuple.Pair;

public class EditStringScreen
extends TooltipScreen
implements IEditing {
    private final Screen parent;
    private final IModConfig config;
    private final String originalValue;
    private final Function<String, Pair<Boolean, Component>> validator;
    private final Consumer<String> onSave;
    private Button doneButton;
    private EditBox textField;
    private Component validationHint;
    private String value;

    protected EditStringScreen(Screen parent, IModConfig config, Component component, String originalValue, Function<String, Pair<Boolean, Component>> validator, Consumer<String> onSave) {
        super(component);
        this.parent = parent;
        this.config = config;
        this.originalValue = originalValue;
        this.validator = validator;
        this.onSave = onSave;
        this.value = this.originalValue;
    }

    protected void init() {
        this.textField = new EditBox(this.font, this.width / 2 - 130, this.height / 2 - 25, 260, 20, CommonComponents.EMPTY);
        this.textField.setMaxLength(32500);
        this.textField.setValue(this.value);
        this.textField.setResponder(s -> {
            this.value = s;
            this.updateValidation();
        });
        this.textField.setEditable(!this.config.isReadOnly());
        this.addRenderableWidget((GuiEventListener)this.textField);
        this.doneButton = (Button)this.addRenderableWidget((GuiEventListener)new IconButton(this.width / 2 - 1 - 130, this.height / 2 + 13, 0, 44, 128, (Component)Component.translatable((String)"configured.gui.apply"), button -> {
            String text = this.textField.getValue();
            if (((Boolean)this.validator.apply(text).getLeft()).booleanValue()) {
                this.onSave.accept(text);
                this.minecraft.setScreen(this.parent);
            }
        }));
        this.addRenderableWidget((GuiEventListener)ScreenUtil.button(this.width / 2 + 3, this.height / 2 + 13, 128, 20, CommonComponents.GUI_CANCEL, button -> this.minecraft.setScreen(this.parent)));
        this.updateValidation();
    }

    protected void updateValidation() {
        Pair<Boolean, Component> result = this.validator.apply(this.textField.getValue());
        boolean valid = (Boolean)result.getLeft();
        this.doneButton.active = !this.config.isReadOnly() && valid;
        this.textField.setTextColor(valid || this.textField.getValue().isEmpty() ? -1 : -65536);
        this.validationHint = !valid ? (Component)result.getRight() : null;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean showValidationHint;
        this.resetTooltip();
        super.render(graphics, mouseX, mouseY, partialTicks);
        ConfirmationScreen.drawListBackground(graphics, 0, this.width, this.textField.getY() - 10, this.textField.getY() + 20 + 10);
        this.textField.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, this.height / 2 - 50, 0xFFFFFF);
        boolean bl = showValidationHint = this.validationHint != null;
        if (showValidationHint) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.blit(IconButton.ICONS, this.textField.getX() - 20, this.textField.getY() + 3, 16, 16, 11.0f, 11.0f, 11, 11, 64, 64);
            if (ScreenUtil.isMouseWithin(this.textField.getX() - 20, this.textField.getY() + 3, 16, 16, mouseX, mouseY)) {
                this.setActiveTooltip(this.validationHint, -1428357120);
            }
        }
        this.drawTooltip(graphics, mouseX, mouseY);
    }

    @Override
    public IModConfig getActiveConfig() {
        return this.config;
    }
}

