# Красный интерфейс
![Весь красный](block:oc2:redstone_interface)

Красный интерфейс предоставляет двунаправленную шину для получения и излучения красного сигнала.

Используйте его для взаимодействия с примитивными устройствами, такими как двери, лампы и другие устройства, работающие с красным камнем.

Это высокоуровневое устройство, поэтому оно контролируется через высокоуровневое API (HLAPI). В дистрибутив Linux включена Lua библиотека для работы с данным API. Например:  
`local d = require("devices")`  
`local r = d:find("redstone")`  
`r:setRedstoneOutput("up", 15)`

## API
Название устройства: `redstone`

### Стороны
В вышеуказанном методе первый параметр указывает, с какой стороны подавать или снимать красный сигнал. Допускаются значения: `up`, `down`, `left`, `right`, `front`, `back`, `north`, `south`, `west` и `east`.

Каждая сторона блока имеет метку для удобства опознавания. Названия сторон даны относительно лицевой стороны блока (помечен одной точкой). Если смотреть на лицевую сторону, то:
- `front` и `south` - сторона, на которую мы смотрим.
- `back` и `north` - задняя сторона блока.
- `left` и `west` - сторона слева от нас.
- `right` и `east` - сторона справа от нас.
- `up` и `down` - верхняя и нижняя сторона соответственно.

### Методы
`getRedstoneInput(side):number` возвращает уровень красного сигнала, полученного с указанной стороны.
- `side` - строка, указывающая на сторону, сигнал с которой нужно получить. Смотрите в раздел "Стороны".
- Возвращает числовой уровень текущего сигнала на входе.

`setRedstoneOutput(side, value:number)` задает уровень сигнала, излучаемый с указанной стороны.
- `side` - строка, указывающая на сторону, куда нужно подать сигнал. Смотрите в раздел "Стороны".
- `value` - числовой уровень сигнала, который нужно подать. Лежит в пределах [0, 15].

`getRedstoneOutput(side):number` возвращает уровень красного сигнала, излучаемого с указанной стороны.
- `side` - строка, указывающая на сторону, сигнал с которой нужно получить. Смотрите в раздел "Стороны".
- Возвращает числовой уровень текущего сигнала на выходе.