# Основы
Данный документ содержит основную информацию о том, как работают [компьютеры](block/computer.md). Но это не значит, что данную информацию будет легко понять. Под основами здесь имеются ввиду основные концепты, применяемые в моде.

## Архитектура
Компьютеры работают на одноядерной RISC-V архитектуре общего назначения. Она имеет 64-битные регистры и поддержку операций с плавающей запятой. Это позволяет запускать на компьютерах современное Linux ядро.

### Нативные устройства
Подключенные к компьютеру нативные устройства являются прикрепленными к памяти. Это означает, что они прикреплены к определенной области физической памяти. Для взаимодействия с ними используются стандартные драйвера Linux.

Информация о том, какие устройства доступны и где они находятся, передается в программное обеспечение с помощью плоского дерева устройств. Эта структура данных может содержать дополнительную информацию о системе в целом. В частности, он также содержит размер установленной [памяти](item/memory.md). Поскольку эта структура создается во время загрузки, она не обновляется. Именно поэтому компьютеры необходимо перезагружать при смене нативных устройств, таких как [сетевая интерфейсная карта](item/network_interface_card.md). Данный тип устройств имеет в подсказке строчку, сообщающую о необходимости перезагрузки компьютера для их определения.

### Устройства HLAPI
Другим типом устройств являются устройства с высокоуровневым API, иногда называемыми устройствами RPC. Данные устройства используют общий контроллер, который связывается с компьютером через последовательное устройство. Данный контроллер имеется во всех компьютерах и отвечает за сбор сообщений с нескольких устройств и отправку сообщений на них. Протокол этих контроллеров использует простые сообщения со структурой JSON. Lua библиотека `devices`, поставляемая со стандартными библиотеками Lua, является оберткой последовательного устройства, используемого для подключения к контроллеру. Поэтому *настоятельно* рекомендуется использовать эту библиотеку для работы с HLAPI устройствами, такими как [красный интерфейсный блок](block/redstone_interface.md).

Из-за особенностей используемого протокола скорость передачи данных серьезно ограничена. Поэтому большинство устройств предоставляют несложные API, которые обычно не требуют отправки больших объемов данных.

## Конфигурация
Компьютеры можно конфигурировать на свое усмотрение. Количество ОЗУ, дополнительные хранилища в виде [жестких дисков](item/hard_drive.md), и что более важно, вы можете сами выбирать, какие карты стоит установить. Не забывайте, что стандартная конфигурация Linux требует не менее 20Мб ОЗУ, а лучше поставить 24Мб.

Большинство компонентов увеличивают потребление энергии компьютером. Для экономии рекомендуется устанавливать только необходимые компоненты.

## Linux
Стандартная конфигурация Linux включает некоторые базовые команды, а также возможность написания и запуска программ на Lua. Для ознакомления с примером работы с устройствами HLAPI в Lua, загляните в раздел [скрипты](scripting.md).

Нативные устройства используют стандартные драйвера Linux. Например, жесткие диски отображаются как устройства `/dev/vdaX`, поэтому их можно форматировать и монтировать как обычно.

Компьютеры имеют два аппаратных модуля часов (RTC). Первый считает время, соответствующее реальному. Он используется по умолчанию, например с командами `date` и `time`. Второй считает время игрового мира, в котором находится компьютер. Чтобы посмотреть его, воспользуйтесь командой `hwclock -f /dev/rtc1`.