/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy;

import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.WireConnectResult;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.index.CAItems;
import com.mrh0.createaddition.item.WireSpool;
import com.mrh0.createaddition.util.Util;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public interface IWireNode {
    public static final int MAX_LENGTH = (Integer)Config.CONNECTOR_MAX_LENGTH.get();

    public Vec3 getNodeOffset(int var1);

    default public int getNodeFromPos(Vec3 vector3d) {
        return 0;
    }

    default public int getNodeCount() {
        return 1;
    }

    public static boolean hasPos(CompoundTag nbt, int node) {
        return nbt.m_128441_("x" + node) && nbt.m_128441_("y" + node) && nbt.m_128441_("z" + node);
    }

    public static boolean hasNode(CompoundTag nbt, int node) {
        return IWireNode.hasPos(nbt, node) && nbt.m_128441_("type" + node);
    }

    default public int findOpenNode(int from, int to) {
        for (int i = from; i < to; ++i) {
            if (this.hasConnection(i)) continue;
            return i;
        }
        return -1;
    }

    default public CompoundTag writeNode(CompoundTag nbt, int node) {
        BlockPos pos = this.getNodePos(node);
        if (pos == null) {
            return nbt;
        }
        int index = this.getOtherNodeIndex(node);
        WireType type = this.getNodeType(node);
        nbt.m_128405_("x" + node, pos.m_123341_());
        nbt.m_128405_("y" + node, pos.m_123342_());
        nbt.m_128405_("z" + node, pos.m_123343_());
        nbt.m_128405_("node" + node, index);
        nbt.m_128405_("type" + node, type.getIndex());
        return nbt;
    }

    default public void readNode(CompoundTag nbt, int node) {
        if (!IWireNode.hasNode(nbt, node)) {
            return;
        }
        BlockPos pos = new BlockPos(nbt.m_128451_("x" + node), nbt.m_128451_("y" + node), nbt.m_128451_("z" + node));
        WireType type = WireType.fromIndex(nbt.m_128451_("type" + node));
        int index = nbt.m_128451_("node" + node);
        this.setNode(node, index, pos, type);
    }

    public static void clearNode(CompoundTag nbt, int node) {
        nbt.m_128473_("x" + node);
        nbt.m_128473_("y" + node);
        nbt.m_128473_("z" + node);
        nbt.m_128473_("type" + node);
    }

    public void setNode(int var1, int var2, BlockPos var3, WireType var4);

    default public void removeNode(int node) {
        this.setNode(node, -1, null, null);
    }

    public BlockPos getNodePos(int var1);

    public WireType getNodeType(int var1);

    public int getOtherNodeIndex(int var1);

    public void invalidateNodeCache();

    default public boolean hasConnection(int node) {
        return this.getNodePos(node) != null;
    }

    default public boolean hasConnectionTo(BlockPos pos1) {
        if (pos1 == null) {
            return false;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            BlockPos pos2 = this.getNodePos(i);
            if (pos2 == null || !pos1.equals((Object)pos2)) continue;
            return true;
        }
        return false;
    }

    public static int findConnectionTo(IWireNode wn, BlockPos pos) {
        if (pos == null) {
            return -1;
        }
        for (int i = 0; i < wn.getNodeCount(); ++i) {
            BlockPos pos2 = wn.getNodePos(i);
            if (pos2 == null || !pos.equals((Object)pos2)) continue;
            return i;
        }
        return -1;
    }

    public BlockPos getMyPos();

    public IWireNode getNode(int var1);

    public static WireConnectResult connect(Level world, BlockPos pos1, int node1, BlockPos pos2, int node2, WireType type) {
        BlockEntity te1 = world.m_7702_(pos1);
        if (te1 == null) {
            return WireConnectResult.INVALID;
        }
        BlockEntity te2 = world.m_7702_(pos2);
        if (te2 == null) {
            return WireConnectResult.INVALID;
        }
        if (te1 == te2) {
            return WireConnectResult.INVALID;
        }
        if (!(te1 instanceof IWireNode)) {
            return WireConnectResult.INVALID;
        }
        if (!(te2 instanceof IWireNode)) {
            return WireConnectResult.INVALID;
        }
        if (node1 < 0 || node2 < 0) {
            return WireConnectResult.COUNT;
        }
        if (pos1.m_123331_((Vec3i)pos2) > (double)(MAX_LENGTH * MAX_LENGTH)) {
            return WireConnectResult.LONG;
        }
        IWireNode wn1 = (IWireNode)te1;
        IWireNode wn2 = (IWireNode)te2;
        if (wn1.hasConnectionTo(pos2)) {
            return WireConnectResult.EXISTS;
        }
        wn1.setNode(node1, node2, wn2.getMyPos(), type);
        wn2.setNode(node2, node1, wn1.getMyPos(), type);
        return WireConnectResult.getLink(wn2.isNodeInput(node2), wn2.isNodeOutput(node2));
    }

    public static WireType getTypeOfConnection(Level world, BlockPos pos1, BlockPos pos2) {
        BlockEntity te1 = world.m_7702_(pos1);
        if (te1 == null) {
            return null;
        }
        if (!(te1 instanceof IWireNode)) {
            return null;
        }
        IWireNode wn1 = (IWireNode)te1;
        if (!wn1.hasConnectionTo(pos2)) {
            return null;
        }
        int node1 = IWireNode.findConnectionTo(wn1, pos2);
        return wn1.getNodeType(node1);
    }

    public static WireConnectResult disconnect(Level world, BlockPos pos1, BlockPos pos2) {
        BlockEntity te1 = world.m_7702_(pos1);
        if (te1 == null) {
            return WireConnectResult.INVALID;
        }
        BlockEntity te2 = world.m_7702_(pos2);
        if (te2 == null) {
            return WireConnectResult.INVALID;
        }
        if (te1 == te2) {
            return WireConnectResult.INVALID;
        }
        if (!(te1 instanceof IWireNode)) {
            return WireConnectResult.INVALID;
        }
        if (!(te2 instanceof IWireNode)) {
            return WireConnectResult.INVALID;
        }
        IWireNode wn1 = (IWireNode)te1;
        IWireNode wn2 = (IWireNode)te2;
        if (!wn1.hasConnectionTo(pos2)) {
            return WireConnectResult.NO_CONNECTION;
        }
        int node1 = IWireNode.findConnectionTo(wn1, pos2);
        int node2 = IWireNode.findConnectionTo(wn2, pos1);
        if (node1 < 0) {
            return WireConnectResult.NO_CONNECTION;
        }
        if (node2 < 0) {
            return WireConnectResult.NO_CONNECTION;
        }
        wn1.removeNode(node1);
        wn2.removeNode(node2);
        return WireConnectResult.REMOVED;
    }

    public static IWireNode getWireNode(Level world, BlockPos pos) {
        if (pos == null) {
            return null;
        }
        BlockEntity te = world.m_7702_(pos);
        if (te == null) {
            return null;
        }
        if (!(te instanceof IWireNode)) {
            return null;
        }
        return (IWireNode)te;
    }

    default public boolean isNodeInput(int node) {
        return true;
    }

    default public boolean isNodeOutput(int node) {
        return true;
    }

    public static void dropWire(Level world, BlockPos pos, ItemStack stack) {
        Containers.m_19010_((Level)world, (BlockPos)pos, (NonNullList)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{stack}));
    }

    default public void dropWires(Level world) {
        NonNullList stacks = NonNullList.m_122780_((int)WireType.values().length, (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) continue;
            int n = this.getNodeType(i).getIndex();
            if (((ItemStack)stacks.get(n)).m_41619_()) {
                stacks.set(n, (Object)this.getNodeType(i).getDrop());
                continue;
            }
            ((ItemStack)stacks.get(n)).m_41769_(this.getNodeType(i).getDrop().m_41613_());
        }
        for (ItemStack stack : stacks) {
            IWireNode.dropWire(world, this.getMyPos(), stack);
        }
    }

    default public void dropWires(Level world, Player player) {
        NonNullList stacks1 = NonNullList.m_122780_((int)WireType.values().length, (Object)ItemStack.f_41583_);
        NonNullList stacks2 = NonNullList.m_122780_((int)WireType.values().length, (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) continue;
            int n = this.getNodeType(i).getIndex();
            ItemStack spools = Util.findStack(((WireSpool)CAItems.SPOOL.get()).m_5456_(), player.m_150109_());
            if (spools.m_41613_() > 0) {
                if (((ItemStack)stacks1.get(n)).m_41619_()) {
                    stacks1.set(n, (Object)this.getNodeType(i).getSourceDrop());
                } else {
                    ((ItemStack)stacks1.get(n)).m_41769_(this.getNodeType(i).getSourceDrop().m_41613_());
                }
                spools.m_41774_(1);
                continue;
            }
            if (((ItemStack)stacks2.get(n)).m_41619_()) {
                stacks2.set(n, (Object)this.getNodeType(i).getDrop());
                continue;
            }
            ((ItemStack)stacks2.get(n)).m_41769_(this.getNodeType(i).getDrop().m_41613_());
        }
        for (ItemStack stack : stacks1) {
            if (stack.m_41619_()) continue;
            IWireNode.dropWire(world, this.getMyPos(), player.m_150109_().m_36054_(stack) ? ItemStack.f_41583_ : stack);
        }
        for (ItemStack stack : stacks2) {
            if (stack.m_41619_()) continue;
            IWireNode.dropWire(world, this.getMyPos(), player.m_150109_().m_36054_(stack) ? ItemStack.f_41583_ : stack);
        }
    }

    default public boolean isNodeIndeciesConnected(int in, int other) {
        return true;
    }

    default public boolean awakeNetwork(Level world) {
        boolean b = false;
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.isNetworkValid(i)) continue;
            this.setNetwork(i, EnergyNetwork.nextNode(world, new EnergyNetwork(world), new HashMap<String, IWireNode>(), this, i));
            b = true;
        }
        return b;
    }

    public EnergyNetwork getNetwork(int var1);

    public void setNetwork(int var1, EnergyNetwork var2);

    default public boolean isNetworkValid(int node) {
        return this.getNetwork(node) == null ? false : this.getNetwork(node).isValid();
    }
}

