/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.base;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class AbstractBurnerBlockEntity
extends BlockEntity
implements WorldlyContainer {
    public static final int SLOT_FUEL = 0;
    public static final int DATA_LIT_TIME = 0;
    private static final int[] SLOTS = new int[]{0};
    public static final int DATA_LIT_DURATION = 1;
    public static final int NUM_DATA_VALUES = 4;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;
    public NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    public int litTime;
    public int litDuration;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    protected AbstractBurnerBlockEntity(BlockEntityType<?> p_154991_, BlockPos p_154992_, BlockState p_154993_) {
        super(p_154991_, p_154992_, p_154993_);
    }

    public boolean isLit() {
        return this.litTime > 0;
    }

    public void m_142466_(CompoundTag p_155025_) {
        super.m_142466_(p_155025_);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)p_155025_, this.items);
        this.litTime = p_155025_.m_128451_("BurnTime");
        this.litDuration = this.getBurnDuration((ItemStack)this.items.get(0));
    }

    protected void m_183515_(CompoundTag p_187452_) {
        super.m_183515_(p_187452_);
        p_187452_.m_128405_("BurnTime", this.litTime);
        ContainerHelper.m_18973_((CompoundTag)p_187452_, this.items);
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, AbstractBurnerBlockEntity be) {
        boolean flag = be.isLit();
        boolean flag1 = false;
        if (be.isLit()) {
            --be.litTime;
        }
        ItemStack itemstack = (ItemStack)be.items.get(0);
        if (!(!be.isLit() && itemstack.m_41619_() || be.isLit())) {
            be.litDuration = be.litTime = be.getBurnDuration(itemstack);
            if (be.isLit()) {
                flag1 = true;
                if (itemstack.hasContainerItem()) {
                    be.items.set(0, (Object)itemstack.getContainerItem());
                } else if (!itemstack.m_41619_()) {
                    itemstack.m_41774_(1);
                    if (itemstack.m_41619_()) {
                        be.items.set(0, (Object)itemstack.getContainerItem());
                    }
                }
            }
        }
        if (flag != be.isLit()) {
            flag1 = true;
            state = (BlockState)state.m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(be.isLit()));
            world.m_7731_(pos, state, 3);
        }
        if (flag1) {
            AbstractBurnerBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public int getBurnDuration(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)stack, null);
    }

    public static boolean isFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0;
    }

    public int[] m_7071_(Direction dir) {
        return SLOTS;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction dir) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction dir) {
        return true;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int index, int p_58331_) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)p_58331_);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_7013_(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(0);
        return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0 || stack.m_150930_(Items.f_42446_) && !itemstack.m_150930_(Items.f_42446_);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handlers[0].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }

    public boolean m_6542_(Player player) {
        return false;
    }
}

