/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.accumulator;

import com.mrh0.createaddition.blocks.accumulator.AccumulatorBlock;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.BaseElectricTileEntity;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.item.Multimeter;
import com.mrh0.createaddition.network.EnergyNetworkPacket;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.util.IComparatorOverride;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.energy.IEnergyStorage;

public class AccumulatorTileEntity
extends BaseElectricTileEntity
implements IWireNode,
IHaveGoggleInformation,
IComparatorOverride,
IObserveTileEntity {
    private BlockPos[] connectionPos;
    private int[] connectionIndecies;
    private WireType[] connectionTypes;
    public IWireNode[] nodeCache;
    public static Vec3 OFFSET_NORTH = new Vec3(0.0, 0.5625, -0.3125);
    public static Vec3 OFFSET_WEST = new Vec3(-0.3125, 0.5625, 0.0);
    public static Vec3 OFFSET_SOUTH = new Vec3(0.0, 0.5625, 0.3125);
    public static Vec3 OFFSET_EAST = new Vec3(0.3125, 0.5625, 0.0);
    public static final int CAPACITY = (Integer)Config.ACCUMULATOR_CAPACITY.get();
    public static final int MAX_IN = (Integer)Config.ACCUMULATOR_MAX_INPUT.get();
    public static final int MAX_OUT = (Integer)Config.ACCUMULATOR_MAX_OUTPUT.get();
    private int lastComparator = 0;
    int lastEnergy = 0;
    private boolean firstTickState = true;
    private int demandOut = 0;
    private int demandIn = 0;
    private EnergyNetwork networkIn;
    private EnergyNetwork networkOut;

    public AccumulatorTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state, CAPACITY, MAX_IN, MAX_OUT);
        this.setLazyTickRate(20);
        this.connectionPos = new BlockPos[this.getNodeCount()];
        this.connectionIndecies = new int[this.getNodeCount()];
        this.connectionTypes = new WireType[this.getNodeCount()];
        this.nodeCache = new IWireNode[this.getNodeCount()];
    }

    @Override
    public IWireNode getNode(int node) {
        if (this.getNodeType(node) == null) {
            this.nodeCache[node] = null;
            return null;
        }
        if (this.nodeCache[node] == null) {
            this.nodeCache[node] = IWireNode.getWireNode(this.f_58857_, this.getNodePos(node));
        }
        if (this.nodeCache[node] == null) {
            this.setNode(node, -1, null, null);
        }
        return this.nodeCache[node];
    }

    @Override
    public Vec3 getNodeOffset(int node) {
        if (node > 3) {
            switch ((Direction)this.m_58900_().m_61143_((Property)AccumulatorBlock.FACING)) {
                case NORTH: {
                    return OFFSET_NORTH;
                }
                case WEST: {
                    return OFFSET_WEST;
                }
                case SOUTH: {
                    return OFFSET_SOUTH;
                }
                case EAST: {
                    return OFFSET_EAST;
                }
            }
        } else {
            switch ((Direction)this.m_58900_().m_61143_((Property)AccumulatorBlock.FACING)) {
                case NORTH: {
                    return OFFSET_SOUTH;
                }
                case WEST: {
                    return OFFSET_EAST;
                }
                case SOUTH: {
                    return OFFSET_NORTH;
                }
                case EAST: {
                    return OFFSET_WEST;
                }
            }
        }
        return OFFSET_NORTH;
    }

    @Override
    public boolean isEnergyInput(Direction side) {
        return side != Direction.UP;
    }

    @Override
    public boolean isEnergyOutput(Direction side) {
        return false;
    }

    @Override
    public boolean isNodeInput(int node) {
        return node < 4;
    }

    @Override
    public boolean isNodeOutput(int node) {
        return !this.isNodeInput(node);
    }

    @Override
    public int getNodeFromPos(Vec3 vec) {
        Direction dir = (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)AccumulatorBlock.FACING);
        boolean upper = true;
        vec = vec.m_82492_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_());
        switch (dir) {
            case NORTH: {
                upper = vec.m_7094_() < 0.5;
                break;
            }
            case WEST: {
                upper = vec.m_7096_() < 0.5;
                break;
            }
            case SOUTH: {
                upper = vec.m_7094_() > 0.5;
                break;
            }
            case EAST: {
                upper = vec.m_7096_() > 0.5;
                break;
            }
        }
        for (int i = upper ? 4 : 0; i < (upper ? 8 : 4); ++i) {
            if (this.hasConnection(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public BlockPos getNodePos(int node) {
        return this.connectionPos[node];
    }

    @Override
    public WireType getNodeType(int node) {
        return this.connectionTypes[node];
    }

    @Override
    public int getOtherNodeIndex(int node) {
        if (this.connectionPos[node] == null) {
            return -1;
        }
        return this.connectionIndecies[node];
    }

    @Override
    public void setNode(int node, int other, BlockPos pos, WireType type) {
        this.connectionPos[node] = pos;
        this.connectionIndecies[node] = other;
        this.connectionTypes[node] = type;
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (!IWireNode.hasNode(nbt, i)) continue;
            this.readNode(nbt, i);
        }
    }

    @Override
    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) {
                IWireNode.clearNode(nbt, i);
                continue;
            }
            this.writeNode(nbt, i);
        }
    }

    @Override
    public void removeNode(int other) {
        IWireNode.super.removeNode(other);
        this.invalidateNodeCache();
        this.m_6596_();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    @Override
    public int getNodeCount() {
        return 8;
    }

    @Override
    public BlockPos getMyPos() {
        return this.f_58858_;
    }

    @Override
    public void invalidateNodeCache() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.nodeCache[i] = null;
        }
    }

    public void lazyTick() {
        super.lazyTick();
        int comp = this.getComparetorOverride();
        if (comp != this.lastComparator) {
            this.f_58857_.m_46672_(this.f_58858_, (Block)CABlocks.ACCUMULATOR.get());
        }
        this.lastComparator = comp;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.firstTickState) {
            this.firstTick();
        }
        this.firstTickState = false;
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.networkTick();
    }

    private void networkTick() {
        if (this.awakeNetwork(this.f_58857_)) {
            this.causeBlockUpdate();
        }
        if (this.networkOut == null) {
            return;
        }
        this.energy.extractEnergy(this.networkOut.push(this.energy.extractEnergy(this.demandOut, true)), false);
        this.demandOut = this.networkOut.getDemand();
        this.energy.receiveEnergy(this.networkIn.pull(Math.min(this.demandIn, this.energy.receiveEnergy(MAX_IN, true))), false);
        this.demandIn = this.networkIn.demand(this.energy.receiveEnergy(MAX_IN, true));
    }

    @Override
    public void m_7651_() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) continue;
            IWireNode node = this.getNode(i);
            if (node == null) break;
            node.removeNode(this.getOtherNodeIndex(i));
            node.invalidateNodeCache();
        }
        this.invalidateNodeCache();
        this.invalidateCaps();
        super.m_7651_();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
        super.m_7651_();
    }

    @Override
    public EnergyNetwork getNetwork(int node) {
        return this.isNodeInput(node) ? this.networkIn : this.networkOut;
    }

    @Override
    public void setNetwork(int node, EnergyNetwork network) {
        if (this.isNodeInput(node)) {
            this.networkIn = network;
        }
        if (this.isNodeOutput(node)) {
            this.networkOut = network;
        }
    }

    @Override
    public boolean isNodeIndeciesConnected(int in, int other) {
        return this.isNodeInput(in) == this.isNodeInput(other);
    }

    public void setEnergy(int energy) {
        this.energy.setEnergy(energy);
    }

    @Override
    public int getComparetorOverride() {
        return (int)((double)this.energy.getEnergyStored() / (double)this.energy.getMaxEnergyStored() * 15.0);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        HitResult ray = Minecraft.m_91087_().f_91077_;
        if (ray == null) {
            return false;
        }
        int node = this.getNodeFromPos(ray.m_82450_());
        ObservePacket.send(this.f_58858_, node);
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("createaddition.tooltip.accumulator.info").m_130940_(ChatFormatting.WHITE)));
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("createaddition.tooltip.energy.stored").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TextComponent(" ")).m_7220_(Multimeter.getTextComponent((IEnergyStorage)this.energy)));
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("createaddition.tooltip.energy.selected").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TextComponent(" ")).m_7220_((Component)new TranslatableComponent(this.isNodeInput(node) ? "createaddition.tooltip.energy.input" : "createaddition.tooltip.energy.output").m_130940_(ChatFormatting.AQUA)));
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("createaddition.tooltip.energy.usage").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)new TextComponent("    ").m_130946_(" ").m_130946_(Multimeter.format(EnergyNetworkPacket.clientBuff)).m_130946_("fe/t").m_130940_(ChatFormatting.AQUA));
        return true;
    }

    @Override
    public void onObserved(ServerPlayer player, ObservePacket pack) {
        if (this.isNetworkValid(0)) {
            EnergyNetworkPacket.send(this.f_58858_, this.getNetwork(pack.getNode()).getPulled(), this.getNetwork(pack.getNode()).getPushed(), player);
        }
        this.causeBlockUpdate();
    }
}

