/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.mixins;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.map.CustomDataHolder;
import net.mehvahdjukaar.selene.map.CustomDecoration;
import net.mehvahdjukaar.selene.map.CustomDecorationType;
import net.mehvahdjukaar.selene.map.ExpandedMapData;
import net.mehvahdjukaar.selene.map.MapDecorationHandler;
import net.mehvahdjukaar.selene.map.markers.DummyMapWorldMarker;
import net.mehvahdjukaar.selene.map.markers.MapWorldMarker;
import net.mehvahdjukaar.selene.network.ClientBoundSyncCustomMapDecorationPacket;
import net.mehvahdjukaar.selene.network.NetworkHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.maps.MapBanner;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MapItemSavedData.class})
public abstract class MapDataMixin
extends SavedData
implements ExpandedMapData {
    @Final
    @Shadow
    public int f_77885_;
    @Final
    @Shadow
    public int f_77886_;
    @Final
    @Shadow
    public byte f_77890_;
    @Final
    @Shadow
    Map<String, MapDecoration> f_77894_;
    @Final
    @Shadow
    public ResourceKey<Level> f_77887_;
    @Final
    @Shadow
    public boolean f_77892_;
    @Shadow
    @Final
    private Map<String, MapBanner> f_77897_;
    @Shadow
    @Final
    private boolean f_77888_;
    @Shadow
    @Final
    private boolean f_77889_;
    public Map<String, CustomDecoration> customDecorations = Maps.newLinkedHashMap();
    private final Map<String, MapWorldMarker<?>> customMapMarkers = Maps.newHashMap();
    public final Map<String, CustomDataHolder.Instance<?>> customData = new HashMap();

    @Invoker(value="<init>")
    private static MapItemSavedData newMap(int pX, int pZ, byte pScale, boolean pTrackingPosition, boolean pUnlimitedTracking, boolean pLocked, ResourceKey<Level> pDimension) {
        throw new AssertionError();
    }

    @Shadow
    public abstract MapItemSavedData m_164775_();

    @Override
    public Map<String, CustomDataHolder.Instance<?>> getCustomData() {
        return this.customData;
    }

    @Override
    public Map<String, CustomDecoration> getCustomDecorations() {
        return this.customDecorations;
    }

    @Override
    public Map<String, MapWorldMarker<?>> getCustomMarkers() {
        return this.customMapMarkers;
    }

    @Override
    public <D extends CustomDecoration> void addCustomDecoration(MapWorldMarker<D> marker) {
        D decoration = marker.createDecorationFromMarker(this.f_77890_, this.f_77885_, this.f_77886_, this.f_77887_, this.f_77892_);
        if (decoration != null) {
            this.customDecorations.put(marker.getMarkerId(), (CustomDecoration)decoration);
        }
    }

    @Inject(method={"locked"}, at={@At(value="RETURN")}, cancellable=true)
    public void locked(CallbackInfoReturnable<MapItemSavedData> cir) {
        MapItemSavedData data = (MapItemSavedData)cir.getReturnValue();
        if (data instanceof ExpandedMapData) {
            ExpandedMapData expandedMapData = (ExpandedMapData)data;
            expandedMapData.getCustomMarkers().putAll(this.getCustomMarkers());
            expandedMapData.getCustomDecorations().putAll(this.getCustomDecorations());
        }
    }

    @Inject(method={"scaled"}, at={@At(value="RETURN")}, cancellable=true)
    public void scaled(CallbackInfoReturnable<MapItemSavedData> cir) {
        MapItemSavedData data = (MapItemSavedData)cir.getReturnValue();
        if (data instanceof ExpandedMapData) {
            ExpandedMapData expandedMapData = (ExpandedMapData)data;
            expandedMapData.getCustomData().putAll(this.customData);
        }
    }

    public Map<String, MapBanner> getBannerMarkersMap() {
        return this.f_77897_;
    }

    public Map<String, MapDecoration> getDecorationsMap() {
        return this.f_77894_;
    }

    @Override
    public MapItemSavedData copy() {
        MapItemSavedData newData = MapItemSavedData.m_164807_((CompoundTag)this.m_7176_(new CompoundTag()));
        newData.m_77762_();
        return newData;
    }

    @Inject(method={"tickCarriedBy"}, at={@At(value="TAIL")})
    public void tickCarriedBy(Player player, ItemStack stack, CallbackInfo ci) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("CustomDecorations", 9)) {
            ListTag listTag = tag.m_128437_("CustomDecorations", 10);
            for (int j = 0; j < listTag.size(); ++j) {
                CompoundTag com = listTag.m_128728_(j);
                if (this.f_77894_.containsKey(com.m_128461_("id"))) continue;
                String name = com.m_128461_("type");
                CustomDecorationType<? extends CustomDecoration, ?> type = MapDecorationHandler.get(name);
                if (type != null) {
                    DummyMapWorldMarker<? extends CustomDecoration> dummy = new DummyMapWorldMarker<CustomDecoration>(type, com.m_128451_("x"), com.m_128451_("z"));
                    this.addCustomDecoration(dummy);
                    continue;
                }
                Selene.LOGGER.warn("Failed to load map decoration " + name + ". Skipping it");
            }
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")}, cancellable=true)
    private static void load(CompoundTag compound, CallbackInfoReturnable<MapItemSavedData> cir) {
        MapItemSavedData data = (MapItemSavedData)cir.getReturnValue();
        if (compound.m_128441_("customMarkers") && data instanceof ExpandedMapData) {
            ExpandedMapData mapData = (ExpandedMapData)data;
            ListTag listNBT = compound.m_128437_("customMarkers", 10);
            for (int j = 0; j < listNBT.size(); ++j) {
                MapWorldMarker<?> marker = MapDecorationHandler.readWorldMarker(listNBT.m_128728_(j));
                if (marker == null) continue;
                mapData.getCustomMarkers().put(marker.getMarkerId(), marker);
                mapData.addCustomDecoration(marker);
            }
            Map<String, CustomDataHolder.Instance<?>> customData = mapData.getCustomData();
            customData.clear();
            MapDecorationHandler.CUSTOM_MAP_DATA_TYPES.forEach((s, o) -> {
                CustomDataHolder.Instance i = o.create(compound);
                if (i != null) {
                    customData.put((String)s, i);
                }
            });
        }
    }

    @Inject(method={"save"}, at={@At(value="RETURN")}, cancellable=true)
    public void save(CompoundTag tag, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag com = (CompoundTag)cir.getReturnValue();
        ListTag listNBT = new ListTag();
        for (MapWorldMarker<?> marker : this.customMapMarkers.values()) {
            CompoundTag com2 = new CompoundTag();
            com2.m_128365_(marker.getTypeId(), (Tag)marker.saveToNBT(new CompoundTag()));
            listNBT.add((Object)com2);
        }
        com.m_128365_("customMarkers", (Tag)listNBT);
        this.customData.forEach((s, o) -> o.save(tag));
    }

    @Override
    public void resetCustomDecoration() {
        for (String key : this.customMapMarkers.keySet()) {
            this.customDecorations.remove(key);
            this.customMapMarkers.remove(key);
        }
        for (String key : this.f_77897_.keySet()) {
            this.f_77897_.remove(key);
            this.f_77894_.remove(key);
        }
    }

    @Override
    public void toggleCustomDecoration(LevelAccessor world, BlockPos pos) {
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123343_() + 0.5;
        int i = 1 << this.f_77890_;
        double d2 = (d0 - (double)this.f_77885_) / (double)i;
        double d3 = (d1 - (double)this.f_77886_) / (double)i;
        if (d2 >= -63.0 && d3 >= -63.0 && d2 <= 63.0 && d3 <= 63.0) {
            List<MapWorldMarker<?>> markers = MapDecorationHandler.getMarkersFromWorld((BlockGetter)world, pos);
            boolean changed = false;
            for (MapWorldMarker<?> marker : markers) {
                if (marker == null) continue;
                String id = marker.getMarkerId();
                if (this.customMapMarkers.containsKey(id) && this.customMapMarkers.get(id).equals(marker)) {
                    this.customMapMarkers.remove(id);
                    this.customDecorations.remove(id);
                } else {
                    this.customMapMarkers.put(id, marker);
                    this.addCustomDecoration(marker);
                }
                changed = true;
            }
            if (changed) {
                this.m_77762_();
            }
        }
    }

    @Inject(method={"checkBanners"}, at={@At(value="TAIL")})
    public void checkBanners(BlockGetter world, int x, int z, CallbackInfo ci) {
        Iterator<MapWorldMarker<?>> iterator = this.customMapMarkers.values().iterator();
        while (iterator.hasNext()) {
            MapWorldMarker<?> marker = iterator.next();
            if (marker.getPos().m_123341_() != x || marker.getPos().m_123343_() != z) continue;
            Object newMarker = marker.getType().getWorldMarkerFromWorld(world, marker.getPos());
            String id = marker.getMarkerId();
            if (newMarker == null) {
                iterator.remove();
                this.customDecorations.remove(id);
                continue;
            }
            if (!Objects.equals(id, ((MapWorldMarker)newMarker).getMarkerId()) || !marker.shouldUpdate((MapWorldMarker<?>)newMarker)) continue;
            ((MapWorldMarker)newMarker).updateDecoration(this.customDecorations.get(id));
        }
    }

    @Inject(method={"getUpdatePacket"}, at={@At(value="RETURN")}, cancellable=true)
    public void getUpdatePacket(int pMapId, Player pPlayer, CallbackInfoReturnable<Packet<?>> cir) {
        Packet packet = (Packet)cir.getReturnValue();
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            if (packet instanceof ClientboundMapItemDataPacket) {
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ClientBoundSyncCustomMapDecorationPacket(pMapId, this.f_77890_, this.f_77892_, null, this.customDecorations.values().toArray(new CustomDecoration[0]), this.customData.values().toArray(new CustomDataHolder.Instance[0])));
            }
        }
    }

    @Override
    public int getVanillaDecorationSize() {
        return this.f_77894_.size();
    }
}

