/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.map;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.map.CustomDecoration;
import net.mehvahdjukaar.selene.map.markers.MapWorldMarker;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;

public class CustomDecorationType<D extends CustomDecoration, M extends MapWorldMarker<D>> {
    private final ResourceLocation id;
    private final Supplier<M> markerFactory;
    private final BiFunction<BlockGetter, BlockPos, M> markerFromWorldFactory;
    private final BiFunction<CustomDecorationType<?, ?>, FriendlyByteBuf, D> decorationFactory;
    private final boolean hasMarker;

    public CustomDecorationType(ResourceLocation id, Supplier<M> markerFactory, BiFunction<BlockGetter, BlockPos, M> markerFromWorldFactory, BiFunction<CustomDecorationType<?, ?>, FriendlyByteBuf, D> decorationFactory) {
        this.id = id;
        this.markerFactory = markerFactory;
        this.markerFromWorldFactory = markerFromWorldFactory;
        this.decorationFactory = decorationFactory;
        this.hasMarker = true;
    }

    public CustomDecorationType(ResourceLocation id, BiFunction<CustomDecorationType<?, ?>, FriendlyByteBuf, D> decoFromBuffer) {
        this.id = id;
        this.markerFactory = () -> null;
        this.markerFromWorldFactory = (s, d) -> null;
        this.decorationFactory = decoFromBuffer;
        this.hasMarker = false;
    }

    public boolean hasMarker() {
        return this.hasMarker;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getRegistryId() {
        return this.id.toString();
    }

    @Nullable
    public D loadDecorationFromBuffer(FriendlyByteBuf buffer) {
        try {
            return (D)((CustomDecoration)this.decorationFactory.apply(this, buffer));
        }
        catch (Exception e) {
            Selene.LOGGER.warn("Failed to load custom map decoration for decoration type" + this.getRegistryId() + ": " + e);
            return null;
        }
    }

    @Nullable
    public M loadMarkerFromNBT(CompoundTag compound) {
        if (this.hasMarker) {
            MapWorldMarker marker = (MapWorldMarker)this.markerFactory.get();
            try {
                marker.loadFromNBT(compound);
                return (M)marker;
            }
            catch (Exception e) {
                Selene.LOGGER.warn("Failed to load world map marker for decoration type" + this.getRegistryId() + ": " + e);
            }
        }
        return null;
    }

    @Nullable
    public M getWorldMarkerFromWorld(BlockGetter reader, BlockPos pos) {
        return (M)(this.hasMarker ? (MapWorldMarker)this.markerFromWorldFactory.apply(reader, pos) : null);
    }
}

