/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.fluids.client;

import java.util.HashMap;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidParticleColors {
    public static HashMap<String, Integer> particleColor = new HashMap();

    public static void refresh() {
        particleColor = new HashMap();
        for (Fluid f : ForgeRegistries.FLUIDS) {
            ResourceLocation location;
            String key = f.getRegistryName().toString();
            if (particleColor.containsKey(key) || (location = f.getAttributes().getStillTexture()) == null) continue;
            TextureAtlas textureMap = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_);
            TextureAtlasSprite sprite = textureMap.m_118316_(location);
            int averageColor = -1;
            try {
                averageColor = FluidParticleColors.getColorFrom(sprite, f.getAttributes().getColor());
            }
            catch (Exception e) {
                Selene.LOGGER.warn("failed to load particle color for " + sprite.toString() + " using current resource pack. might be a broken png.mcmeta");
            }
            particleColor.put(key, averageColor);
        }
        for (SoftFluid s : SoftFluidRegistry.getFluids()) {
            ResourceLocation location;
            if (particleColor.containsKey(s.getID()) || s.isColored() || (location = s.getStillTexture()) == null) continue;
            TextureAtlas textureMap = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_);
            TextureAtlasSprite sprite = textureMap.m_118316_(location);
            int averageColor = -1;
            try {
                averageColor = FluidParticleColors.getColorFrom(sprite, s.getTintColor());
            }
            catch (Exception e) {
                Selene.LOGGER.warn("failed to load particle color for " + sprite.toString() + " using current resource pack. might be a broken png.mcmeta");
            }
            particleColor.put(s.getID(), averageColor);
        }
    }

    public static int get(Fluid f) {
        return particleColor.getOrDefault(f.getRegistryName().toString(), -1);
    }

    public static int get(String s) {
        return particleColor.getOrDefault(s, -1);
    }

    private static int getColorFrom(TextureAtlasSprite sprite, int tint) {
        if (sprite == null || sprite.m_118415_() == 0) {
            return -1;
        }
        int tintR = tint >> 16 & 0xFF;
        int tintG = tint >> 8 & 0xFF;
        int tintB = tint & 0xFF;
        int total = 0;
        int totalR = 0;
        int totalB = 0;
        int totalG = 0;
        for (int tryFrame = 0; tryFrame < sprite.m_118415_(); ++tryFrame) {
            try {
                for (int x = 0; x < sprite.m_118405_(); ++x) {
                    for (int y = 0; y < sprite.m_118408_(); ++y) {
                        int pixel = sprite.getPixelRGBA(tryFrame, x, y);
                        int pixelB = pixel >> 16 & 0xFF;
                        int pixelG = pixel >> 8 & 0xFF;
                        int pixelR = pixel & 0xFF;
                        ++total;
                        totalR += pixelR;
                        totalG += pixelG;
                        totalB += pixelB;
                    }
                }
                break;
            }
            catch (Exception e) {
                total = 0;
                totalR = 0;
                totalB = 0;
                totalG = 0;
                continue;
            }
        }
        if (total <= 0) {
            return -1;
        }
        return FastColor.ARGB32.m_13660_((int)255, (int)(totalR / total * tintR / 255), (int)(totalG / total * tintG / 255), (int)(totalB / total * tintB / 255));
    }
}

