/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.blocks;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public interface IOwnerProtected {
    @Nullable
    public UUID getOwner();

    public void setOwner(@Nullable UUID var1);

    default public void saveOwner(CompoundTag tag) {
        UUID owner = this.getOwner();
        if (owner != null) {
            tag.m_128362_("Owner", owner);
        }
    }

    default public void loadOwner(CompoundTag tag) {
        if (tag.m_128441_("Owner")) {
            this.setOwner(tag.m_128342_("Owner"));
        }
    }

    default public boolean isOwnedBy(Player player) {
        UUID id = this.getOwner();
        return id != null && id.equals(player.m_142081_());
    }

    default public boolean isPublic() {
        return this.getOwner() == null;
    }

    default public boolean isAccessibleBy(Player player) {
        return this.isPublic() || this.isOwnedBy(player);
    }

    default public boolean isNotOwnedBy(Player player) {
        UUID id = this.getOwner();
        return id != null && !id.equals(player.m_142081_());
    }
}

