/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.object;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import slimeknights.mantle.registration.object.ItemObject;

public class MetalItemObject
extends ItemObject<Block> {
    private final Supplier<? extends Item> ingot;
    private final Supplier<? extends Item> nugget;
    private final Tags.IOptionalNamedTag<Block> blockTag;
    private final Tags.IOptionalNamedTag<Item> blockItemTag;
    private final Tags.IOptionalNamedTag<Item> ingotTag;
    private final Tags.IOptionalNamedTag<Item> nuggetTag;

    public MetalItemObject(String tagName, ItemObject<? extends Block> block, Supplier<? extends Item> ingot, Supplier<? extends Item> nugget) {
        super(block);
        this.ingot = ingot;
        this.nugget = nugget;
        this.blockTag = BlockTags.createOptional((ResourceLocation)new ResourceLocation("forge", "storage_blocks/" + tagName));
        this.blockItemTag = MetalItemObject.getTag("storage_blocks/" + tagName);
        this.ingotTag = MetalItemObject.getTag("ingots/" + tagName);
        this.nuggetTag = MetalItemObject.getTag("nuggets/" + tagName);
    }

    public Item getIngot() {
        return this.ingot.get();
    }

    public Item getNugget() {
        return this.nugget.get();
    }

    private static Tags.IOptionalNamedTag<Item> getTag(String name) {
        return ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", name));
    }

    public Tags.IOptionalNamedTag<Block> getBlockTag() {
        return this.blockTag;
    }

    public Tags.IOptionalNamedTag<Item> getBlockItemTag() {
        return this.blockItemTag;
    }

    public Tags.IOptionalNamedTag<Item> getIngotTag() {
        return this.ingotTag;
    }

    public Tags.IOptionalNamedTag<Item> getNuggetTag() {
        return this.nuggetTag;
    }
}

