/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.deferred;

import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.registration.ItemProperties;
import slimeknights.mantle.registration.deferred.DeferredRegisterWrapper;

public class EntityTypeDeferredRegister
extends DeferredRegisterWrapper<EntityType<?>> {
    private final DeferredRegister<Item> itemRegistry;

    public EntityTypeDeferredRegister(String modID) {
        super(ForgeRegistries.ENTITIES, modID);
        this.itemRegistry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modID);
    }

    @Override
    public void register(IEventBus bus) {
        super.register(bus);
        this.itemRegistry.register(bus);
    }

    public <T extends Entity> RegistryObject<EntityType<T>> register(String name, Supplier<EntityType.Builder<T>> sup) {
        return this.register.register(name, () -> ((EntityType.Builder)sup.get()).m_20712_(this.resourceName(name)));
    }

    public <T extends Mob> RegistryObject<EntityType<T>> registerWithEgg(String name, Supplier<EntityType.Builder<T>> sup, int primary, int secondary) {
        RegistryObject object = this.register(name, sup);
        this.itemRegistry.register(name + "_spawn_egg", () -> new ForgeSpawnEggItem((Supplier)object, primary, secondary, ItemProperties.EGG_PROPS));
        return object;
    }
}

