/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.util.JsonHelper;

public class FluidContainerIngredient
extends Ingredient {
    public static final ResourceLocation ID = Mantle.getResource("fluid_container");
    public static final Serializer SERIALIZER = new Serializer();
    private final FluidIngredient fluidIngredient;
    @Nullable
    private final Ingredient display;
    private ItemStack[] displayStacks;

    protected FluidContainerIngredient(FluidIngredient fluidIngredient, @Nullable Ingredient display) {
        super(Stream.of(new Ingredient.Value[0]));
        this.fluidIngredient = fluidIngredient;
        this.display = display;
    }

    public static FluidContainerIngredient fromIngredient(FluidIngredient ingredient, Ingredient display) {
        return new FluidContainerIngredient(ingredient, display);
    }

    public static FluidContainerIngredient fromIngredient(FluidIngredient ingredient) {
        return new FluidContainerIngredient(ingredient, null);
    }

    public static FluidContainerIngredient fromFluid(FluidObject<?> fluid, boolean forgeTag) {
        return FluidContainerIngredient.fromIngredient(FluidIngredient.of(forgeTag ? fluid.getForgeTag() : fluid.getLocalTag(), 1000), Ingredient.m_43929_((ItemLike[])new ItemLike[]{fluid}));
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && !stack.m_41619_() && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).resolve().flatMap(cap -> {
            FluidStack contained;
            if (cap.getTanks() == 1 && !(contained = cap.getFluidInTank(0)).isEmpty() && this.fluidIngredient.getAmount(contained.getFluid()) == contained.getAmount() && this.fluidIngredient.test(contained.getFluid())) {
                ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
                return copy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).resolve();
            }
            return Optional.empty();
        }).filter(cap -> {
            Fluid fluid = cap.getFluidInTank(0).getFluid();
            int amount = this.fluidIngredient.getAmount(fluid);
            FluidStack drained = cap.drain(amount, IFluidHandler.FluidAction.EXECUTE);
            return drained.getFluid() == fluid && drained.getAmount() == amount && ItemStack.m_41728_((ItemStack)stack.getContainerItem(), (ItemStack)cap.getContainer());
        }).isPresent();
    }

    public ItemStack[] m_43908_() {
        if (this.displayStacks == null) {
            this.displayStacks = this.display == null ? new ItemStack[0] : this.display.m_43908_();
        }
        return this.displayStacks;
    }

    public JsonElement m_43942_() {
        JsonObject json;
        JsonElement element = this.fluidIngredient.serialize();
        if (element.isJsonObject()) {
            json = element.getAsJsonObject();
        } else {
            json = new JsonObject();
            json.add("fluid", element);
        }
        json.addProperty("type", ID.toString());
        if (this.display != null) {
            json.add("display", this.display.m_43942_());
        }
        return json;
    }

    protected void invalidate() {
        super.invalidate();
        this.displayStacks = null;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements IIngredientSerializer<FluidContainerIngredient> {
        private Serializer() {
        }

        public FluidContainerIngredient parse(JsonObject json) {
            FluidIngredient fluidIngredient = json.has("fluid") ? FluidIngredient.deserialize(json, "fluid") : FluidIngredient.deserialize((JsonElement)json, "fluid");
            Ingredient display = null;
            if (json.has("display")) {
                display = Ingredient.m_43917_((JsonElement)JsonHelper.getElement(json, "display"));
            }
            return new FluidContainerIngredient(fluidIngredient, display);
        }

        public FluidContainerIngredient parse(FriendlyByteBuf buffer) {
            FluidIngredient fluidIngredient = FluidIngredient.read(buffer);
            Ingredient display = null;
            if (buffer.readBoolean()) {
                display = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            }
            return new FluidContainerIngredient(fluidIngredient, display);
        }

        public void write(FriendlyByteBuf buffer, FluidContainerIngredient ingredient) {
            ingredient.fluidIngredient.write(buffer);
            if (ingredient.display != null) {
                buffer.writeBoolean(true);
                ingredient.display.m_43923_(buffer);
            } else {
                buffer.writeBoolean(false);
            }
        }
    }
}

