/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot.condition;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import java.util.Set;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import slimeknights.mantle.loot.MantleLoot;
import slimeknights.mantle.util.JsonHelper;

public class BlockTagLootCondition
implements LootItemCondition {
    public static final SerializerImpl SERIALIZER = new SerializerImpl();
    private final Tag<Block> tag;
    private final StatePropertiesPredicate properties;

    public BlockTagLootCondition(Tag<Block> tag) {
        this(tag, StatePropertiesPredicate.f_67658_);
    }

    public BlockTagLootCondition(Tag<Block> tag, StatePropertiesPredicate.Builder builder) {
        this(tag, builder.m_67706_());
    }

    public boolean test(LootContext context) {
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        return state != null && state.m_60620_(this.tag) && this.properties.m_67667_(state);
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81461_);
    }

    public LootItemConditionType m_7940_() {
        return MantleLoot.BLOCK_TAG_CONDITION;
    }

    public BlockTagLootCondition(Tag<Block> tag, StatePropertiesPredicate properties) {
        this.tag = tag;
        this.properties = properties;
    }

    private static class SerializerImpl
    implements Serializer<BlockTagLootCondition> {
        private SerializerImpl() {
        }

        public void serialize(JsonObject json, BlockTagLootCondition loot, JsonSerializationContext context) {
            json.addProperty("tag", Objects.requireNonNull(SerializationTags.m_13199_().m_144452_(Registry.f_122901_).m_7473_(loot.tag)).toString());
            if (loot.properties != StatePropertiesPredicate.f_67658_) {
                json.add("properties", loot.properties.m_67666_());
            }
        }

        public BlockTagLootCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            ResourceLocation id = JsonHelper.getResourceLocation(json, "tag");
            Tag tag = SerializationTags.m_13199_().m_144452_(Registry.f_122901_).m_13404_(id);
            if (tag == null) {
                throw new JsonSyntaxException("Unknown block tag '" + id + "'");
            }
            StatePropertiesPredicate predicate = StatePropertiesPredicate.f_67658_;
            if (json.has("properties")) {
                predicate = StatePropertiesPredicate.m_67679_((JsonElement)json.get("properties"));
            }
            return new BlockTagLootCondition((Tag<Block>)tag, predicate);
        }
    }
}

