/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.NamedComponentRegistry;

public class GenericLoaderRegistry<T extends IHaveLoader>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    private final NamedComponentRegistry<IGenericLoader<? extends T>> loaders = new NamedComponentRegistry("Unknown loader");
    @Nullable
    private final T defaultInstance;

    public GenericLoaderRegistry() {
        this(null);
    }

    public void register(ResourceLocation name, IGenericLoader<? extends T> loader) {
        this.loaders.register(name, loader);
    }

    public T deserialize(JsonObject object) {
        return this.loaders.deserialize(object, "type").deserialize(object);
    }

    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (this.defaultInstance != null && json.isJsonNull()) {
            return this.defaultInstance;
        }
        return this.deserialize(GsonHelper.m_13918_((JsonElement)json, (String)"object"));
    }

    private <L extends IHaveLoader> JsonObject serialize(IGenericLoader<L> loader, T src) {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.loaders.getKey(loader).toString());
        loader.serialize(src, json);
        return json;
    }

    public JsonObject serialize(T src) {
        return this.serialize(src.getLoader(), src);
    }

    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == this.defaultInstance) {
            return JsonNull.INSTANCE;
        }
        return this.serialize(src);
    }

    private <L extends IHaveLoader> void toNetwork(IGenericLoader<L> loader, T src, FriendlyByteBuf buffer) {
        buffer.m_130085_(this.loaders.getKey(loader));
        loader.toNetwork(src, buffer);
    }

    public void toNetwork(T src, FriendlyByteBuf buffer) {
        if (this.defaultInstance != null) {
            if (src == this.defaultInstance) {
                buffer.writeBoolean(false);
                return;
            }
            buffer.writeBoolean(true);
        }
        this.toNetwork(src.getLoader(), src, buffer);
    }

    public T fromNetwork(FriendlyByteBuf buffer) {
        if (this.defaultInstance != null && !buffer.readBoolean()) {
            return this.defaultInstance;
        }
        return this.loaders.fromNetwork(buffer).fromNetwork(buffer);
    }

    public GenericLoaderRegistry(@Nullable T defaultInstance) {
        this.defaultInstance = defaultInstance;
    }

    public static interface IHaveLoader {
        public IGenericLoader<?> getLoader();
    }

    public static interface IGenericLoader<T extends IHaveLoader> {
        public T deserialize(JsonObject var1);

        public T fromNetwork(FriendlyByteBuf var1);

        public void serialize(T var1, JsonObject var2);

        public void toNetwork(T var1, FriendlyByteBuf var2);
    }

    public static class SingletonLoader<T extends IHaveLoader>
    implements IGenericLoader<T> {
        private final T instance;

        @Override
        public T deserialize(JsonObject json) {
            return this.instance;
        }

        @Override
        public T fromNetwork(FriendlyByteBuf buffer) {
            return this.instance;
        }

        @Override
        public void serialize(T object, JsonObject json) {
        }

        @Override
        public void toNetwork(T object, FriendlyByteBuf buffer) {
        }

        public SingletonLoader(T instance) {
            this.instance = instance;
        }
    }
}

