/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GenericDataProvider
implements DataProvider {
    private static final Logger log = LogManager.getLogger(GenericDataProvider.class);
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().disableHtmlEscaping().create();
    protected final DataGenerator generator;
    private final PackType type;
    private final String folder;
    private final Gson gson;

    public GenericDataProvider(DataGenerator generator, PackType type, String folder) {
        this(generator, type, folder, GSON);
    }

    public GenericDataProvider(DataGenerator generator, String folder, Gson gson) {
        this(generator, PackType.SERVER_DATA, folder, gson);
    }

    public GenericDataProvider(DataGenerator generator, String folder) {
        this(generator, folder, GSON);
    }

    protected void saveThing(HashCache cache, ResourceLocation location, Object materialJson) {
        try {
            String json = this.gson.toJson(materialJson);
            Path path = this.generator.m_123916_().resolve(Paths.get(this.type.m_10305_(), location.m_135827_(), this.folder, location.m_135815_() + ".json"));
            String hash = f_123918_.hashUnencodedChars((CharSequence)json).toString();
            if (!Objects.equals(cache.m_123938_(path), hash) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                    bufferedwriter.write(json);
                }
            }
            cache.m_123940_(path, hash);
        }
        catch (IOException e) {
            log.error("Couldn't create data for {}", (Object)location, (Object)e);
        }
    }

    public GenericDataProvider(DataGenerator generator, PackType type, String folder, Gson gson) {
        this.generator = generator;
        this.type = type;
        this.folder = folder;
        this.gson = gson;
    }
}

