/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.TagCollection;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class TagCollectionArgument
implements ArgumentType<Result<?>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("minecraft:blocks", "minecraft:enchantments");
    private static final DynamicCommandExceptionType TAG_COLLECTION_NOT_FOUND = new DynamicCommandExceptionType(name -> new TranslatableComponent("command.mantle.tag_collection.not_found", new Object[]{name}));

    public static Result<?> getResult(CommandContext<CommandSourceStack> pContext, String pName) {
        return (Result)pContext.getArgument(pName, Result.class);
    }

    public static String getTagFolder(ResourceLocation name) {
        return TagCollectionArgument.getTagFolder(RegistryManager.ACTIVE.getRegistry(name), name);
    }

    public static String getTagFolder(@Nullable ForgeRegistry<?> registry, ResourceLocation name) {
        String tagFolder;
        if (registry != null && (tagFolder = registry.getTagFolder()) != null) {
            return tagFolder;
        }
        return name.m_135815_() + "s";
    }

    public Result<?> parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation name = ResourceLocation.m_135818_((StringReader)reader);
        TagCollection collection = SerializationTags.m_13199_().m_144471_(ResourceKey.m_135788_((ResourceLocation)name));
        if (collection != null) {
            ForgeRegistry forgeRegistry = RegistryManager.ACTIVE.getRegistry(name);
            String tagFolder = TagCollectionArgument.getTagFolder(forgeRegistry, name);
            if (forgeRegistry != null) {
                return new ForgeResult(name, tagFolder, collection, forgeRegistry);
            }
            Registry registry = (Registry)Registry.f_122897_.m_7745_(name);
            if (registry != null) {
                return new VanillaResult(name, tagFolder, collection, registry);
            }
        }
        throw TAG_COLLECTION_NOT_FOUND.create((Object)name);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82957_(SerializationTags.m_13199_().f_144433_.keySet().stream().map(ResourceKey::m_135782_), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private TagCollectionArgument() {
    }

    public static TagCollectionArgument collection() {
        return new TagCollectionArgument();
    }

    public static abstract class Result<T> {
        private final ResourceLocation name;
        private final String tagFolder;
        private final TagCollection<T> collection;

        public abstract Collection<ResourceLocation> getKeys();

        @Nullable
        public abstract ResourceLocation getKey(T var1);

        @Nullable
        public abstract T getValue(ResourceLocation var1);

        public Result(ResourceLocation name, String tagFolder, TagCollection<T> collection) {
            this.name = name;
            this.tagFolder = tagFolder;
            this.collection = collection;
        }

        public ResourceLocation getName() {
            return this.name;
        }

        public String getTagFolder() {
            return this.tagFolder;
        }

        public TagCollection<T> getCollection() {
            return this.collection;
        }
    }

    private static class ForgeResult<T extends IForgeRegistryEntry<T>>
    extends Result<T> {
        private final ForgeRegistry<T> registry;

        public ForgeResult(ResourceLocation name, String tagFolder, TagCollection<T> collection, ForgeRegistry<T> registry) {
            super(name, tagFolder, collection);
            this.registry = registry;
        }

        @Override
        public Collection<ResourceLocation> getKeys() {
            return this.registry.getKeys();
        }

        @Override
        public ResourceLocation getKey(T object) {
            return object.getRegistryName();
        }

        @Override
        @Nullable
        public T getValue(ResourceLocation key) {
            if (this.registry.containsKey(key)) {
                return (T)this.registry.getValue(key);
            }
            return null;
        }
    }

    private static class VanillaResult<T>
    extends Result<T> {
        private final Registry<T> registry;

        public VanillaResult(ResourceLocation name, String tagFolder, TagCollection<T> collection, Registry<T> registry) {
            super(name, tagFolder, collection);
            this.registry = registry;
        }

        @Override
        public Collection<ResourceLocation> getKeys() {
            return this.registry.m_6566_();
        }

        @Override
        public ResourceLocation getKey(T object) {
            return this.registry.m_7981_(object);
        }

        @Override
        @Nullable
        public T getValue(ResourceLocation key) {
            if (this.registry.m_7804_(key)) {
                return (T)this.registry.m_7745_(key);
            }
            return null;
        }
    }
}

