/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestAssertPosException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.test.TestingUtil;

public class HopperhockTest {
    private static final String TEMPLATE = "botania:block/hopperhock_furnace";
    private static final BlockPos FURNACE_POS = new BlockPos(6, 3, 6);

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testInsertTop(GameTestHelper helper) {
        helper.m_177245_(FURNACE_POS.m_7494_(), ModSubtiles.hopperhockFloating);
        helper.m_177189_(Items.f_42594_, 1.0f, 2.0f, 1.0f);
        helper.m_177361_(() -> {
            HopperhockTest.assertItemInSlot(helper, 0, Items.f_42594_, 1);
            helper.m_177309_(EntityType.f_20461_);
        });
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testInsertSide(GameTestHelper helper) {
        helper.m_177245_(FURNACE_POS.m_142126_(), ModSubtiles.hopperhockFloating);
        helper.m_177189_(Items.f_42414_, 1.0f, 2.0f, 1.0f);
        helper.m_177361_(() -> {
            HopperhockTest.assertItemInSlot(helper, 1, Items.f_42414_, 1);
            helper.m_177309_(EntityType.f_20461_);
        });
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testInsertBottom(GameTestHelper helper) {
        helper.m_177245_(FURNACE_POS.m_7495_(), ModSubtiles.hopperhock);
        helper.m_177189_(Items.f_42414_, 1.0f, 2.0f, 1.0f);
        helper.m_177361_(() -> {
            HopperhockTest.assertItemInSlot(helper, 1, Items.f_42414_, 1);
            helper.m_177309_(EntityType.f_20461_);
        });
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testInventoryFull(GameTestHelper helper) {
        helper.m_177245_(FURNACE_POS.m_7494_(), ModSubtiles.hopperhockFloating);
        HopperhockTest.getFurnaceBlockEntity(helper).m_6836_(0, new ItemStack((ItemLike)Items.f_41837_, 64));
        helper.m_177189_(Items.f_41837_, 1.0f, 2.0f, 1.0f);
        helper.m_177425_().m_177546_(61, () -> {
            HopperhockTest.assertItemInSlot(helper, 0, Items.f_41837_, 64);
            helper.m_177194_(Items.f_41837_, new BlockPos(1, 2, 1), 0.0);
        }).m_177543_();
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testAddToStack(GameTestHelper helper) {
        helper.m_177245_(FURNACE_POS.m_7494_(), ModSubtiles.hopperhockFloating);
        HopperhockTest.getFurnaceBlockEntity(helper).m_6836_(0, new ItemStack((ItemLike)Items.f_41837_, 60));
        ItemEntity itemEntity = helper.m_177189_(Items.f_41837_, 1.0f, 2.0f, 1.0f);
        itemEntity.m_32055_().m_41764_(10);
        helper.m_177361_(() -> {
            HopperhockTest.assertItemInSlot(helper, 0, Items.f_41837_, 64);
            helper.m_177198_(Items.f_41837_, new BlockPos(1, 2, 1), 0.0, 6);
        });
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testWrongItemForSlot(GameTestHelper helper) {
        helper.m_177245_(FURNACE_POS.m_7495_(), ModSubtiles.hopperhock);
        helper.m_177189_(Items.f_41995_, 1.0f, 2.0f, 1.0f);
        helper.m_177425_().m_177546_(61, () -> {
            helper.m_177440_(FURNACE_POS);
            helper.m_177194_(Items.f_41995_, new BlockPos(1, 2, 1), 0.0);
        }).m_177543_();
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testFilterMatch(GameTestHelper helper) {
        helper.m_177245_(FURNACE_POS.m_7494_(), ModSubtiles.hopperhockFloating);
        HopperhockTest.spawnItemFrame(helper, FURNACE_POS.m_142125_(), Direction.WEST, Items.f_42594_);
        helper.m_177189_(Items.f_42594_, 1.0f, 2.0f, 1.0f);
        helper.m_177361_(() -> {
            HopperhockTest.assertItemInSlot(helper, 0, Items.f_42594_, 1);
            helper.m_177309_(EntityType.f_20461_);
        });
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testFilterNoMatch(GameTestHelper helper) {
        helper.m_177245_(FURNACE_POS.m_7494_(), ModSubtiles.hopperhockFloating);
        HopperhockTest.spawnItemFrame(helper, FURNACE_POS.m_142125_(), Direction.WEST, Items.f_41837_);
        helper.m_177189_(Items.f_42594_, 1.0f, 2.0f, 1.0f);
        helper.m_177425_().m_177546_(61, () -> {
            helper.m_177440_(FURNACE_POS);
            helper.m_177194_(Items.f_42594_, new BlockPos(1, 2, 1), 0.0);
        }).m_177543_();
    }

    private static void spawnItemFrame(GameTestHelper helper, BlockPos pos, Direction direction, Item item) {
        ItemFrame itemFrame = new ItemFrame((Level)helper.m_177100_(), helper.m_177449_(pos), direction);
        itemFrame.m_31805_(new ItemStack((ItemLike)item));
        helper.m_177100_().m_7967_((Entity)itemFrame);
    }

    private static void assertItemInSlot(GameTestHelper helper, int slot, Item expectedItem, int expectedCount) {
        ItemStack stack = HopperhockTest.getFurnaceBlockEntity(helper).m_8020_(slot);
        if (stack.m_41720_() != expectedItem) {
            TestingUtil.throwPositionedAssertion(helper, FURNACE_POS, () -> "Expected " + expectedItem + " in slot " + slot + ", but got " + stack.m_41720_());
        } else if (stack.m_41613_() != expectedCount) {
            TestingUtil.throwPositionedAssertion(helper, FURNACE_POS, () -> "Expected " + expectedCount + " items in slot " + slot + ", but got " + stack.m_41613_());
        }
    }

    private static AbstractFurnaceBlockEntity getFurnaceBlockEntity(GameTestHelper helper) {
        BlockEntity blockEntity = helper.m_177347_(FURNACE_POS);
        if (blockEntity instanceof AbstractFurnaceBlockEntity) {
            AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)blockEntity;
            return furnace;
        }
        throw new GameTestAssertPosException("Expected furnace here", helper.m_177449_(FURNACE_POS), FURNACE_POS, helper.m_177436_());
    }
}

