/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge.xplat;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.block.IExoflameHeatable;
import vazkii.botania.api.block.IHornHarvestable;
import vazkii.botania.api.block.IHourglassTrigger;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.corporea.CorporeaIndexRequestEvent;
import vazkii.botania.api.corporea.CorporeaRequestEvent;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.item.ICoordBoundItem;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaDiscountEvent;
import vazkii.botania.api.mana.ManaItemsEvent;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.api.mana.ManaNetworkEvent;
import vazkii.botania.api.mana.ManaProficiencyEvent;
import vazkii.botania.api.recipe.ElvenPortalUpdateEvent;
import vazkii.botania.common.block.tile.string.TileRedStringContainer;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.internal_caps.EthicalComponent;
import vazkii.botania.common.internal_caps.GhostRailComponent;
import vazkii.botania.common.internal_caps.ItemFlagsComponent;
import vazkii.botania.common.internal_caps.KeptItemsComponent;
import vazkii.botania.common.internal_caps.LooniumComponent;
import vazkii.botania.common.internal_caps.NarslimmusComponent;
import vazkii.botania.common.internal_caps.TigerseyeComponent;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.forge.CapabilityUtil;
import vazkii.botania.forge.ForgeBotaniaCreativeTab;
import vazkii.botania.forge.integration.curios.CurioIntegration;
import vazkii.botania.forge.internal_caps.ForgeInternalEntityCapabilities;
import vazkii.botania.forge.mixin.ForgeAccessorAbstractFurnaceBlockEntity;
import vazkii.botania.forge.mixin.ForgeAccessorRecipeProvider;
import vazkii.botania.forge.mixin.ForgeAccessorRegistry;
import vazkii.botania.forge.network.ForgePacketHandler;
import vazkii.botania.network.IPacket;
import vazkii.botania.xplat.IXplatAbstractions;

public class ForgeXplatImpl
implements IXplatAbstractions {
    private static final PacketDistributor<Pair<Level, BlockPos>> TRACKING_CHUNK_AND_NEAR = new PacketDistributor((_d, pairSupplier) -> {
        Pair pair = (Pair)pairSupplier.get();
        Level level = (Level)pair.getFirst();
        BlockPos blockpos = (BlockPos)pair.getSecond();
        ChunkPos chunkpos = new ChunkPos(blockpos);
        return packet -> {
            List players = ((ServerChunkCache)level.m_7726_()).f_8325_.m_183262_(chunkpos, false);
            for (ServerPlayer player : players) {
                if (!(player.m_20275_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_()) < 4096.0)) continue;
                player.f_8906_.m_141995_(packet);
            }
        };
    }, NetworkDirection.PLAY_TO_CLIENT);
    public static final Map<Block, Block> CUSTOM_STRIPPABLES = new HashMap<Block, Block>();

    @Override
    public boolean isForge() {
        return true;
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public boolean isPhysicalClient() {
        return FMLLoader.getDist() == Dist.CLIENT;
    }

    @Override
    public String getBotaniaVersion() {
        return ((ModContainer)ModList.get().getModContainerById("botania").get()).getModInfo().getVersion().toString();
    }

    @Override
    @Nullable
    public IAvatarWieldable findAvatarWieldable(ItemStack stack) {
        return (IAvatarWieldable)stack.getCapability(BotaniaForgeCapabilities.AVATAR_WIELDABLE).orElse(null);
    }

    @Override
    @Nullable
    public IBlockProvider findBlockProvider(ItemStack stack) {
        return (IBlockProvider)stack.getCapability(BotaniaForgeCapabilities.BLOCK_PROVIDER).orElse(null);
    }

    @Override
    @Nullable
    public ICoordBoundItem findCoordBoundItem(ItemStack stack) {
        return (ICoordBoundItem)stack.getCapability(BotaniaForgeCapabilities.COORD_BOUND_ITEM).orElse(null);
    }

    @Override
    @Nullable
    public IExoflameHeatable findExoflameHeatable(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity be) {
        return CapabilityUtil.findCapability(BotaniaForgeCapabilities.EXOFLAME_HEATABLE, level, pos, state, be);
    }

    @Override
    @Nullable
    public IHornHarvestable findHornHarvestable(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity be) {
        return CapabilityUtil.findCapability(BotaniaForgeCapabilities.HORN_HARVEST, level, pos, state, be);
    }

    @Override
    @Nullable
    public IHourglassTrigger findHourglassTrigger(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity be) {
        return CapabilityUtil.findCapability(BotaniaForgeCapabilities.HOURGLASS_TRIGGER, level, pos, state, be);
    }

    @Override
    @Nullable
    public IWandable findWandable(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity be) {
        return CapabilityUtil.findCapability(BotaniaForgeCapabilities.WANDABLE, level, pos, state, be);
    }

    @Override
    public boolean isFluidContainer(ItemEntity item) {
        return item.m_32055_().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
    }

    @Override
    public boolean extractFluidFromItemEntity(ItemEntity item, Fluid fluid) {
        return item.m_32055_().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(h -> {
            boolean success;
            FluidStack extracted = h.drain(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            boolean bl = success = extracted.getFluid() == fluid && extracted.getAmount() == 1000;
            if (success) {
                item.m_32045_(h.getContainer());
            }
            return success;
        }).orElse(false);
    }

    @Override
    public boolean extractFluidFromPlayerItem(Player player, InteractionHand hand, Fluid fluid) {
        ItemStack stack = player.m_21120_(hand);
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(h -> {
            boolean success;
            FluidStack extracted = h.drain(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            boolean bl = success = extracted.getFluid() == fluid && extracted.getAmount() == 1000;
            if (success && !player.m_150110_().f_35937_) {
                player.m_21008_(hand, h.getContainer());
            }
            return success;
        }).orElse(false);
    }

    @Override
    public boolean insertFluidIntoPlayerItem(Player player, InteractionHand hand, Fluid fluid) {
        ItemStack stack = player.m_21120_(hand);
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(h -> {
            boolean success;
            int filled = h.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            boolean bl = success = filled == 1000;
            if (success && !player.m_150110_().f_35937_) {
                player.m_21008_(hand, h.getContainer());
            }
            return success;
        }).orElse(false);
    }

    @Override
    public boolean hasInventory(Level level, BlockPos pos, Direction sideOfPos) {
        BlockEntity be = level.m_7702_(pos);
        return be != null && be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, sideOfPos).isPresent();
    }

    @Override
    public ItemStack insertToInventory(Level level, BlockPos pos, Direction sideOfPos, ItemStack toInsert, boolean simulate) {
        BlockEntity be = level.m_7702_(pos);
        if (be == null) {
            return toInsert;
        }
        LazyOptional cap = be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, sideOfPos);
        return cap.map(handler -> ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)toInsert, (boolean)simulate)).orElse(toInsert);
    }

    @Override
    public EthicalComponent ethicalComponent(PrimedTnt tnt) {
        return (EthicalComponent)tnt.getCapability(ForgeInternalEntityCapabilities.TNT_ETHICAL).orElseThrow(IllegalStateException::new);
    }

    @Override
    public GhostRailComponent ghostRailComponent(AbstractMinecart cart) {
        return (GhostRailComponent)cart.getCapability(ForgeInternalEntityCapabilities.GHOST_RAIL).orElseThrow(IllegalStateException::new);
    }

    @Override
    public ItemFlagsComponent itemFlagsComponent(ItemEntity item) {
        return (ItemFlagsComponent)item.getCapability(ForgeInternalEntityCapabilities.INTERNAL_ITEM).orElseThrow(IllegalStateException::new);
    }

    @Override
    public KeptItemsComponent keptItemsComponent(Player player) {
        if (!player.m_6084_()) {
            player.reviveCaps();
        }
        KeptItemsComponent ret = (KeptItemsComponent)player.getCapability(ForgeInternalEntityCapabilities.KEPT_ITEMS).orElseThrow(IllegalStateException::new);
        if (!player.m_6084_()) {
            player.invalidateCaps();
        }
        return ret;
    }

    @Override
    @Nullable
    public LooniumComponent looniumComponent(LivingEntity entity) {
        return (LooniumComponent)entity.getCapability(ForgeInternalEntityCapabilities.LOONIUM_DROP).orElse(null);
    }

    @Override
    public NarslimmusComponent narslimmusComponent(Slime slime) {
        return (NarslimmusComponent)slime.getCapability(ForgeInternalEntityCapabilities.NARSLIMMUS).orElseThrow(IllegalStateException::new);
    }

    @Override
    public TigerseyeComponent tigersEyeComponent(Creeper creeper) {
        return (TigerseyeComponent)creeper.getCapability(ForgeInternalEntityCapabilities.TIGERSEYE).orElseThrow(IllegalStateException::new);
    }

    @Override
    public boolean fireCorporeaRequestEvent(ICorporeaRequestMatcher matcher, int itemCount, ICorporeaSpark spark, boolean dryRun) {
        return MinecraftForge.EVENT_BUS.post((Event)new CorporeaRequestEvent(matcher, itemCount, spark, dryRun));
    }

    @Override
    public boolean fireCorporeaIndexRequestEvent(ServerPlayer player, ICorporeaRequestMatcher request, int count, ICorporeaSpark spark) {
        return MinecraftForge.EVENT_BUS.post((Event)new CorporeaIndexRequestEvent(player, request, count, spark));
    }

    @Override
    public void fireManaItemEvent(Player player, List<ItemStack> toReturn) {
        MinecraftForge.EVENT_BUS.post((Event)new ManaItemsEvent(player, toReturn));
    }

    @Override
    public float fireManaDiscountEvent(Player player, float discount, ItemStack tool) {
        ManaDiscountEvent evt = new ManaDiscountEvent(player, discount, tool);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.getDiscount();
    }

    @Override
    public boolean fireManaProficiencyEvent(Player player, ItemStack tool, boolean proficient) {
        ManaProficiencyEvent evt = new ManaProficiencyEvent(player, tool, proficient);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.isProficient();
    }

    @Override
    public void fireElvenPortalUpdateEvent(BlockEntity portal, AABB bounds, boolean open, List<ItemStack> stacksInside) {
        MinecraftForge.EVENT_BUS.post((Event)new ElvenPortalUpdateEvent(portal, bounds, open, stacksInside));
    }

    @Override
    public void fireManaNetworkEvent(BlockEntity be, ManaBlockType type, ManaNetworkAction action) {
        MinecraftForge.EVENT_BUS.post((Event)new ManaNetworkEvent(be, type, action));
    }

    @Override
    public Packet<?> toVanillaClientboundPacket(IPacket packet) {
        return ForgePacketHandler.CHANNEL.toVanillaPacket((Object)packet, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    public void sendToPlayer(Player player, IPacket packet) {
        if (!player.f_19853_.f_46443_) {
            ForgePacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)packet);
        }
    }

    @Override
    public void sendToNear(Level level, BlockPos pos, IPacket packet) {
        if (!level.f_46443_) {
            ForgePacketHandler.CHANNEL.send(TRACKING_CHUNK_AND_NEAR.with(() -> Pair.of((Object)level, (Object)pos)), (Object)packet);
        }
    }

    @Override
    public void sendToTracking(Entity e, IPacket packet) {
        if (!e.f_19853_.f_46443_) {
            ForgePacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> e), (Object)packet);
        }
    }

    @Override
    public <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BiFunction<BlockPos, BlockState, T> func, Block ... blocks) {
        return BlockEntityType.Builder.m_155273_(func::apply, (Block[])blocks).m_58966_(null);
    }

    @Override
    public void registerReloadListener(PackType type, ResourceLocation id, PreparableReloadListener listener) {
        switch (type) {
            case CLIENT_RESOURCES: {
                MinecraftForge.EVENT_BUS.addListener(e -> e.registerReloadListener(listener));
                break;
            }
            case SERVER_DATA: {
                MinecraftForge.EVENT_BUS.addListener(e -> e.addListener(listener));
            }
        }
    }

    @Override
    public Item.Properties defaultItemBuilder() {
        return new Item.Properties().m_41491_((CreativeModeTab)ForgeBotaniaCreativeTab.INSTANCE);
    }

    @Override
    public <T extends AbstractContainerMenu> MenuType<T> createMenuType(TriFunction<Integer, Inventory, FriendlyByteBuf, T> constructor) {
        return IForgeMenuType.create((arg_0, arg_1, arg_2) -> constructor.apply(arg_0, arg_1, arg_2));
    }

    @Override
    public Registry<Brew> createBrewRegistry() {
        return ForgeAccessorRegistry.callRegisterDefaulted(ResourceKey.m_135788_((ResourceLocation)ResourceLocationHelper.prefix("brews")), "botania:fallback", () -> ModBrews.fallbackBrew);
    }

    @Override
    @Nullable
    public EquipmentHandler tryCreateEquipmentHandler() {
        if (IXplatAbstractions.INSTANCE.isModLoaded("curios")) {
            CurioIntegration.init();
            return new CurioIntegration();
        }
        return null;
    }

    @Override
    public void openMenu(ServerPlayer player, MenuProvider menu, Consumer<FriendlyByteBuf> writeInitialData) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)menu, writeInitialData);
    }

    @Override
    public Attribute getReachDistanceAttribute() {
        return (Attribute)ForgeMod.REACH_DISTANCE.get();
    }

    @Override
    public Attribute getStepHeightAttribute() {
        return null;
    }

    @Override
    public Tag.Named<Block> blockTag(ResourceLocation id) {
        return BlockTags.createOptional((ResourceLocation)id);
    }

    @Override
    public Tag.Named<Item> itemTag(ResourceLocation id) {
        return ItemTags.createOptional((ResourceLocation)id);
    }

    @Override
    public Tag.Named<EntityType<?>> entityTag(ResourceLocation id) {
        return EntityTypeTags.createOptional((ResourceLocation)id);
    }

    @Override
    public Tag.Named<Block> getOreTag() {
        return Tags.Blocks.ORES;
    }

    @Override
    public Tag<Block> getGlassTag() {
        return Tags.Blocks.GLASS;
    }

    @Override
    public boolean canFurnaceBurn(AbstractFurnaceBlockEntity furnace, @Nullable Recipe<?> recipe, NonNullList<ItemStack> items, int maxStackSize) {
        return ((ForgeAccessorAbstractFurnaceBlockEntity)furnace).callCanBurn(recipe, items, maxStackSize);
    }

    @Override
    public void saveRecipeAdvancement(DataGenerator generator, HashCache cache, JsonObject json, Path path) {
        ((ForgeAccessorRecipeProvider)new RecipeProvider(generator)).callSaveRecipeAdvancement(cache, json, path);
    }

    @Override
    public Fluid getBucketFluid(BucketItem item) {
        return item.getFluid();
    }

    @Override
    public int getSmeltingBurnTime(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_);
    }

    @Override
    public boolean preventsRemoteMovement(ItemEntity entity) {
        return entity.getPersistentData().m_128471_("PreventRemoteMovement");
    }

    @Override
    public void addAxeStripping(Block input, Block output) {
        CUSTOM_STRIPPABLES.put(input, output);
    }

    @Override
    public int transferEnergyToNeighbors(Level level, BlockPos pos, int energy) {
        for (Direction e : Direction.values()) {
            BlockEntity be;
            BlockPos neighbor = pos.m_142300_(e);
            if (!level.m_46805_(neighbor) || (be = level.m_7702_(neighbor)) == null) continue;
            LazyOptional storage = LazyOptional.empty();
            if (be.getCapability(CapabilityEnergy.ENERGY, e.m_122424_()).isPresent()) {
                storage = be.getCapability(CapabilityEnergy.ENERGY, e.m_122424_());
            } else if (be.getCapability(CapabilityEnergy.ENERGY, null).isPresent()) {
                storage = be.getCapability(CapabilityEnergy.ENERGY, null);
            }
            if (!storage.isPresent() || (energy -= ((IEnergyStorage)storage.orElseThrow(NullPointerException::new)).receiveEnergy(energy, false)) > 0) continue;
            return 0;
        }
        return energy;
    }

    @Override
    public int getEnergyMultiplier() {
        return 10;
    }

    @Override
    public boolean isRedStringContainerTarget(BlockEntity be) {
        for (Direction dir : Direction.values()) {
            if (!be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir).isPresent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public TileRedStringContainer newRedStringContainer(BlockPos pos, BlockState state) {
        return new TileRedStringContainer(pos, state);
    }
}

