/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import vazkii.botania.common.advancements.AlfPortalBreadTrigger;
import vazkii.botania.common.advancements.AlfPortalTrigger;
import vazkii.botania.common.advancements.CorporeaRequestTrigger;
import vazkii.botania.common.advancements.DopplegangerNoArmorTrigger;
import vazkii.botania.common.advancements.LokiPlaceTrigger;
import vazkii.botania.common.advancements.ManaGunTrigger;
import vazkii.botania.common.advancements.RelicBindTrigger;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.AccessorAdvancementProvider;

public class AdvancementProvider
extends net.minecraft.data.advancements.AdvancementProvider {
    public AdvancementProvider(DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    public void m_6865_(HashCache hashCache) {
        ((AccessorAdvancementProvider)((Object)this)).setTabs(this.getAdvancements());
        super.m_6865_(hashCache);
    }

    protected List<Consumer<Consumer<Advancement>>> getAdvancements() {
        return List.of(AdvancementProvider::mainAdvancements, AdvancementProvider::challengeAdvancements);
    }

    private static void mainAdvancements(Consumer<Advancement> consumer) {
        CompoundTag elvenLexiconUnlock = new CompoundTag();
        elvenLexiconUnlock.m_128379_("botania:elven_unlock", true);
        InventoryChangeTrigger.TriggerInstance elvenLexicon = InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{ModItems.lexicon}).m_45075_(elvenLexiconUnlock).m_45077_()});
        Advancement root = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.rootDisplay((ItemLike)ModItems.lexicon, "itemGroup.botania", "botania.desc", ResourceLocationHelper.prefix("textures/block/livingwood_log.png"))).m_138386_("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(ModTags.Items.MYSTICAL_FLOWERS)).m_138389_(consumer, AdvancementProvider.mainId("root"));
        Advancement flowerPickup = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModBlocks.pinkFlower, "flowerPickup", FrameType.TASK)).m_138398_(root).m_138386_("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(ModTags.Items.MYSTICAL_FLOWERS)).m_138389_(consumer, AdvancementProvider.mainId("flower_pickup"));
        Advancement manaPoolPickup = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModBlocks.manaPool, "manaPoolPickup", FrameType.TASK)).m_138398_(flowerPickup).m_138386_("pickup", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModBlocks.manaPool, ModBlocks.creativePool, ModBlocks.dilutedPool, ModBlocks.fabulousPool})).m_138389_(consumer, AdvancementProvider.mainId("mana_pool_pickup"));
        Advancement runePickup = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModBlocks.runeAltar, "runePickup", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("rune", (CriterionTriggerInstance)AdvancementProvider.onPickup(ModTags.Items.RUNES)).m_138389_(consumer, AdvancementProvider.mainId("rune_pickup"));
        Advancement terrasteelPickup = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.terrasteel, "terrasteelPickup", FrameType.TASK)).m_138398_(runePickup).m_138386_("terrasteel", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModItems.terrasteel})).m_138389_(consumer, AdvancementProvider.mainId("terrasteel_pickup"));
        Advancement elfPortalOpen = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModBlocks.alfPortal, "elfPortalOpen", FrameType.TASK)).m_138398_(terrasteelPickup).m_138386_("portal", (CriterionTriggerInstance)new AlfPortalTrigger.Instance(EntityPredicate.Composite.f_36667_, ItemPredicate.f_45028_, LocationPredicate.f_52592_)).m_138389_(consumer, AdvancementProvider.mainId("elf_portal_open"));
        Advancement gaiaGuardianKill = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModBlocks.gaiaHead, "gaiaGuardianKill", FrameType.TASK)).m_138398_(elfPortalOpen).m_138386_("guardian", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(ModEntities.DOPPLEGANGER))).m_138389_(consumer, AdvancementProvider.mainId("gaia_guardian_kill"));
        Advancement enderAirMake = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.enderAirBottle, "enderAirMake", FrameType.TASK)).m_138398_(elfPortalOpen).m_138386_("air", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModItems.enderAirBottle})).m_138389_(consumer, AdvancementProvider.mainId("ender_air_make"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.lexicon, "lexiconUse", FrameType.TASK)).m_138398_(root).m_138386_("use_lexicon", (CriterionTriggerInstance)new UseItemSuccessTrigger.Instance(EntityPredicate.Composite.f_36667_, ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{ModItems.lexicon}).m_45077_(), LocationPredicate.f_52592_)).m_138389_(consumer, AdvancementProvider.mainId("lexicon_use"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.cacophonium, "cacophoniumCraft", FrameType.TASK)).m_138398_(root).m_138386_("cacophonium", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModItems.cacophonium})).m_138389_(consumer, AdvancementProvider.mainId("cacophonium_craft"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModSubtiles.endoflame, "generatingFlower", FrameType.TASK)).m_138398_(flowerPickup).m_138386_("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(ModTags.Items.GENERATING_SPECIAL_FLOWERS)).m_138389_(consumer, AdvancementProvider.mainId("generating_flower"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModBlocks.enchanter, "enchanterMake", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("code_triggered", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138389_(consumer, AdvancementProvider.mainId("enchanter_make"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModSubtiles.bellethorn, "functionalFlower", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(ModTags.Items.FUNCTIONAL_SPECIAL_FLOWERS)).m_138389_(consumer, AdvancementProvider.mainId("functional_flower"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.poolMinecart, "manaCartCraft", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("poolcart", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModItems.poolMinecart})).m_138389_(consumer, AdvancementProvider.mainId("mana_cart_craft"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.manaweaveCloth, "manaweaveArmorCraft", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("head", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModItems.manaweaveHelm, ModItems.manaweaveChest, ModItems.manaweaveLegs, ModItems.manaweaveBoots})).m_138389_(consumer, AdvancementProvider.mainId("manaweave_armor_craft"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.spark, "sparkCraft", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("spark", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModItems.spark})).m_138389_(consumer, AdvancementProvider.mainId("spark_craft"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.manaCookie, "manaCookieEat", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("cookie", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)ModItems.manaCookie)).m_138389_(consumer, AdvancementProvider.mainId("mana_cookie_eat"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.craftingHalo, "craftingHaloCraft", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("pool", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModItems.craftingHalo})).m_138389_(consumer, AdvancementProvider.mainId("crafting_halo_craft"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.manaRing, "baubleWear", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("code_triggered", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138389_(consumer, AdvancementProvider.mainId("bauble_wear"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModBlocks.tinyPotato, "tinyPotatoPet", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("code_triggered", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138389_(consumer, AdvancementProvider.mainId("tiny_potato_pet"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.manaGun, "manaBlasterShoot", FrameType.TASK)).m_138398_(runePickup).m_138386_("shoot", (CriterionTriggerInstance)new ManaGunTrigger.Instance(EntityPredicate.Composite.f_36667_, ItemPredicate.f_45028_, EntityPredicate.f_36550_, null)).m_138389_(consumer, AdvancementProvider.mainId("mana_blaster_shoot"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModSubtiles.pollidisiac, "pollidisiacPickup", FrameType.TASK)).m_138398_(runePickup).m_138386_("pollidisiac", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModSubtiles.pollidisiac})).m_138389_(consumer, AdvancementProvider.mainId("pollidisiac_pickup"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.dirtRod, "dirtRodCraft", FrameType.TASK)).m_138398_(runePickup).m_138386_("dirtrod", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModItems.dirtRod})).m_138389_(consumer, AdvancementProvider.mainId("dirt_rod_craft"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModBlocks.brewery, "brewPickup", FrameType.TASK)).m_138398_(runePickup).m_138386_("pickup", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModItems.brewFlask, ModItems.brewVial})).m_138389_(consumer, AdvancementProvider.mainId("brew_pickup"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.terraSword, "terrasteelWeaponCraft", FrameType.TASK)).m_138398_(terrasteelPickup).m_138386_("terrablade", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModItems.terraSword, ModItems.thornChakram})).m_138389_(consumer, AdvancementProvider.mainId("terrasteel_weapon_craft"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModSubtiles.heiseiDream, "heiseiDreamPickup", FrameType.TASK)).m_138398_(elfPortalOpen).m_138386_("heisei_dream", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModSubtiles.heiseiDream})).m_138389_(consumer, AdvancementProvider.mainId("heisei_dream_pickup"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModSubtiles.kekimurus, "kekimurusPickup", FrameType.TASK)).m_138398_(elfPortalOpen).m_138386_("kekimurus", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModSubtiles.kekimurus})).m_138389_(consumer, AdvancementProvider.mainId("kekimurus_pickup"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModSubtiles.bubbell, "bubbellPickup", FrameType.TASK)).m_138398_(elfPortalOpen).m_138386_("bubbell", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModSubtiles.bubbell})).m_138389_(consumer, AdvancementProvider.mainId("bubbell_pickup"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.spawnerMover, "spawnerMoverUse", FrameType.TASK)).m_138398_(gaiaGuardianKill).m_138386_("use_spawner_mover", (CriterionTriggerInstance)new UseItemSuccessTrigger.Instance(EntityPredicate.Composite.f_36667_, ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{ModItems.spawnerMover}).m_45077_(), LocationPredicate.f_52592_)).m_138389_(consumer, AdvancementProvider.mainId("spawner_mover_use"));
        DisplayInfo tiaraWings = AdvancementProvider.simple((ItemLike)ModItems.flightTiara, "tiaraWings", FrameType.TASK);
        tiaraWings.m_14990_().m_41784_().m_128405_("variant", 1);
        InventoryChangeTrigger.TriggerInstance[] variants = (InventoryChangeTrigger.TriggerInstance[])IntStream.range(1, 9).mapToObj(i -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("variant", i);
            return tag;
        }).map(nbt -> ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{ModItems.flightTiara}).m_45075_(nbt).m_45077_()).map(xva$0 -> InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{xva$0})).toArray(InventoryChangeTrigger.TriggerInstance[]::new);
        Advancement.Builder builder = Advancement.Builder.m_138353_().m_138358_(tiaraWings).m_138398_(gaiaGuardianKill).m_138360_(RequirementsStrategy.f_15979_);
        for (int i2 = 0; i2 < variants.length; ++i2) {
            InventoryChangeTrigger.TriggerInstance variant = variants[i2];
            builder.m_138386_("tiara_" + (i2 + 1), (CriterionTriggerInstance)variant);
        }
        builder.m_138389_(consumer, AdvancementProvider.mainId("tiara_wings"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModSubtiles.dandelifeon, "dandelifeonPickup", FrameType.TASK)).m_138398_(gaiaGuardianKill).m_138386_("dandelifeon", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModSubtiles.dandelifeon})).m_138389_(consumer, AdvancementProvider.mainId("dandelifeon_pickup"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModBlocks.manaBomb, "manaBombIgnite", FrameType.TASK)).m_138398_(gaiaGuardianKill).m_138386_("bomb", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModBlocks.manaBomb})).m_138389_(consumer, AdvancementProvider.mainId("mana_bomb_ignite"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModBlocks.lightRelayDefault, "luminizerRide", FrameType.TASK)).m_138398_(enderAirMake).m_138386_("code_triggered", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138389_(consumer, AdvancementProvider.mainId("luminizer_ride"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModBlocks.corporeaCrystalCube, "corporeaCraft", FrameType.TASK)).m_138398_(enderAirMake).m_138386_("pickup", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModBlocks.corporeaCrystalCube, ModBlocks.corporeaFunnel, ModBlocks.corporeaIndex, ModBlocks.corporeaInterceptor, ModBlocks.corporeaRetainer})).m_138389_(consumer, AdvancementProvider.mainId("corporea_craft"));
        Advancement.Builder.m_138353_().m_138398_(root).m_138386_("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(ModTags.Items.MYSTICAL_FLOWERS)).m_138386_("elven_lexicon", (CriterionTriggerInstance)elvenLexicon).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, AdvancementProvider.mainId("flower_pickup_lexicon"));
        Advancement.Builder.m_138353_().m_138398_(flowerPickup).m_138386_("apothecary", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModBlocks.defaultAltar})).m_138386_("elven_lexicon", (CriterionTriggerInstance)elvenLexicon).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, AdvancementProvider.mainId("apothecary_pickup"));
        Advancement.Builder.m_138353_().m_138398_(flowerPickup).m_138386_("daisy", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModSubtiles.pureDaisy})).m_138386_("elven_lexicon", (CriterionTriggerInstance)elvenLexicon).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, AdvancementProvider.mainId("pure_daisy_pickup"));
        Advancement.Builder.m_138353_().m_138398_(root).m_138386_("pickup", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModBlocks.manaPool, ModBlocks.creativePool, ModBlocks.dilutedPool, ModBlocks.fabulousPool})).m_138386_("elven_lexicon", (CriterionTriggerInstance)elvenLexicon).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, AdvancementProvider.mainId("mana_pool_pickup_lexicon"));
        Advancement.Builder.m_138353_().m_138398_(flowerPickup).m_138386_("altar", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModBlocks.runeAltar})).m_138386_("rune", (CriterionTriggerInstance)AdvancementProvider.onPickup(ModTags.Items.RUNES)).m_138386_("elven_lexicon", (CriterionTriggerInstance)elvenLexicon).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, AdvancementProvider.mainId("runic_altar_pickup"));
        Advancement.Builder.m_138353_().m_138398_(flowerPickup).m_138386_("terrasteel", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModItems.terrasteel})).m_138386_("elven_lexicon", (CriterionTriggerInstance)elvenLexicon).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, AdvancementProvider.mainId("terrasteel_pickup_lexicon"));
        Advancement.Builder.m_138353_().m_138398_(elfPortalOpen).m_138386_("lexicon", (CriterionTriggerInstance)elvenLexicon).m_138389_(consumer, AdvancementProvider.mainId("elf_lexicon_pickup"));
    }

    private static void challengeAdvancements(Consumer<Advancement> consumer) {
        Advancement root = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.rootDisplay((ItemLike)ModItems.dice, "advancement.botania_challenge", "advancement.botania_challenge.desc", ResourceLocationHelper.prefix("textures/block/livingrock_bricks.png"))).m_138386_("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(ModTags.Items.MYSTICAL_FLOWERS)).m_138389_(consumer, AdvancementProvider.challengeId("root"));
        CompoundTag hardmodeNbt = new CompoundTag();
        hardmodeNbt.m_128379_("hardMode", true);
        Advancement hardMode = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.lifeEssence, "gaiaGuardianHardmode", FrameType.CHALLENGE)).m_138398_(root).m_138386_("guardian", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_152108_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_(ModEntities.DOPPLEGANGER).m_36654_(new NbtPredicate(hardmodeNbt)).m_36662_())).m_138389_(consumer, AdvancementProvider.challengeId("gaia_guardian_hardmode"));
        AdvancementProvider.relicBindAdvancement(consumer, hardMode, ModItems.infiniteFruit, "infiniteFruit", "fruit");
        AdvancementProvider.relicBindAdvancement(consumer, hardMode, ModItems.kingKey, "kingKey", "key");
        AdvancementProvider.relicBindAdvancement(consumer, hardMode, ModItems.flugelEye, "flugelEye", "eye");
        AdvancementProvider.relicBindAdvancement(consumer, hardMode, ModItems.thorRing, "thorRing", "ring");
        AdvancementProvider.relicBindAdvancement(consumer, hardMode, ModItems.odinRing, "odinRing", "ring");
        Advancement lokiRing = AdvancementProvider.relicBindAdvancement(consumer, hardMode, ModItems.lokiRing, "lokiRing", "ring");
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.lokiRing, "lokiRingMany", FrameType.CHALLENGE)).m_138398_(lokiRing).m_138386_("place_blocks", (CriterionTriggerInstance)new LokiPlaceTrigger.Instance(EntityPredicate.Composite.f_36667_, EntityPredicate.f_36550_, ItemPredicate.f_45028_, MinMaxBounds.Ints.m_55386_((int)255))).m_138389_(consumer, AdvancementProvider.challengeId("loki_ring_many"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.pinkinator, "pinkinator", FrameType.CHALLENGE)).m_138398_(hardMode).m_138386_("use_pinkinator", (CriterionTriggerInstance)new UseItemSuccessTrigger.Instance(EntityPredicate.Composite.f_36667_, AdvancementProvider.matchItems(new ItemLike[]{ModItems.pinkinator}), LocationPredicate.f_52592_)).m_138389_(consumer, AdvancementProvider.challengeId("pinkinator"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)Blocks.f_50316_, "gaiaGuardianNoArmor", FrameType.CHALLENGE)).m_138398_(root).m_138386_("no_armor", (CriterionTriggerInstance)new DopplegangerNoArmorTrigger.Instance(EntityPredicate.Composite.f_36667_, EntityPredicate.f_36550_, DamageSourcePredicate.f_25420_)).m_138389_(consumer, AdvancementProvider.challengeId("gaia_guardian_no_armor"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.hidden((ItemLike)ModBlocks.motifDaybloom, "old_flower_pickup", FrameType.CHALLENGE)).m_138398_(root).m_138386_("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{ModBlocks.motifDaybloom, ModBlocks.motifNightshade})).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, AdvancementProvider.challengeId("old_flower_pickup"));
        DisplayInfo desuGun = AdvancementProvider.simple((ItemLike)ModItems.manaGun, "desuGun", FrameType.CHALLENGE);
        desuGun.m_14990_().m_41714_((Component)new TextComponent("desu gun"));
        Advancement.Builder.m_138353_().m_138358_(desuGun).m_138398_(root).m_138386_("use_gun", (CriterionTriggerInstance)new ManaGunTrigger.Instance(EntityPredicate.Composite.f_36667_, ItemPredicate.f_45028_, EntityPredicate.f_36550_, true)).m_138389_(consumer, AdvancementProvider.challengeId("desu_gun"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModBlocks.corporeaIndex, "superCorporeaRequest", FrameType.CHALLENGE)).m_138398_(root).m_138386_("over_fifty_thousand", (CriterionTriggerInstance)new CorporeaRequestTrigger.Instance(EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.m_55386_((int)50000), LocationPredicate.f_52592_)).m_138389_(consumer, AdvancementProvider.challengeId("super_corporea_request"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.terraPick, "rankSSPick", FrameType.CHALLENGE)).m_138398_(root).m_138386_("code_triggered", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138389_(consumer, AdvancementProvider.challengeId("rank_ss_pick"));
        CompoundTag level20Shard = new CompoundTag();
        level20Shard.m_128405_("level", 19);
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)ModItems.laputaShard, "l20ShardUse", FrameType.CHALLENGE)).m_138398_(root).m_138386_("use_l20_shard", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{ModItems.laputaShard}).m_45075_(level20Shard).m_45077_()})).m_138389_(consumer, AdvancementProvider.challengeId("l20_shard_use"));
        Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.hidden((ItemLike)Items.f_42406_, "alfPortalBread", FrameType.CHALLENGE)).m_138398_(root).m_138386_("bread", (CriterionTriggerInstance)new AlfPortalBreadTrigger.Instance(EntityPredicate.Composite.f_36667_, LocationPredicate.f_52592_)).m_138389_(consumer, AdvancementProvider.challengeId("alf_portal_bread"));
    }

    private static Advancement relicBindAdvancement(Consumer<Advancement> consumer, Advancement parent, Item relicItem, String titleKey, String criterionName) {
        String id = AdvancementProvider.challengeId(Registry.f_122827_.m_7981_((Object)relicItem).m_135815_());
        return Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)relicItem, titleKey, FrameType.CHALLENGE)).m_138398_(parent).m_138386_(criterionName, (CriterionTriggerInstance)new RelicBindTrigger.Instance(EntityPredicate.Composite.f_36667_, ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{relicItem}).m_45077_())).m_138389_(consumer, id);
    }

    protected static InventoryChangeTrigger.TriggerInstance onPickup(Tag<Item> tag) {
        return InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_45069_(tag).m_45077_()});
    }

    protected static InventoryChangeTrigger.TriggerInstance onPickup(ItemLike ... items) {
        return InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{AdvancementProvider.matchItems(items)});
    }

    protected static ItemPredicate matchItems(ItemLike ... items) {
        return ItemPredicate.Builder.m_45068_().m_151445_(items).m_45077_();
    }

    protected static DisplayInfo simple(ItemLike icon, String name, FrameType frameType) {
        String expandedName = "advancement.botania:" + name;
        return new DisplayInfo(new ItemStack((ItemLike)icon.m_5456_()), (Component)new TranslatableComponent(expandedName), (Component)new TranslatableComponent(expandedName + ".desc"), null, frameType, true, true, false);
    }

    protected static DisplayInfo hidden(ItemLike icon, String name, FrameType frameType) {
        String expandedName = "advancement.botania:" + name;
        return new DisplayInfo(new ItemStack((ItemLike)icon.m_5456_()), (Component)new TranslatableComponent(expandedName), (Component)new TranslatableComponent(expandedName + ".desc"), null, frameType, true, true, true);
    }

    protected static DisplayInfo rootDisplay(ItemLike icon, String titleKey, String descKey, ResourceLocation background) {
        return new DisplayInfo(new ItemStack((ItemLike)icon.m_5456_()), (Component)new TranslatableComponent(titleKey), (Component)new TranslatableComponent(descKey), background, FrameType.TASK, false, false, false);
    }

    private static String mainId(String name) {
        return ResourceLocationHelper.prefix("main/" + name).toString();
    }

    private static String challengeId(String name) {
        return ResourceLocationHelper.prefix("challenge/" + name).toString();
    }

    public String m_6055_() {
        return "Botania Advancements";
    }
}

