/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSampler;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class SkyblockChunkGenerator
extends ChunkGenerator {
    public static final Codec<SkyblockChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryLookupCodec.m_135622_((ResourceKey)Registry.f_194568_).forGetter(gen -> gen.noises), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(gen -> gen.f_62137_), (App)Codec.LONG.fieldOf("seed").stable().forGetter(gen -> gen.seed), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(gen -> gen.settings)).apply((Applicative)instance, instance.stable(SkyblockChunkGenerator::new)));
    private final Registry<NormalNoise.NoiseParameters> noises;
    private final long seed;
    private final Supplier<NoiseGeneratorSettings> settings;
    private final Climate.Sampler sampler;

    public static void init() {
        Registry.m_122965_((Registry)Registry.f_122890_, (ResourceLocation)ResourceLocationHelper.prefix("skyblock"), CODEC);
    }

    public static ChunkGenerator createForWorldType(RegistryAccess registryAccess, long seed) {
        return new SkyblockChunkGenerator((Registry<NormalNoise.NoiseParameters>)registryAccess.m_175515_(Registry.f_194568_), (BiomeSource)MultiNoiseBiomeSource.Preset.f_187087_.m_187099_(registryAccess.m_175515_(Registry.f_122885_)), seed, () -> (NoiseGeneratorSettings)registryAccess.m_175515_(Registry.f_122878_).m_123013_(NoiseGeneratorSettings.f_64432_));
    }

    public SkyblockChunkGenerator(Registry<NormalNoise.NoiseParameters> noises, BiomeSource provider, long seed, Supplier<NoiseGeneratorSettings> settings) {
        super(provider, provider, settings.get().m_64457_(), seed);
        this.noises = noises;
        this.seed = seed;
        this.settings = settings;
        this.sampler = new NoiseSampler(settings.get().m_64481_(), settings.get().m_158568_(), seed, noises, settings.get().m_188893_());
    }

    public static boolean isWorldSkyblock(Level world) {
        return world.m_7726_() instanceof ServerChunkCache && ((ServerChunkCache)world.m_7726_()).m_8481_() instanceof SkyblockChunkGenerator;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public ChunkGenerator m_6819_(long newSeed) {
        return new SkyblockChunkGenerator(this.noises, this.f_62137_.m_7206_(newSeed), newSeed, this.settings);
    }

    public Climate.Sampler m_183403_() {
        return this.sampler;
    }

    public CompletableFuture<ChunkAccess> m_183489_(Executor executor, Blender blender, StructureFeatureManager structureManager, ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public int m_6337_() {
        return this.settings.get().m_64486_();
    }

    public int m_142062_() {
        return this.settings.get().m_64481_().f_158688_();
    }

    public void m_183621_(WorldGenRegion region, StructureFeatureManager structures, ChunkAccess chunk) {
    }

    public void m_6929_(WorldGenRegion worldGenRegion) {
    }

    public int m_6331_() {
        return this.settings.get().m_64481_().f_64508_();
    }

    public void m_183516_(WorldGenRegion worldGenRegion, long seed, BiomeManager biomeManager, StructureFeatureManager structureFeatureManager, ChunkAccess chunkAccess, GenerationStep.Carving carving) {
    }

    public void m_183372_(WorldGenLevel level, ChunkAccess chunk, StructureFeatureManager structureManager) {
    }

    public int m_142647_(int x, int z, Heightmap.Types heightmapType, LevelHeightAccessor levelHeightAccessor) {
        return DimensionType.f_156653_;
    }

    public NoiseColumn m_141914_(int i, int j, LevelHeightAccessor levelHeightAccessor) {
        return new NoiseColumn(levelHeightAccessor.m_141937_(), new BlockState[0]);
    }
}

