/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.block.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileBifrost;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.item.material.ItemSelfReturning;

public class ItemRainbowRod
extends ItemSelfReturning {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatar_rainbow.png");
    private static final int MANA_COST = 750;
    private static final int MANA_COST_AVATAR = 4;
    private static final int TIME = 600;

    public ItemRainbowRod(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_ && ManaItemHandler.instance().requestManaExactForTool(stack, player, 750, false)) {
            BlockState bifrost = ModBlocks.bifrost.m_49966_();
            Vec3 vector = player.m_20154_().m_82541_();
            double x = player.m_20185_();
            double y = player.m_20186_() - 1.0;
            double z = player.m_20189_();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos((int)x, (int)y, (int)z);
            double lastX = 0.0;
            double lastY = -1.0;
            double lastZ = 0.0;
            BlockPos.MutableBlockPos previousPos = new BlockPos.MutableBlockPos();
            boolean placedAny = false;
            boolean prof = ManaItemHandler.instance().hasProficiency(player, stack);
            int maxlen = prof ? 160 : 100;
            int time = prof ? 960 : 600;
            BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos();
            for (int count = 0; count < maxlen; ++count) {
                previousPos.m_122169_(lastX, lastY, lastZ);
                if (!previousPos.equals((Object)pos)) {
                    if (!world.m_46859_((BlockPos)pos) && world.m_8055_((BlockPos)pos) != bifrost && count >= 4 || world.m_151562_(pos.m_123342_())) break;
                    if (ItemRainbowRod.placeBridgeSegment(world, (BlockPos)pos, placePos, time)) {
                        placedAny = true;
                    }
                }
                lastX = x;
                lastY = y;
                lastZ = z;
                pos.m_122169_(x += vector.f_82479_, y += vector.f_82480_, z += vector.f_82481_);
            }
            if (placedAny) {
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.bifrostRod, SoundSource.PLAYERS, 1.0f, 1.0f);
                ManaItemHandler.instance().requestManaExactForTool(stack, player, 750, false);
                player.m_36335_().m_41524_((Item)this, player.m_7500_() ? 10 : 600);
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private static boolean placeBridgeSegment(Level world, BlockPos center, BlockPos.MutableBlockPos placePos, int time) {
        BlockState bifrost = ModBlocks.bifrost.m_49966_();
        boolean placed = false;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                placePos.m_122178_(center.m_123341_() + i, center.m_123342_(), center.m_123343_() + j);
                if (!world.m_46859_((BlockPos)placePos) && world.m_8055_((BlockPos)placePos) != bifrost) continue;
                world.m_7731_((BlockPos)placePos, bifrost, 2);
                TileBifrost tile = (TileBifrost)world.m_7702_((BlockPos)placePos);
                if (tile == null) continue;
                tile.ticks = time;
                placed = true;
            }
        }
        return placed;
    }

    public static class AvatarBehavior
    implements IAvatarWieldable {
        @Override
        public void onAvatarUpdate(IAvatarTile tile) {
            BlockEntity te = tile.tileEntity();
            Level world = te.m_58904_();
            if (world.f_46443_ || tile.getCurrentMana() < 100 || !tile.isEnabled() || world.m_151562_(te.m_58899_().m_123342_() - 1)) {
                return;
            }
            BlockPos tePos = te.m_58899_();
            int w = 1;
            int h = 1;
            int l = 20;
            AABB axis = null;
            switch ((Direction)world.m_8055_(tePos).m_61143_((Property)BlockStateProperties.f_61374_)) {
                case NORTH: {
                    axis = new AABB(tePos.m_142082_(-w, -h, -l), tePos.m_142082_(w + 1, h, 0));
                    break;
                }
                case SOUTH: {
                    axis = new AABB(tePos.m_142082_(-w, -h, 1), tePos.m_142082_(w + 1, h, l + 1));
                    break;
                }
                case WEST: {
                    axis = new AABB(tePos.m_142082_(-l, -h, -w), tePos.m_142082_(0, h, w + 1));
                    break;
                }
                case EAST: {
                    axis = new AABB(tePos.m_142082_(1, -h, -w), tePos.m_142082_(l + 1, h, w + 1));
                    break;
                }
            }
            List players = world.m_45976_(Player.class, axis);
            for (Player p : players) {
                int px = Mth.m_14107_((double)p.m_20185_());
                int py = Mth.m_14107_((double)p.m_20186_()) - 1;
                int pz = Mth.m_14107_((double)p.m_20189_());
                int dist = 5;
                int diff = dist / 2;
                for (int i = 0; i < dist; ++i) {
                    for (int j = 0; j < dist; ++j) {
                        TileBifrost tileBifrost;
                        int ex = px + i - diff;
                        int ez = pz + j - diff;
                        if (!axis.m_82390_(new Vec3((double)ex + 0.5, (double)(py + 1), (double)ez + 0.5))) continue;
                        BlockPos pos = new BlockPos(ex, py, ez);
                        BlockState state = world.m_8055_(pos);
                        if (state.m_60795_()) {
                            if (!world.m_46597_(pos, ModBlocks.bifrost.m_49966_())) continue;
                            tileBifrost = (TileBifrost)world.m_7702_(pos);
                            tileBifrost.ticks = 10;
                            tile.receiveMana(-4);
                            continue;
                        }
                        if (!state.m_60713_(ModBlocks.bifrost)) continue;
                        tileBifrost = (TileBifrost)world.m_7702_(pos);
                        if (tileBifrost.ticks >= 2) continue;
                        tileBifrost.ticks += 10;
                        tile.receiveMana(-4);
                    }
                }
            }
        }

        @Override
        public ResourceLocation getOverlayResource(IAvatarTile tile) {
            return avatarOverlay;
        }
    }
}

