/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.lens.ItemLens;
import vazkii.botania.common.item.lens.Lens;
import vazkii.botania.xplat.BotaniaConfig;

public class LensMine
extends Lens {
    private static final List<List<ItemStack>> HARVEST_TOOLS_BY_LEVEL = List.of(LensMine.stacks(Items.f_42422_, Items.f_42423_, Items.f_42424_, Items.f_42421_), LensMine.stacks(Items.f_42427_, Items.f_42428_, Items.f_42429_, Items.f_42426_), LensMine.stacks(Items.f_42385_, Items.f_42386_, Items.f_42387_, Items.f_42384_), LensMine.stacks(Items.f_42390_, Items.f_42391_, Items.f_42392_, Items.f_42389_), LensMine.stacks(Items.f_42395_, Items.f_42396_, Items.f_42397_, Items.f_42394_));

    @Override
    public boolean collideBurst(IManaBurst burst, HitResult rtr, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        boolean warp;
        ThrowableProjectile entity = burst.entity();
        Level world = entity.f_19853_;
        if (world.f_46443_ || rtr.m_6662_() != HitResult.Type.BLOCK) {
            return false;
        }
        BlockPos collidePos = ((BlockHitResult)rtr).m_82425_();
        BlockState state = world.m_8055_(collidePos);
        ItemStack composite = ((ItemLens)stack.m_41720_()).getCompositeLens(stack);
        boolean bl = warp = !composite.m_41619_() && composite.m_150930_(ModItems.lensWarp);
        if (warp && (state.m_60713_(ModBlocks.pistonRelay) || state.m_60713_(Blocks.f_50039_) || state.m_60713_(Blocks.f_50110_) || state.m_60713_(Blocks.f_50040_))) {
            return false;
        }
        int harvestLevel = BotaniaConfig.common().harvestLevelBore();
        BlockEntity tile = world.m_7702_(collidePos);
        float hardness = state.m_60800_((BlockGetter)world, collidePos);
        int mana = burst.getMana();
        BlockPos source = burst.getBurstSourceBlockPos();
        if (!isManaBlock && LensMine.canHarvest(harvestLevel, state) && hardness != -1.0f && (burst.isFake() || mana >= 24)) {
            if (!burst.hasAlreadyCollidedAt(collidePos) && !burst.isFake()) {
                List items = Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)collidePos, (BlockEntity)tile);
                world.m_7471_(collidePos, false);
                if (BotaniaConfig.common().blockBreakParticles()) {
                    world.m_46796_(2001, collidePos, Block.m_49956_((BlockState)state));
                }
                boolean sourceless = source.equals((Object)IManaBurst.NO_SOURCE);
                boolean doWarp = warp && !sourceless;
                BlockPos dropCoord = doWarp ? source : collidePos;
                for (ItemStack stack_ : items) {
                    Block.m_49840_((Level)world, (BlockPos)dropCoord, (ItemStack)stack_);
                }
                burst.setMana(mana - 24);
            }
            shouldKill = false;
        }
        return shouldKill;
    }

    private static List<ItemStack> stacks(Item ... items) {
        return Stream.of(items).map(ItemStack::new).toList();
    }

    public static boolean canHarvest(int harvestLevel, BlockState state) {
        return !LensMine.getTool(harvestLevel, state).m_41619_();
    }

    public static ItemStack getHarvestToolStack(int harvestLevel, BlockState state) {
        return LensMine.getTool(harvestLevel, state).m_41777_();
    }

    private static ItemStack getTool(int harvestLevel, BlockState state) {
        if (!state.m_60834_()) {
            return HARVEST_TOOLS_BY_LEVEL.get(0).get(0);
        }
        int idx = Math.min(harvestLevel, HARVEST_TOOLS_BY_LEVEL.size() - 1);
        for (ItemStack tool : HARVEST_TOOLS_BY_LEVEL.get(idx)) {
            if (!tool.m_41735_(state)) continue;
            return tool;
        }
        return ItemStack.f_41583_;
    }
}

