/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import vazkii.botania.api.item.ICosmeticAttachable;
import vazkii.botania.api.item.IPhantomInkable;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.xplat.BotaniaConfig;

public abstract class ItemBauble
extends Item
implements ICosmeticAttachable,
IPhantomInkable {
    private static final String TAG_BAUBLE_UUID = "baubleUUID";
    private static final String TAG_COSMETIC_ITEM = "cosmeticItem";
    private static final String TAG_PHANTOM_INK = "phantomInk";

    public ItemBauble(Item.Properties props) {
        super(props);
        EquipmentHandler.instance.onInit(this);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        ItemStack cosmetic = this.getCosmeticItem(stack);
        if (!cosmetic.m_41619_()) {
            tooltip.add((Component)new TranslatableComponent("botaniamisc.hasCosmetic", new Object[]{cosmetic.m_41786_()}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        if (this.hasPhantomInk(stack)) {
            tooltip.add((Component)new TranslatableComponent("botaniamisc.hasPhantomInk").m_130940_(ChatFormatting.AQUA));
        }
    }

    @Override
    public ItemStack getCosmeticItem(ItemStack stack) {
        CompoundTag cmp = ItemNBTHelper.getCompound(stack, TAG_COSMETIC_ITEM, true);
        if (cmp == null) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)cmp);
    }

    @Override
    public void setCosmeticItem(ItemStack stack, ItemStack cosmetic) {
        CompoundTag cmp = new CompoundTag();
        if (!cosmetic.m_41619_()) {
            cmp = cosmetic.m_41739_(cmp);
        }
        ItemNBTHelper.setCompound(stack, TAG_COSMETIC_ITEM, cmp);
    }

    public static UUID getBaubleUUID(ItemStack stack) {
        UUID uuid;
        CompoundTag tag = stack.m_41784_();
        String tagBaubleUuidMostLegacy = "baubleUUIDMost";
        String tagBaubleUuidLeastLegacy = "baubleUUIDLeast";
        if (tag.m_128441_(tagBaubleUuidMostLegacy) && tag.m_128441_(tagBaubleUuidLeastLegacy)) {
            uuid = new UUID(tag.m_128454_(tagBaubleUuidMostLegacy), tag.m_128454_(tagBaubleUuidLeastLegacy));
            tag.m_128362_(TAG_BAUBLE_UUID, uuid);
        }
        if (!tag.m_128403_(TAG_BAUBLE_UUID)) {
            uuid = UUID.randomUUID();
            tag.m_128362_(TAG_BAUBLE_UUID, uuid);
        }
        return tag.m_128342_(TAG_BAUBLE_UUID);
    }

    @Override
    public boolean hasPhantomInk(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_PHANTOM_INK, false);
    }

    @Override
    public void setPhantomInk(ItemStack stack, boolean ink) {
        ItemNBTHelper.setBoolean(stack, TAG_PHANTOM_INK, ink);
    }

    public void onWornTick(ItemStack stack, LivingEntity entity) {
    }

    public void onEquipped(ItemStack stack, LivingEntity entity) {
        if (!entity.f_19853_.f_46443_ && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlayerHelper.grantCriterion(player, ResourceLocationHelper.prefix("main/bauble_wear"), "code_triggered");
        }
    }

    public void onUnequipped(ItemStack stack, LivingEntity entity) {
    }

    public boolean canEquip(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getEquippedAttributeModifiers(ItemStack stack) {
        return HashMultimap.create();
    }

    public boolean hasRender(ItemStack stack, LivingEntity living) {
        return !this.hasPhantomInk(stack) && BotaniaConfig.client().renderAccessories() && !living.m_20145_();
    }
}

