/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.api.item.ICoordBoundItem;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.ItemNBTHelper;

public class ItemManaMirror
extends Item
implements IManaItem {
    private static final String TAG_MANA = "mana";
    private static final String TAG_MANA_BACKLOG = "manaBacklog";
    private static final String TAG_POS = "pos";
    private static final DummyPool fallbackPool = new DummyPool();

    public ItemManaMirror(Item.Properties props) {
        super(props);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * ManaBarTooltip.getFractionForDisplay(this, stack));
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)(ManaBarTooltip.getFractionForDisplay(this, stack) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (world.f_46443_) {
            return;
        }
        IManaPool pool = this.getManaPool(world.m_142572_(), stack);
        if (!(pool instanceof DummyPool)) {
            if (pool == null) {
                this.setMana(stack, 0);
            } else {
                pool.receiveMana(this.getManaBacklog(stack));
                this.setManaBacklog(stack, 0);
                this.setMana(stack, pool.getCurrentMana());
            }
        }
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockEntity tile;
        Level world = ctx.m_43725_();
        Player player = ctx.m_43723_();
        if (player != null && player.m_6144_() && !world.f_46443_ && (tile = world.m_7702_(ctx.m_8083_())) instanceof IManaPool) {
            this.bindPool(ctx.m_43722_(), tile);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.ding, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public int getMana(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA, 0);
    }

    public void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt(stack, TAG_MANA, Math.max(0, mana));
    }

    public int getManaBacklog(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA_BACKLOG, 0);
    }

    public void setManaBacklog(ItemStack stack, int backlog) {
        ItemNBTHelper.setInt(stack, TAG_MANA_BACKLOG, backlog);
    }

    @Override
    public int getMaxMana(ItemStack stack) {
        return 1000000;
    }

    @Override
    public void addMana(ItemStack stack, int mana) {
        this.setMana(stack, this.getMana(stack) + mana);
        this.setManaBacklog(stack, this.getManaBacklog(stack) + mana);
    }

    public void bindPool(ItemStack stack, BlockEntity pool) {
        GlobalPos pos = GlobalPos.m_122643_((ResourceKey)pool.m_58904_().m_46472_(), (BlockPos)pool.m_58899_());
        Tag ser = (Tag)GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)pos).get().orThrow();
        ItemNBTHelper.set(stack, TAG_POS, ser);
    }

    @Nullable
    private static GlobalPos getBoundPos(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(TAG_POS)) {
            return null;
        }
        return GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)ItemNBTHelper.get(stack, TAG_POS)).result().filter(pos -> pos.m_122646_().m_123342_() != Integer.MIN_VALUE).orElse(null);
    }

    @Nullable
    private IManaPool getManaPool(@Nullable MinecraftServer server, ItemStack stack) {
        BlockEntity tile;
        if (server == null) {
            return fallbackPool;
        }
        GlobalPos pos = ItemManaMirror.getBoundPos(stack);
        if (pos == null) {
            return fallbackPool;
        }
        ResourceKey type = pos.m_122640_();
        ServerLevel world = server.m_129880_(type);
        if (world != null && (tile = world.m_7702_(pos.m_122646_())) instanceof IManaPool) {
            IManaPool pool = (IManaPool)tile;
            return pool;
        }
        return null;
    }

    @Override
    public boolean canReceiveManaFromPool(ItemStack stack, BlockEntity pool) {
        return false;
    }

    @Override
    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
        return false;
    }

    @Override
    public boolean canExportManaToPool(ItemStack stack, BlockEntity pool) {
        return false;
    }

    @Override
    public boolean canExportManaToItem(ItemStack stack, ItemStack otherStack) {
        return true;
    }

    @Override
    public boolean isNoExport(ItemStack stack) {
        return false;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return Optional.of(ManaBarTooltip.fromManaItem(stack));
    }

    private static class DummyPool
    implements IManaPool {
        private DummyPool() {
        }

        @Override
        public boolean isFull() {
            return false;
        }

        @Override
        public void receiveMana(int mana) {
        }

        @Override
        public boolean canReceiveManaFromBursts() {
            return false;
        }

        @Override
        public int getCurrentMana() {
            return 0;
        }

        @Override
        public boolean isOutputtingPower() {
            return false;
        }

        @Override
        public DyeColor getColor() {
            return DyeColor.WHITE;
        }

        @Override
        public void setColor(DyeColor color) {
        }
    }

    public static class CoordBoundItem
    implements ICoordBoundItem {
        private final ItemStack stack;

        public CoordBoundItem(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        @Nullable
        public BlockPos getBinding(Level world) {
            GlobalPos pos = ItemManaMirror.getBoundPos(this.stack);
            if (pos == null) {
                return null;
            }
            if (pos.m_122640_() == world.m_46472_()) {
                return pos.m_122646_();
            }
            return null;
        }
    }
}

