/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.common.helper.VecHelper;

public final class MathHelper {
    public static double angleBetween(Vec3 a, Vec3 b) {
        double projection = a.m_82541_().m_82526_(b.m_82541_());
        return Math.acos(Mth.m_14008_((double)projection, (double)-1.0, (double)1.0));
    }

    public static float pointDistanceSpace(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2));
    }

    public static float pointDistancePlane(double x1, double y1, double x2, double y2) {
        return (float)Math.hypot(x1 - x2, y1 - y2);
    }

    public static void setEntityMotionFromVector(Entity entity, Vec3 originalPosVector, float modifier) {
        Vec3 entityVector = VecHelper.fromEntityCenter(entity);
        Vec3 finalVector = originalPosVector.m_82546_(entityVector);
        if (finalVector.m_82553_() > 1.0) {
            finalVector = finalVector.m_82541_();
        }
        entity.m_20256_(finalVector.m_82490_((double)modifier));
    }

    public static int multiplyColor(int c1, int c2) {
        int r1 = (c1 & 0xFF0000) >> 16;
        int r2 = (c2 & 0xFF0000) >> 16;
        int g1 = (c1 & 0xFF00) >> 8;
        int g2 = (c2 & 0xFF00) >> 8;
        int b1 = c1 & 0xFF;
        int b2 = c2 & 0xFF;
        int r = (int)((float)r1 * ((float)r2 / 255.0f));
        int g = (int)((float)g1 * ((float)g2 / 255.0f));
        int b = (int)((float)b1 * ((float)b2 / 255.0f));
        return c1 & 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static long distSqr(Vec3i a, Vec3i b) {
        long dx = a.m_123341_() - b.m_123341_();
        long dy = a.m_123342_() - b.m_123342_();
        long dz = a.m_123343_() - b.m_123343_();
        return dx * dx + dy * dy + dz * dz;
    }
}

