/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.ModItems;

public class EntityThornChakram
extends ThrowableProjectile
implements ItemSupplier {
    private static final EntityDataAccessor<Integer> BOUNCES = SynchedEntityData.m_135353_(EntityThornChakram.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FLARE = SynchedEntityData.m_135353_(EntityThornChakram.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> RETURN_TO = SynchedEntityData.m_135353_(EntityThornChakram.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int MAX_BOUNCES = 16;
    private boolean bounced = false;
    private ItemStack stack = ItemStack.f_41583_;

    public EntityThornChakram(EntityType<EntityThornChakram> type, Level world) {
        super(type, world);
    }

    public EntityThornChakram(LivingEntity e, Level world, ItemStack stack) {
        super(ModEntities.THORN_CHAKRAM, e, world);
        this.stack = stack.m_41777_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BOUNCES, (Object)0);
        this.f_19804_.m_135372_(FLARE, (Object)false);
        this.f_19804_.m_135372_(RETURN_TO, (Object)-1);
    }

    public boolean m_6128_() {
        return true;
    }

    public void m_8119_() {
        Entity thrower;
        Vec3 old = this.m_20184_();
        super.m_8119_();
        if (!this.bounced) {
            this.m_20256_(old);
        }
        this.bounced = false;
        if (this.isReturning() && (thrower = this.m_37282_()) != null) {
            Vec3 motion = VecHelper.fromEntityCenter(thrower).m_82546_(VecHelper.fromEntityCenter((Entity)this)).m_82541_();
            this.m_20256_(motion);
        }
        if (this.f_19853_.f_46443_ && this.isFire()) {
            double r = 0.1;
            double m = 0.1;
            for (int i = 0; i < 3; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + r * (Math.random() - 0.5), this.m_20186_() + r * (Math.random() - 0.5), this.m_20189_() + r * (Math.random() - 0.5), m * (Math.random() - 0.5), m * (Math.random() - 0.5), m * (Math.random() - 0.5));
            }
        }
        if (!(this.f_19853_.f_46443_ || this.getTimesBounced() < 16 && this.f_19797_ <= 60)) {
            thrower = this.m_37282_();
            if (thrower == null) {
                this.dropAndKill();
            } else {
                this.setEntityToReturnTo(thrower.m_142049_());
                if (this.m_20280_(thrower) < 2.0) {
                    this.dropAndKill();
                }
            }
        }
    }

    private void dropAndKill() {
        ItemStack stack = this.getItemStack();
        ItemEntity item = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        this.f_19853_.m_7967_((Entity)item);
        this.m_146870_();
    }

    private ItemStack getItemStack() {
        return !this.stack.m_41619_() ? this.stack.m_41777_() : (this.isFire() ? new ItemStack((ItemLike)ModItems.flareChakram) : new ItemStack((ItemLike)ModItems.thornChakram));
    }

    protected void m_6532_(@Nonnull HitResult pos) {
        if (!this.isReturning()) {
            super.m_6532_(pos);
        }
    }

    protected void m_8060_(@Nonnull BlockHitResult hit) {
        super.m_8060_(hit);
        BlockState state = this.f_19853_.m_8055_(hit.m_82425_());
        if (state.m_60734_() instanceof BushBlock || state.m_60620_((Tag)BlockTags.f_13035_)) {
            return;
        }
        int bounces = this.getTimesBounced();
        if (bounces < 16) {
            Vec3 currentMovementVec = this.m_20184_();
            Direction dir = hit.m_82434_();
            Vec3 normalVector = new Vec3((double)dir.m_122429_(), (double)dir.m_122430_(), (double)dir.m_122431_()).m_82541_();
            Vec3 movementVec = normalVector.m_82490_(-2.0 * currentMovementVec.m_82526_(normalVector)).m_82549_(currentMovementVec);
            this.m_20256_(movementVec);
            this.bounced = true;
            if (!this.f_19853_.f_46443_) {
                this.setTimesBounced(this.getTimesBounced() + 1);
            }
        }
    }

    protected void m_5790_(@Nonnull EntityHitResult hit) {
        Entity entity;
        super.m_5790_(hit);
        if (!this.f_19853_.f_46443_ && (entity = hit.m_82443_()) instanceof LivingEntity) {
            LivingEntity hitEntity = (LivingEntity)entity;
            if (hit.m_82443_() != this.m_37282_()) {
                Entity thrower = this.m_37282_();
                DamageSource src = DamageSource.f_19318_;
                if (thrower instanceof Player) {
                    src = DamageSource.m_19361_((Entity)this, (Entity)thrower);
                } else if (thrower instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)thrower;
                    src = DamageSource.m_19370_((LivingEntity)livingEntity);
                }
                hitEntity.m_6469_(src, 12.0f);
                if (this.isFire()) {
                    hitEntity.m_20254_(5);
                } else if (this.f_19853_.f_46441_.nextInt(3) == 0) {
                    hitEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60, 0));
                }
            }
        }
    }

    protected float m_7139_() {
        return 0.0f;
    }

    private int getTimesBounced() {
        return (Integer)this.f_19804_.m_135370_(BOUNCES);
    }

    private void setTimesBounced(int times) {
        this.f_19804_.m_135381_(BOUNCES, (Object)times);
    }

    public boolean isFire() {
        return (Boolean)this.f_19804_.m_135370_(FLARE);
    }

    public void setFire(boolean fire) {
        this.f_19804_.m_135381_(FLARE, (Object)fire);
    }

    private boolean isReturning() {
        return this.getEntityToReturnTo() > -1;
    }

    private int getEntityToReturnTo() {
        return (Integer)this.f_19804_.m_135370_(RETURN_TO);
    }

    private void setEntityToReturnTo(int entityID) {
        this.f_19804_.m_135381_(RETURN_TO, (Object)entityID);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (!this.stack.m_41619_()) {
            compound.m_128365_("fly_stack", (net.minecraft.nbt.Tag)this.stack.m_41739_(new CompoundTag()));
        }
        compound.m_128379_("flare", this.isFire());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("fly_stack")) {
            this.stack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("fly_stack"));
        }
        this.setFire(compound.m_128471_("flare"));
    }

    @Nonnull
    public ItemStack m_7846_() {
        return this.getItemStack();
    }
}

