/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ILensEffect;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.mana.IManaCollisionGhost;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.IManaSpreader;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.tile.mana.IThrottledPacket;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.proxy.IProxy;
import vazkii.botania.xplat.BotaniaConfig;

public class EntityManaBurst
extends ThrowableProjectile
implements IManaBurst {
    private static final String TAG_TICKS_EXISTED = "ticksExisted";
    private static final String TAG_COLOR = "color";
    private static final String TAG_MANA = "mana";
    private static final String TAG_STARTING_MANA = "startingMana";
    private static final String TAG_MIN_MANA_LOSS = "minManaLoss";
    private static final String TAG_TICK_MANA_LOSS = "manaLossTick";
    private static final String TAG_SPREADER_X = "spreaderX";
    private static final String TAG_SPREADER_Y = "spreaderY";
    private static final String TAG_SPREADER_Z = "spreaderZ";
    private static final String TAG_GRAVITY = "gravity";
    private static final String TAG_LENS_STACK = "lensStack";
    private static final String TAG_HAS_SHOOTER = "hasShooter";
    private static final String TAG_SHOOTER = "shooterUUID";
    private static final String TAG_LAST_COLLISION_X = "lastCollisionX";
    private static final String TAG_LAST_COLLISION_Y = "lastCollisionY";
    private static final String TAG_LAST_COLLISION_Z = "lastCollisionZ";
    private static final String TAG_WARPED = "warped";
    private static final String TAG_ORBIT_TIME = "orbitTime";
    private static final String TAG_TRIPPED = "tripped";
    private static final String TAG_MAGNETIZE_POS = "magnetizePos";
    private static final String TAG_LEFT_SOURCE = "leftSource";
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(EntityManaBurst.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MANA = SynchedEntityData.m_135353_(EntityManaBurst.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> START_MANA = SynchedEntityData.m_135353_(EntityManaBurst.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MIN_MANA_LOSS = SynchedEntityData.m_135353_(EntityManaBurst.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> MANA_LOSS_PER_TICK = SynchedEntityData.m_135353_(EntityManaBurst.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> GRAVITY = SynchedEntityData.m_135353_(EntityManaBurst.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<BlockPos> SOURCE_COORDS = SynchedEntityData.m_135353_(EntityManaBurst.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<ItemStack> SOURCE_LENS = SynchedEntityData.m_135353_(EntityManaBurst.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> LEFT_SOURCE_POS = SynchedEntityData.m_135353_(EntityManaBurst.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float accumulatedManaLoss = 0.0f;
    private boolean fake = false;
    private final Set<BlockPos> alreadyCollidedAt = new HashSet<BlockPos>();
    private boolean fullManaLastTick = true;
    private UUID shooterIdentity = null;
    private int _ticksExisted = 0;
    private boolean scanBeam = false;
    private BlockPos lastCollision;
    private boolean warped = false;
    private int orbitTime = 0;
    private boolean tripped = false;
    private BlockPos magnetizePos = null;
    public final List<PositionProperties> propsList = new ArrayList<PositionProperties>();
    private BlockEntity collidedTile = null;
    private boolean noParticles = false;

    public EntityManaBurst(EntityType<EntityManaBurst> type, Level world) {
        super(type, world);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(COLOR, (Object)0);
        this.f_19804_.m_135372_(MANA, (Object)0);
        this.f_19804_.m_135372_(START_MANA, (Object)0);
        this.f_19804_.m_135372_(MIN_MANA_LOSS, (Object)0);
        this.f_19804_.m_135372_(MANA_LOSS_PER_TICK, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(GRAVITY, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SOURCE_COORDS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(SOURCE_LENS, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(LEFT_SOURCE_POS, (Object)false);
    }

    public EntityManaBurst(IManaSpreader spreader, boolean fake) {
        this(ModEntities.MANA_BURST, ((BlockEntity)spreader).m_58904_());
        BlockEntity tile = spreader.tileEntity();
        this.fake = fake;
        this.setBurstSourceCoords(tile.m_58899_());
        this.m_7678_((double)tile.m_58899_().m_123341_() + 0.5, (double)tile.m_58899_().m_123342_() + 0.5, (double)tile.m_58899_().m_123343_() + 0.5, 0.0f, 0.0f);
        this.m_146922_(-(spreader.getRotationX() + 90.0f));
        this.m_146926_(spreader.getRotationY());
        float f = 0.4f;
        double mx = (double)(Mth.m_14031_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(this.m_146909_() / 180.0f * (float)Math.PI)) * f) / 2.0;
        double mz = (double)(-(Mth.m_14089_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(this.m_146909_() / 180.0f * (float)Math.PI)) * f)) / 2.0;
        double my = (double)(Mth.m_14031_((float)(this.m_146909_() / 180.0f * (float)Math.PI)) * f) / 2.0;
        this.m_20334_(mx, my, mz);
    }

    public EntityManaBurst(Player player) {
        super(ModEntities.MANA_BURST, (LivingEntity)player, player.f_19853_);
        this.setBurstSourceCoords(NO_SOURCE);
        this.m_19915_(player.m_146908_() + 180.0f, -player.m_146909_());
        float f = 0.4f;
        double mx = (double)(Mth.m_14031_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(this.m_146909_() / 180.0f * (float)Math.PI)) * f) / 2.0;
        double mz = (double)(-(Mth.m_14089_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(this.m_146909_() / 180.0f * (float)Math.PI)) * f)) / 2.0;
        double my = (double)(Mth.m_14031_((float)(this.m_146909_() / 180.0f * (float)Math.PI)) * f) / 2.0;
        this.m_20334_(mx, my, mz);
    }

    public void m_8119_() {
        ILensEffect lens;
        this.setTicksExisted(this.getTicksExisted() + 1);
        if (!(this.f_19853_.f_46443_ && !this.fake || this.hasLeftSource() || this.m_142538_().equals((Object)this.getBurstSourceBlockPos()))) {
            this.f_19804_.m_135381_(LEFT_SOURCE_POS, (Object)true);
        }
        super.m_8119_();
        if (!this.fake && this.m_6084_() && !this.scanBeam) {
            this.ping();
        }
        if ((lens = this.getLensInstance()) != null) {
            lens.updateBurst(this, this.getSourceLens());
        }
        int mana = this.getMana();
        if (this.getTicksExisted() >= this.getMinManaLoss()) {
            this.accumulatedManaLoss += this.getManaLossPerTick();
            int loss = (int)this.accumulatedManaLoss;
            this.setMana(mana - loss);
            this.accumulatedManaLoss -= (float)loss;
            if (this.getMana() <= 0) {
                this.m_146870_();
            }
        }
        this.particles();
        boolean bl = this.fullManaLastTick = this.getMana() == this.getStartingMana();
        if (this.scanBeam) {
            PositionProperties props = new PositionProperties((Entity)this);
            if (this.propsList.isEmpty()) {
                this.propsList.add(props);
            } else {
                PositionProperties lastProps = this.propsList.get(this.propsList.size() - 1);
                if (!props.coordsEqual(lastProps)) {
                    this.propsList.add(props);
                }
            }
        }
    }

    public boolean m_19943_(Tag<Fluid> fluid, double mag) {
        return false;
    }

    public boolean m_20077_() {
        return false;
    }

    public BlockEntity getCollidedTile(boolean noParticles) {
        this.noParticles = noParticles;
        for (int iterations = 0; this.m_6084_() && iterations < BotaniaConfig.common().spreaderTraceTime(); ++iterations) {
            this.m_8119_();
        }
        if (this.fake) {
            this.incrementFakeParticleTick();
        }
        return this.collidedTile;
    }

    public boolean m_6072_() {
        return !this.fake;
    }

    public void m_7380_(CompoundTag tag) {
        UUID identity;
        super.m_7380_(tag);
        if (this.fake) {
            String msg = String.format("Fake bursts should never be saved at any time! Source pos %s, owner %s", this.getBurstSourceBlockPos(), this.m_37282_());
            throw new IllegalStateException(msg);
        }
        tag.m_128405_(TAG_TICKS_EXISTED, this.getTicksExisted());
        tag.m_128405_(TAG_COLOR, this.getColor());
        tag.m_128405_(TAG_MANA, this.getMana());
        tag.m_128405_(TAG_STARTING_MANA, this.getStartingMana());
        tag.m_128405_(TAG_MIN_MANA_LOSS, this.getMinManaLoss());
        tag.m_128350_(TAG_TICK_MANA_LOSS, this.getManaLossPerTick());
        tag.m_128350_(TAG_GRAVITY, this.getBurstGravity());
        ItemStack stack = this.getSourceLens();
        CompoundTag lensCmp = new CompoundTag();
        if (!stack.m_41619_()) {
            lensCmp = stack.m_41739_(lensCmp);
        }
        tag.m_128365_(TAG_LENS_STACK, (net.minecraft.nbt.Tag)lensCmp);
        BlockPos coords = this.getBurstSourceBlockPos();
        tag.m_128405_(TAG_SPREADER_X, coords.m_123341_());
        tag.m_128405_(TAG_SPREADER_Y, coords.m_123342_());
        tag.m_128405_(TAG_SPREADER_Z, coords.m_123343_());
        if (this.lastCollision != null) {
            tag.m_128405_(TAG_LAST_COLLISION_X, this.lastCollision.m_123341_());
            tag.m_128405_(TAG_LAST_COLLISION_Y, this.lastCollision.m_123342_());
            tag.m_128405_(TAG_LAST_COLLISION_Z, this.lastCollision.m_123343_());
        }
        boolean hasShooter = (identity = this.getShooterUUID()) != null;
        tag.m_128379_(TAG_HAS_SHOOTER, hasShooter);
        if (hasShooter) {
            tag.m_128362_(TAG_SHOOTER, identity);
        }
        tag.m_128379_(TAG_WARPED, this.warped);
        tag.m_128405_(TAG_ORBIT_TIME, this.orbitTime);
        tag.m_128379_(TAG_TRIPPED, this.tripped);
        if (this.magnetizePos != null) {
            tag.m_128365_(TAG_MAGNETIZE_POS, (net.minecraft.nbt.Tag)BlockPos.f_121852_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.magnetizePos).get().orThrow());
        }
        tag.m_128379_(TAG_LEFT_SOURCE, this.hasLeftSource());
    }

    public void m_7378_(CompoundTag cmp) {
        UUID identity;
        UUID serializedUuid;
        super.m_7378_(cmp);
        this.setTicksExisted(cmp.m_128451_(TAG_TICKS_EXISTED));
        this.setColor(cmp.m_128451_(TAG_COLOR));
        this.setMana(cmp.m_128451_(TAG_MANA));
        this.setStartingMana(cmp.m_128451_(TAG_STARTING_MANA));
        this.setMinManaLoss(cmp.m_128451_(TAG_MIN_MANA_LOSS));
        this.setManaLossPerTick(cmp.m_128457_(TAG_TICK_MANA_LOSS));
        this.setGravity(cmp.m_128457_(TAG_GRAVITY));
        CompoundTag lensCmp = cmp.m_128469_(TAG_LENS_STACK);
        ItemStack stack = ItemStack.m_41712_((CompoundTag)lensCmp);
        if (!stack.m_41619_()) {
            this.setSourceLens(stack);
        } else {
            this.setSourceLens(ItemStack.f_41583_);
        }
        int x = cmp.m_128451_(TAG_SPREADER_X);
        int y = cmp.m_128451_(TAG_SPREADER_Y);
        int z = cmp.m_128451_(TAG_SPREADER_Z);
        this.setBurstSourceCoords(new BlockPos(x, y, z));
        if (cmp.m_128441_(TAG_LAST_COLLISION_X)) {
            x = cmp.m_128451_(TAG_LAST_COLLISION_X);
            y = cmp.m_128451_(TAG_LAST_COLLISION_Y);
            z = cmp.m_128451_(TAG_LAST_COLLISION_Z);
            this.lastCollision = new BlockPos(x, y, z);
        }
        ListTag motion = cmp.m_128437_("Motion", 6);
        this.m_20334_(motion.m_128772_(0), motion.m_128772_(1), motion.m_128772_(2));
        boolean hasShooter = cmp.m_128471_(TAG_HAS_SHOOTER);
        if (hasShooter && !(serializedUuid = cmp.m_128342_(TAG_SHOOTER)).equals(identity = this.getShooterUUID())) {
            this.setShooterUUID(serializedUuid);
        }
        this.warped = cmp.m_128471_(TAG_WARPED);
        this.orbitTime = cmp.m_128451_(TAG_ORBIT_TIME);
        this.tripped = cmp.m_128471_(TAG_TRIPPED);
        this.magnetizePos = cmp.m_128441_(TAG_MAGNETIZE_POS) ? (BlockPos)BlockPos.f_121852_.parse((DynamicOps)NbtOps.f_128958_, (Object)cmp.m_128423_(TAG_MAGNETIZE_POS)).get().orThrow() : null;
        this.f_19804_.m_135381_(LEFT_SOURCE_POS, (Object)cmp.m_128471_(TAG_LEFT_SOURCE));
    }

    public void particles() {
        float osize;
        if (!this.m_6084_() || !this.f_19853_.f_46443_) {
            return;
        }
        ILensEffect lens = this.getLensInstance();
        if (lens != null && !lens.doParticles(this, this.getSourceLens())) {
            return;
        }
        int color = this.getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float size = osize = this.getParticleSize();
        if (this.fake) {
            if (this.getMana() == this.getStartingMana()) {
                size = 2.0f;
            } else if (this.fullManaLastTick) {
                size = 4.0f;
            }
            if (!this.noParticles && this.shouldDoFakeParticles()) {
                SparkleParticleData data = SparkleParticleData.fake(0.4f * size, r, g, b, 1);
                IProxy.INSTANCE.addParticleForce(this.f_19853_, data, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        } else {
            boolean depth;
            boolean bl = depth = !IProxy.INSTANCE.isClientPlayerWearingMonocle();
            if (BotaniaConfig.client().subtlePowerSystem()) {
                WispParticleData data = WispParticleData.wisp(0.1f * size, r, g, b, depth);
                IProxy.INSTANCE.addParticleForceNear(this.f_19853_, data, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)(Math.random() - 0.5) * 0.02f, (float)(Math.random() - 0.5) * 0.02f, (float)(Math.random() - 0.5) * 0.01f);
            } else {
                WispParticleData data;
                float or = r;
                float og = g;
                float ob = b;
                double luminance = 0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b;
                double iterX = this.m_20185_();
                double iterY = this.m_20186_();
                double iterZ = this.m_20189_();
                Vec3 currentPos = this.m_20182_();
                Vec3 oldPos = new Vec3(this.f_19854_, this.f_19855_, this.f_19856_);
                Vec3 diffVec = oldPos.m_82546_(currentPos);
                Vec3 diffVecNorm = diffVec.m_82541_();
                double distance = 0.095;
                do {
                    if (luminance < 0.1) {
                        r = or + (float)Math.random() * 0.125f;
                        g = og + (float)Math.random() * 0.125f;
                        b = ob + (float)Math.random() * 0.125f;
                    }
                    size = osize + ((float)Math.random() - 0.5f) * 0.065f + (float)Math.sin(new Random(this.f_19820_.getMostSignificantBits()).nextInt(9001)) * 0.4f;
                    data = WispParticleData.wisp(0.2f * size, r, g, b, depth);
                    IProxy.INSTANCE.addParticleForceNear(this.f_19853_, data, iterX, iterY, iterZ, (float)(-this.m_20184_().m_7096_()) * 0.01f, (float)(-this.m_20184_().m_7098_()) * 0.01f, (float)(-this.m_20184_().m_7094_()) * 0.01f);
                    currentPos = new Vec3(iterX += diffVecNorm.f_82479_ * distance, iterY += diffVecNorm.f_82480_ * distance, iterZ += diffVecNorm.f_82481_ * distance);
                    diffVec = oldPos.m_82546_(currentPos);
                } while (this.getOrbitTime() <= 0 && Math.abs(diffVec.m_82553_()) > distance);
                data = WispParticleData.wisp(0.1f * size, or, og, ob, depth);
                this.f_19853_.m_7106_((ParticleOptions)data, iterX, iterY, iterZ, (double)((float)(Math.random() - 0.5) * 0.06f), (double)((float)(Math.random() - 0.5) * 0.06f), (double)((float)(Math.random() - 0.5) * 0.06f));
            }
        }
    }

    public float getParticleSize() {
        return (float)this.getMana() / (float)this.getStartingMana();
    }

    protected void m_8060_(@Nonnull BlockHitResult hit) {
        IManaReceiver receiver;
        IManaCollisionGhost ghost;
        BlockPos collidePos;
        if (!this.isFake()) {
            super.m_8060_(hit);
        }
        if ((collidePos = hit.m_82425_()).equals((Object)this.lastCollision)) {
            return;
        }
        this.lastCollision = collidePos.m_7949_();
        BlockEntity tile = this.f_19853_.m_7702_(collidePos);
        BlockState state = this.f_19853_.m_8055_(collidePos);
        Block block = state.m_60734_();
        if (block instanceof IManaCollisionGhost && (ghost = (IManaCollisionGhost)block).isGhost(state, this.f_19853_, collidePos) && !(block instanceof IManaTrigger) || block instanceof BushBlock || block instanceof LeavesBlock) {
            return;
        }
        BlockPos sourcePos = this.getBurstSourceBlockPos();
        if (!this.hasLeftSource() && collidePos.equals((Object)sourcePos)) {
            return;
        }
        this.collidedTile = tile;
        if (!this.fake && !this.noParticles && !this.f_19853_.f_46443_ && tile instanceof IManaReceiver && (receiver = (IManaReceiver)tile).canReceiveManaFromBursts()) {
            this.onReceiverImpact(receiver);
        }
        if (block instanceof IManaTrigger) {
            IManaTrigger trigger = (IManaTrigger)block;
            trigger.onBurstCollision(this, this.f_19853_, collidePos);
        }
        if (block instanceof IManaCollisionGhost) {
            return;
        }
        this.onHitCommon((HitResult)hit, true);
        if (!this.hasAlreadyCollidedAt(collidePos)) {
            this.alreadyCollidedAt.add(collidePos);
        }
    }

    protected void m_5790_(@Nonnull EntityHitResult hit) {
        super.m_5790_(hit);
        this.onHitCommon((HitResult)hit, false);
    }

    private void onHitCommon(HitResult hit, boolean shouldKill) {
        ILensEffect lens = this.getLensInstance();
        if (lens != null) {
            IManaReceiver receiver;
            BlockEntity blockEntity = this.collidedTile;
            shouldKill = lens.collideBurst(this, hit, blockEntity instanceof IManaReceiver && (receiver = (IManaReceiver)blockEntity).canReceiveManaFromBursts(), shouldKill, this.getSourceLens());
        }
        if (shouldKill && this.m_6084_()) {
            if (!this.fake && this.f_19853_.f_46443_) {
                int color = this.getColor();
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                int mana = this.getMana();
                int maxMana = this.getStartingMana();
                float size = (float)mana / (float)maxMana;
                if (!BotaniaConfig.client().subtlePowerSystem()) {
                    for (int i = 0; i < 4; ++i) {
                        WispParticleData data = WispParticleData.wisp(0.15f * size, r, g, b);
                        this.f_19853_.m_7106_((ParticleOptions)data, this.m_20185_(), this.m_20186_(), this.m_20189_(), (double)((float)(Math.random() - 0.5) * 0.04f), (double)((float)(Math.random() - 0.5) * 0.04f), (double)((float)(Math.random() - 0.5) * 0.04f));
                    }
                }
                SparkleParticleData data = SparkleParticleData.sparkle(4.0f, r, g, b, 2);
                this.f_19853_.m_7106_((ParticleOptions)data, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
            this.m_146870_();
        }
    }

    private void onReceiverImpact(IManaReceiver tile) {
        if (this.hasWarped()) {
            return;
        }
        ILensEffect lens = this.getLensInstance();
        int mana = this.getMana();
        if (lens != null) {
            ItemStack stack = this.getSourceLens();
            mana = lens.getManaToTransfer(this, stack, tile);
        }
        if (tile instanceof IManaCollector) {
            IManaCollector collector = (IManaCollector)tile;
            mana = (int)((float)mana * collector.getManaYieldMultiplier(this));
        }
        tile.receiveMana(mana);
        if (tile instanceof IThrottledPacket) {
            IThrottledPacket throttledPacket = (IThrottledPacket)((Object)tile);
            throttledPacket.markDispatchable();
        } else {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile.tileEntity());
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (!this.fake) {
            BlockEntity tile = this.getShooter();
            if (tile instanceof IManaSpreader) {
                IManaSpreader spreader = (IManaSpreader)tile;
                spreader.setCanShoot(true);
            }
        } else {
            this.setDeathTicksForFakeParticle();
        }
    }

    private BlockEntity getShooter() {
        return this.f_19853_.m_7702_(this.getBurstSourceBlockPos());
    }

    public float m_7139_() {
        return this.getBurstGravity();
    }

    @Override
    public boolean isFake() {
        return this.fake;
    }

    @Override
    public void setFake(boolean fake) {
        this.fake = fake;
    }

    public void setScanBeam() {
        this.scanBeam = true;
    }

    @Override
    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    @Override
    public void setColor(int color) {
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    @Override
    public int getMana() {
        return (Integer)this.f_19804_.m_135370_(MANA);
    }

    @Override
    public void setMana(int mana) {
        this.f_19804_.m_135381_(MANA, (Object)mana);
    }

    @Override
    public int getStartingMana() {
        return (Integer)this.f_19804_.m_135370_(START_MANA);
    }

    @Override
    public void setStartingMana(int mana) {
        this.f_19804_.m_135381_(START_MANA, (Object)mana);
    }

    @Override
    public int getMinManaLoss() {
        return (Integer)this.f_19804_.m_135370_(MIN_MANA_LOSS);
    }

    @Override
    public void setMinManaLoss(int minManaLoss) {
        this.f_19804_.m_135381_(MIN_MANA_LOSS, (Object)minManaLoss);
    }

    @Override
    public float getManaLossPerTick() {
        return ((Float)this.f_19804_.m_135370_(MANA_LOSS_PER_TICK)).floatValue();
    }

    @Override
    public void setManaLossPerTick(float mana) {
        this.f_19804_.m_135381_(MANA_LOSS_PER_TICK, (Object)Float.valueOf(mana));
    }

    @Override
    public float getBurstGravity() {
        return ((Float)this.f_19804_.m_135370_(GRAVITY)).floatValue();
    }

    @Override
    public void setGravity(float gravity) {
        this.f_19804_.m_135381_(GRAVITY, (Object)Float.valueOf(gravity));
    }

    @Override
    public BlockPos getBurstSourceBlockPos() {
        return (BlockPos)this.f_19804_.m_135370_(SOURCE_COORDS);
    }

    @Override
    public void setBurstSourceCoords(BlockPos pos) {
        this.f_19804_.m_135381_(SOURCE_COORDS, (Object)pos);
    }

    @Override
    public ItemStack getSourceLens() {
        return (ItemStack)this.f_19804_.m_135370_(SOURCE_LENS);
    }

    @Override
    public void setSourceLens(ItemStack lens) {
        this.f_19804_.m_135381_(SOURCE_LENS, (Object)lens);
    }

    @Override
    public int getTicksExisted() {
        return this._ticksExisted;
    }

    @Override
    public boolean hasLeftSource() {
        return (Boolean)this.f_19804_.m_135370_(LEFT_SOURCE_POS);
    }

    public void setTicksExisted(int ticks) {
        this._ticksExisted = ticks;
    }

    private ILensEffect getLensInstance() {
        Item item;
        ItemStack lens = this.getSourceLens();
        if (!lens.m_41619_() && (item = lens.m_41720_()) instanceof ILensEffect) {
            ILensEffect effect = (ILensEffect)item;
            return effect;
        }
        return null;
    }

    @Override
    public boolean hasAlreadyCollidedAt(BlockPos pos) {
        return this.alreadyCollidedAt.contains(pos);
    }

    @Override
    public void setCollidedAt(BlockPos pos) {
        if (!this.hasAlreadyCollidedAt(pos)) {
            this.alreadyCollidedAt.add(pos.m_7949_());
        }
    }

    @Override
    public void setShooterUUID(UUID uuid) {
        this.shooterIdentity = uuid;
    }

    @Override
    public UUID getShooterUUID() {
        return this.shooterIdentity;
    }

    @Override
    public void ping() {
        BlockEntity tile = this.getShooter();
        if (tile instanceof IManaSpreader) {
            IManaSpreader spreader = (IManaSpreader)tile;
            spreader.pingback(this, this.getShooterUUID());
        }
    }

    @Override
    public boolean hasWarped() {
        return this.warped;
    }

    @Override
    public void setWarped(boolean warped) {
        this.warped = warped;
    }

    @Override
    public int getOrbitTime() {
        return this.orbitTime;
    }

    @Override
    public void setOrbitTime(int time) {
        this.orbitTime = time;
    }

    @Override
    public boolean hasTripped() {
        return this.tripped;
    }

    @Override
    public void setTripped(boolean tripped) {
        this.tripped = tripped;
    }

    @Override
    @Nullable
    public BlockPos getMagnetizedPos() {
        return this.magnetizePos;
    }

    @Override
    public void setMagnetizePos(@Nullable BlockPos pos) {
        this.magnetizePos = pos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean shouldDoFakeParticles() {
        if (BotaniaConfig.client().staticWandBeam()) {
            return true;
        }
        BlockEntity tile = this.getShooter();
        if (!(tile instanceof IManaSpreader)) return false;
        IManaSpreader spreader = (IManaSpreader)tile;
        if (this.getMana() != this.getStartingMana()) {
            if (this.fullManaLastTick) return true;
        }
        if (Math.abs(spreader.getBurstParticleTick() - this.getTicksExisted()) >= 4) return false;
        return true;
    }

    private void incrementFakeParticleTick() {
        BlockEntity tile = this.getShooter();
        if (tile instanceof IManaSpreader) {
            IManaSpreader spreader = (IManaSpreader)tile;
            spreader.setBurstParticleTick(spreader.getBurstParticleTick() + 2);
            if (spreader.getLastBurstDeathTick() != -1 && spreader.getBurstParticleTick() > spreader.getLastBurstDeathTick()) {
                spreader.setBurstParticleTick(0);
            }
        }
    }

    private void setDeathTicksForFakeParticle() {
        BlockPos coords = this.getBurstSourceBlockPos();
        BlockEntity tile = this.f_19853_.m_7702_(coords);
        if (tile instanceof IManaSpreader) {
            IManaSpreader spreader = (IManaSpreader)tile;
            spreader.setLastBurstDeathTick(this.getTicksExisted());
        }
    }

    public static class PositionProperties {
        public final BlockPos coords;
        public final BlockState state;
        public boolean invalid = false;

        public PositionProperties(Entity entity) {
            this.coords = entity.m_142538_();
            this.state = entity.m_146900_();
        }

        public boolean coordsEqual(PositionProperties props) {
            return this.coords.equals((Object)props.coords);
        }

        public boolean contentsEqual(Level world) {
            if (!world.m_46805_(this.coords)) {
                this.invalid = true;
                return false;
            }
            return world.m_8055_(this.coords) == this.state;
        }

        public int hashCode() {
            return Objects.hash(this.coords, this.state);
        }

        public boolean equals(Object o) {
            return o instanceof PositionProperties && ((PositionProperties)o).state == this.state && ((PositionProperties)o).coords.equals((Object)this.coords);
        }
    }
}

