/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.entity.EntityThrowableCopy;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.relic.ItemKingKey;

public class EntityBabylonWeapon
extends EntityThrowableCopy {
    private static final String TAG_CHARGING = "charging";
    private static final String TAG_VARIETY = "variety";
    private static final String TAG_CHARGE_TICKS = "chargeTicks";
    private static final String TAG_LIVE_TICKS = "liveTicks";
    private static final String TAG_DELAY = "delay";
    private static final String TAG_ROTATION = "rotation";
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(EntityBabylonWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIETY = SynchedEntityData.m_135353_(EntityBabylonWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CHARGE_TICKS = SynchedEntityData.m_135353_(EntityBabylonWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LIVE_TICKS = SynchedEntityData.m_135353_(EntityBabylonWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DELAY = SynchedEntityData.m_135353_(EntityBabylonWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> ROTATION = SynchedEntityData.m_135353_(EntityBabylonWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public EntityBabylonWeapon(EntityType<EntityBabylonWeapon> type, Level world) {
        super(type, world);
    }

    public EntityBabylonWeapon(LivingEntity thrower, Level world) {
        super(ModEntities.BABYLON_WEAPON, thrower, world);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CHARGING, (Object)false);
        this.f_19804_.m_135372_(VARIETY, (Object)0);
        this.f_19804_.m_135372_(CHARGE_TICKS, (Object)0);
        this.f_19804_.m_135372_(LIVE_TICKS, (Object)0);
        this.f_19804_.m_135372_(DELAY, (Object)0);
        this.f_19804_.m_135372_(ROTATION, (Object)Float.valueOf(0.0f));
    }

    @Override
    public boolean m_6783_(double dist) {
        return dist < 4096.0;
    }

    public boolean m_6128_() {
        return true;
    }

    @Override
    public void m_8119_() {
        boolean charging;
        Entity thrower = this.m_37282_();
        if (!(this.f_19853_.f_46443_ || thrower != null && thrower instanceof Player && thrower.m_6084_())) {
            this.m_146870_();
            return;
        }
        Player player = (Player)thrower;
        if (!this.f_19853_.f_46443_) {
            boolean newCharging;
            ItemStack stack = PlayerHelper.getFirstHeldItem((LivingEntity)player, ModItems.kingKey);
            boolean bl = newCharging = !stack.m_41619_() && ItemKingKey.isCharging(stack);
            if (this.isCharging() != newCharging) {
                this.setCharging(newCharging);
            }
        }
        Vec3 mot = this.m_20184_();
        int liveTime = this.getLiveTicks();
        int delay = this.getDelay();
        boolean bl = charging = this.isCharging() && liveTime == 0;
        if (charging) {
            this.m_20256_(Vec3.f_82478_);
            int chargeTime = this.getChargeTicks();
            this.setChargeTicks(chargeTime + 1);
            if (this.f_19853_.f_46441_.nextInt(20) == 0) {
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), ModSounds.babylonSpawn, SoundSource.PLAYERS, 0.1f, 1.0f + this.f_19853_.f_46441_.nextFloat() * 3.0f);
            }
        } else {
            if (liveTime < delay) {
                this.m_20256_(Vec3.f_82478_);
            } else if (liveTime == delay && player != null) {
                BlockHitResult rtr = ToolCommons.raytraceFromEntity((Entity)player, 64.0, true);
                Vec3 playerLook = rtr.m_6662_() != HitResult.Type.BLOCK ? player.m_20154_().m_82490_(64.0).m_82549_(player.m_20182_()) : Vec3.m_82512_((Vec3i)rtr.m_82425_());
                Vec3 thisVec = VecHelper.fromEntityCenter((Entity)this);
                mot = playerLook.m_82492_(thisVec.f_82479_, thisVec.f_82480_, thisVec.f_82481_).m_82541_().m_82490_(2.0);
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), ModSounds.babylonAttack, SoundSource.PLAYERS, 2.0f, 0.1f + this.f_19853_.f_46441_.nextFloat() * 3.0f);
            }
            if (!this.f_19853_.f_46443_) {
                this.setLiveTicks(liveTime + 1);
                AABB axis = new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19790_, this.f_19791_, this.f_19792_).m_82400_(2.0);
                List entities = this.f_19853_.m_45976_(LivingEntity.class, axis);
                for (LivingEntity living : entities) {
                    if (living == thrower || living.f_20916_ != 0) continue;
                    if (player != null) {
                        living.m_6469_(DamageSource.m_19344_((Player)player), 20.0f);
                    } else {
                        living.m_6469_(DamageSource.f_19318_, 20.0f);
                    }
                    this.m_6532_((HitResult)new EntityHitResult((Entity)living));
                    return;
                }
            }
        }
        super.m_8119_();
        this.m_20256_(mot);
        if (this.f_19853_.f_46443_ && liveTime > delay) {
            WispParticleData data = WispParticleData.wisp(0.3f, 1.0f, 1.0f, 0.0f, 1.0f);
            this.f_19853_.m_7106_((ParticleOptions)data, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, -0.0, 0.0);
        }
        if (!this.f_19853_.f_46443_ && liveTime > 200 + delay) {
            this.m_146870_();
        }
    }

    protected void m_8060_(@Nonnull BlockHitResult hit) {
        super.m_8060_(hit);
        this.explodeAndDie();
    }

    protected void m_5790_(@Nonnull EntityHitResult hit) {
        super.m_5790_(hit);
        if (hit.m_82443_() != this.m_37282_()) {
            this.explodeAndDie();
        }
    }

    private void explodeAndDie() {
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f, Explosion.BlockInteraction.NONE);
            this.m_146870_();
        }
    }

    public void m_7380_(@Nonnull CompoundTag cmp) {
        super.m_7380_(cmp);
        cmp.m_128379_(TAG_CHARGING, this.isCharging());
        cmp.m_128405_(TAG_VARIETY, this.getVariety());
        cmp.m_128405_(TAG_CHARGE_TICKS, this.getChargeTicks());
        cmp.m_128405_(TAG_LIVE_TICKS, this.getLiveTicks());
        cmp.m_128405_(TAG_DELAY, this.getDelay());
        cmp.m_128350_(TAG_ROTATION, this.getRotation());
    }

    public void m_7378_(@Nonnull CompoundTag cmp) {
        super.m_7378_(cmp);
        this.setCharging(cmp.m_128471_(TAG_CHARGING));
        this.setVariety(cmp.m_128451_(TAG_VARIETY));
        this.setChargeTicks(cmp.m_128451_(TAG_CHARGE_TICKS));
        this.setLiveTicks(cmp.m_128451_(TAG_LIVE_TICKS));
        this.setDelay(cmp.m_128451_(TAG_DELAY));
        this.setRotation(cmp.m_128457_(TAG_ROTATION));
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.f_19804_.m_135381_(CHARGING, (Object)charging);
    }

    public int getVariety() {
        return (Integer)this.f_19804_.m_135370_(VARIETY);
    }

    public void setVariety(int var) {
        this.f_19804_.m_135381_(VARIETY, (Object)var);
    }

    public int getChargeTicks() {
        return (Integer)this.f_19804_.m_135370_(CHARGE_TICKS);
    }

    public void setChargeTicks(int ticks) {
        this.f_19804_.m_135381_(CHARGE_TICKS, (Object)ticks);
    }

    public int getLiveTicks() {
        return (Integer)this.f_19804_.m_135370_(LIVE_TICKS);
    }

    public void setLiveTicks(int ticks) {
        this.f_19804_.m_135381_(LIVE_TICKS, (Object)ticks);
    }

    public int getDelay() {
        return (Integer)this.f_19804_.m_135370_(DELAY);
    }

    public void setDelay(int delay) {
        this.f_19804_.m_135381_(DELAY, (Object)delay);
    }

    public float getRotation() {
        return ((Float)this.f_19804_.m_135370_(ROTATION)).floatValue();
    }

    public void setRotation(float rot) {
        this.f_19804_.m_135381_(ROTATION, (Object)Float.valueOf(rot));
    }
}

