/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.botania.api.item.IAncientWillContainer;
import vazkii.botania.common.item.ItemAncientWill;

public class AncientWillRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<AncientWillRecipe> SERIALIZER = new SimpleRecipeSerializer(AncientWillRecipe::new);

    public AncientWillRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level world) {
        boolean foundWill = false;
        boolean foundItem = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ItemAncientWill && !foundWill) {
                foundWill = true;
                continue;
            }
            if (foundItem) continue;
            if (stack.m_41720_() instanceof IAncientWillContainer) {
                foundItem = true;
                continue;
            }
            return false;
        }
        return foundWill && foundItem;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        ItemStack item = ItemStack.f_41583_;
        IAncientWillContainer.AncientWillType will = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof IAncientWillContainer && item.m_41619_()) {
                item = stack;
                continue;
            }
            will = ((ItemAncientWill)stack.m_41720_()).type;
        }
        IAncientWillContainer container = (IAncientWillContainer)item.m_41720_();
        if (container.hasAncientWill(item, will)) {
            return ItemStack.f_41583_;
        }
        ItemStack copy = item.m_41777_();
        container.addAncientWill(copy, will);
        return copy;
    }

    public boolean m_8004_(int width, int height) {
        return width > 1 || height > 1;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

