/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.xplat.IXplatAbstractions;

public class TileRFGenerator
extends TileMod
implements IManaReceiver {
    private static final int MANA_TO_FE = IXplatAbstractions.INSTANCE.getEnergyMultiplier();
    public static final int MAX_ENERGY = 1280 * MANA_TO_FE;
    private static final String TAG_MANA = "mana";
    private int energy = 0;

    public TileRFGenerator(BlockPos pos, BlockState state) {
        super(ModTiles.FLUXFIELD, pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TileRFGenerator self) {
        int toTransfer = Math.min(self.energy, 160 * MANA_TO_FE);
        int unconsumed = IXplatAbstractions.INSTANCE.transferEnergyToNeighbors(level, pos, toTransfer);
        if (unconsumed != toTransfer) {
            self.energy -= toTransfer - unconsumed;
            self.m_6596_();
        }
    }

    @Override
    public int getCurrentMana() {
        return this.energy / MANA_TO_FE;
    }

    @Override
    public boolean isFull() {
        return this.energy >= MAX_ENERGY;
    }

    @Override
    public void receiveMana(int mana) {
        this.energy = Math.min(MAX_ENERGY, this.energy + mana * MANA_TO_FE);
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return true;
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128405_(TAG_MANA, this.energy);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.energy = cmp.m_128451_(TAG_MANA);
    }

    public int getEnergy() {
        return this.energy;
    }
}

