/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.CratePattern;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileOpenCrate;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.AccessorRecipeManager;
import vazkii.botania.xplat.IXplatAbstractions;

public class TileCraftCrate
extends TileOpenCrate
implements IWandable {
    private static final String TAG_CRAFTING_RESULT = "craft_result";
    private static int recipeEpoch = 0;
    private int signal = 0;
    private ItemStack craftResult = ItemStack.f_41583_;
    private final Queue<ResourceLocation> lastRecipes = new ArrayDeque<ResourceLocation>();
    private boolean dirty;
    private boolean matchFailed;
    private int lastRecipeEpoch = recipeEpoch;

    public static void registerListener() {
        IXplatAbstractions.INSTANCE.registerReloadListener(PackType.SERVER_DATA, ResourceLocationHelper.prefix("craft_crate_epoch_counter"), (PreparableReloadListener)((ResourceManagerReloadListener)mgr -> ++recipeEpoch));
    }

    public TileCraftCrate(BlockPos pos, BlockState state) {
        super(ModTiles.CRAFT_CRATE, pos, state);
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(9){

            public int m_6893_() {
                return 1;
            }

            public boolean m_7013_(int slot, ItemStack stack) {
                return !TileCraftCrate.this.isLocked(slot);
            }
        };
    }

    public CratePattern getPattern() {
        BlockState state = this.m_58900_();
        if (!state.m_60713_(ModBlocks.craftCrate)) {
            return CratePattern.NONE;
        }
        return (CratePattern)((Object)state.m_61143_(BotaniaStateProps.CRATE_PATTERN));
    }

    private boolean isLocked(int slot) {
        return this.getPattern().openSlots.get(slot) == false;
    }

    @Override
    public void readPacketNBT(CompoundTag tag) {
        super.readPacketNBT(tag);
        this.craftResult = ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_CRAFTING_RESULT));
    }

    @Override
    public void writePacketNBT(CompoundTag tag) {
        super.writePacketNBT(tag);
        tag.m_128365_(TAG_CRAFTING_RESULT, (Tag)this.craftResult.m_41739_(new CompoundTag()));
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, TileCraftCrate self) {
        int newSignal;
        if (recipeEpoch != self.lastRecipeEpoch) {
            self.lastRecipeEpoch = recipeEpoch;
            self.matchFailed = false;
        }
        if (!self.matchFailed && self.canEject() && self.isFull() && self.craft(true)) {
            self.ejectAll();
        }
        for (newSignal = 0; newSignal < 9 && (self.isLocked(newSignal) || !self.getItemHandler().m_8020_(newSignal).m_41619_()); ++newSignal) {
        }
        if (newSignal != self.signal) {
            self.signal = newSignal;
            level.m_46717_(worldPosition, state.m_60734_());
        }
        if (self.dirty) {
            self.dirty = false;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
        }
    }

    private boolean craft(boolean fullCheck) {
        this.f_58857_.m_46473_().m_6180_("craft");
        if (fullCheck && !this.isFull()) {
            return false;
        }
        CraftingContainer craft = new CraftingContainer(new AbstractContainerMenu(MenuType.f_39968_, -1){

            public boolean m_6875_(@Nonnull Player player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < craft.m_6643_(); ++i) {
            ItemStack stack = this.getItemHandler().m_8020_(i);
            if (stack.m_41619_() || this.isLocked(i) || stack.m_150930_(ModItems.placeholder)) continue;
            craft.m_6836_(i, stack);
        }
        Optional<CraftingRecipe> matchingRecipe = this.getMatchingRecipe(craft);
        matchingRecipe.ifPresent(recipe -> {
            this.craftResult = recipe.m_5874_((Container)craft);
            Container handler = this.getItemHandler();
            NonNullList remainders = recipe.m_7457_((Container)craft);
            for (int i = 0; i < craft.m_6643_(); ++i) {
                ItemStack s = (ItemStack)remainders.get(i);
                ItemStack inSlot = handler.m_8020_(i);
                if (inSlot.m_41619_() && s.m_41619_() || !inSlot.m_41619_() && inSlot.m_150930_(ModItems.placeholder)) continue;
                handler.m_6836_(i, s);
            }
        });
        if (!matchingRecipe.isPresent()) {
            this.matchFailed = true;
        }
        this.f_58857_.m_46473_().m_7238_();
        return matchingRecipe.isPresent();
    }

    private Optional<CraftingRecipe> getMatchingRecipe(CraftingContainer craft) {
        for (ResourceLocation currentRecipe : this.lastRecipes) {
            Recipe recipe = ((AccessorRecipeManager)this.f_58857_.m_7465_()).botania_getAll(RecipeType.f_44107_).get(currentRecipe);
            if (!(recipe instanceof CraftingRecipe)) continue;
            CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
            if (!recipe.m_5818_((Container)craft, this.f_58857_)) continue;
            return Optional.of(craftingRecipe);
        }
        Optional recipe = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craft, this.f_58857_);
        if (recipe.isPresent()) {
            if (this.lastRecipes.size() >= 8) {
                this.lastRecipes.remove();
            }
            this.lastRecipes.add(((CraftingRecipe)recipe.get()).m_6423_());
            return recipe;
        }
        return Optional.empty();
    }

    boolean isFull() {
        for (int i = 0; i < this.getItemHandler().m_6643_(); ++i) {
            if (this.isLocked(i) || !this.getItemHandler().m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private void ejectAll() {
        for (int i = 0; i < this.inventorySize(); ++i) {
            ItemStack stack = this.getItemHandler().m_8020_(i);
            if (stack.m_41619_()) continue;
            this.eject(stack, false);
            this.getItemHandler().m_6836_(i, ItemStack.f_41583_);
        }
        if (!this.craftResult.m_41619_()) {
            this.eject(this.craftResult, false);
            this.craftResult = ItemStack.f_41583_;
        }
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        if (!this.m_58904_().f_46443_ && this.canEject()) {
            this.craft(false);
            this.ejectAll();
        }
        return true;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.dirty = true;
            this.matchFailed = false;
        }
    }

    public int getSignal() {
        return this.signal;
    }

    public static class WandHud
    implements IWandHUD {
        private final TileCraftCrate crate;

        public WandHud(TileCraftCrate crate) {
            this.crate = crate;
        }

        @Override
        public void renderHUD(PoseStack ms, Minecraft mc) {
            int width = 52;
            int height = 52;
            int xc = mc.m_91268_().m_85445_() / 2 + 20;
            int yc = mc.m_91268_().m_85446_() / 2 - height / 2;
            GuiComponent.m_93172_((PoseStack)ms, (int)(xc - 6), (int)(yc - 6), (int)(xc + width + 6), (int)(yc + height + 6), (int)0x22000000);
            GuiComponent.m_93172_((PoseStack)ms, (int)(xc - 4), (int)(yc - 4), (int)(xc + width + 4), (int)(yc + height + 4), (int)0x22000000);
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int index = i * 3 + j;
                    int xp = xc + j * 18;
                    int yp = yc + i * 18;
                    boolean enabled = true;
                    if (this.crate.getPattern() != CratePattern.NONE) {
                        enabled = this.crate.getPattern().openSlots.get(index);
                    }
                    GuiComponent.m_93172_((PoseStack)ms, (int)xp, (int)yp, (int)(xp + 16), (int)(yp + 16), (int)(enabled ? 0x22FFFFFF : 0x22FF0000));
                    ItemStack item = this.crate.getItemHandler().m_8020_(index);
                    mc.m_91291_().m_115203_(item, xp, yp);
                }
            }
        }
    }
}

