/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block.IPetalApothecary;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.recipe.ICustomApothecaryColor;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.BlockAltar;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.xplat.IXplatAbstractions;

public class TileAltar
extends TileSimpleInventory
implements IPetalApothecary {
    private static final Pattern SEED_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)seed)|(?:(?:[a-z-_.:]|^)Seed))(?:[sA-Z-_.:]|$)");
    private static final int SET_KEEP_TICKS_EVENT = 0;
    private static final int CRAFT_EFFECT_EVENT = 1;
    public static final String ITEM_TAG_APOTHECARY_SPAWNED = "ApothecarySpawned";
    private List<ItemStack> lastRecipe = null;
    private int recipeKeepTicks = 0;

    public TileAltar(BlockPos pos, BlockState state) {
        super(ModTiles.ALTAR, pos, state);
    }

    public boolean collideEntityItem(ItemEntity item) {
        ItemStack stack = item.m_32055_();
        if (this.f_58857_.f_46443_ || stack.m_41619_() || !item.m_6084_()) {
            return false;
        }
        if (this.m_58900_().m_60713_(ModBlocks.defaultAltar) && stack.m_150930_(Blocks.f_50191_.m_5456_())) {
            CompoundTag tmp = new CompoundTag();
            this.writePacketNBT(tmp);
            stack.m_41774_(1);
            this.f_58857_.m_46597_(this.m_58899_(), ModBlocks.mossyAltar.m_49966_());
            BlockEntity newAltar = this.f_58857_.m_7702_(this.m_58899_());
            if (newAltar instanceof TileAltar) {
                TileAltar altar = (TileAltar)newAltar;
                altar.readPacketNBT(tmp);
            }
            return true;
        }
        if (this.getFluid() == IPetalApothecary.State.EMPTY) {
            MobBucketItem bucketItem;
            Item item2 = stack.m_41720_();
            if (item2 instanceof MobBucketItem && IXplatAbstractions.INSTANCE.getBucketFluid((BucketItem)(bucketItem = (MobBucketItem)item2)) == Fluids.f_76193_) {
                this.setFluid(IPetalApothecary.State.WATER);
                bucketItem.m_142131_(null, this.f_58857_, stack, this.m_58899_().m_7494_());
                item.m_32045_(new ItemStack((ItemLike)Items.f_42446_));
                return true;
            }
            if (IXplatAbstractions.INSTANCE.extractFluidFromItemEntity(item, (Fluid)Fluids.f_76193_)) {
                this.setFluid(IPetalApothecary.State.WATER);
                return true;
            }
            if (IXplatAbstractions.INSTANCE.extractFluidFromItemEntity(item, (Fluid)Fluids.f_76195_)) {
                this.setFluid(IPetalApothecary.State.LAVA);
                return true;
            }
            return false;
        }
        if (this.getFluid() == IPetalApothecary.State.LAVA) {
            item.m_20254_(100);
            return true;
        }
        if (SEED_PATTERN.matcher(stack.m_41778_()).find()) {
            Optional maybeRecipe = this.f_58857_.m_7465_().m_44015_(ModRecipeTypes.PETAL_TYPE, this.getItemHandler(), this.f_58857_);
            maybeRecipe.ifPresent(recipe -> {
                this.saveLastRecipe();
                ItemStack output = recipe.m_5874_(this.getItemHandler());
                for (int i = 0; i < this.inventorySize(); ++i) {
                    this.getItemHandler().m_6836_(i, ItemStack.f_41583_);
                }
                stack.m_41774_(1);
                ItemEntity outputItem = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5, output);
                IXplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)outputItem).apothecarySpawned = true;
                this.f_58857_.m_7967_((Entity)outputItem);
                this.setFluid(IPetalApothecary.State.EMPTY);
                this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 1, 0);
            });
            return maybeRecipe.isPresent();
        }
        if (!IXplatAbstractions.INSTANCE.isFluidContainer(item) && !IXplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).apothecarySpawned) {
            if (!this.getItemHandler().m_8020_(this.inventorySize() - 1).m_41619_()) {
                return false;
            }
            for (int i = 0; i < this.inventorySize(); ++i) {
                if (!this.getItemHandler().m_8020_(i).m_41619_()) continue;
                this.getItemHandler().m_6836_(i, stack.m_41620_(1));
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11917_, SoundSource.BLOCKS, 0.1f, 10.0f);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private ICustomApothecaryColor getFlowerComponent(ItemStack stack) {
        ICustomApothecaryColor c = null;
        Item item = stack.m_41720_();
        if (item instanceof ICustomApothecaryColor) {
            ICustomApothecaryColor color;
            c = color = (ICustomApothecaryColor)item;
        }
        return c;
    }

    public void saveLastRecipe() {
        ItemStack stack;
        this.lastRecipe = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inventorySize() && !(stack = this.getItemHandler().m_8020_(i)).m_41619_(); ++i) {
            this.lastRecipe.add(stack.m_41777_());
        }
        this.recipeKeepTicks = 400;
        this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, 400);
    }

    public void trySetLastRecipe(Player player) {
        TileAltar.tryToSetLastRecipe(player, this.getItemHandler(), this.lastRecipe);
        if (!this.isEmpty()) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    public static void tryToSetLastRecipe(Player player, Container inv, List<ItemStack> lastRecipe) {
        if (lastRecipe == null || lastRecipe.isEmpty() || player.f_19853_.f_46443_) {
            return;
        }
        int index = 0;
        boolean didAny = false;
        block0: for (ItemStack stack : lastRecipe) {
            if (stack.m_41619_()) continue;
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack pstack = player.m_150109_().m_8020_(i);
                if (!player.m_7500_() && (pstack.m_41619_() || !pstack.m_41656_(stack) || !ItemStack.m_41658_((ItemStack)stack, (ItemStack)pstack))) continue;
                inv.m_6836_(index, player.m_7500_() ? stack.m_41777_() : pstack.m_41620_(1));
                didAny = true;
                ++index;
                continue block0;
            }
        }
        if (didAny) {
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11917_, SoundSource.BLOCKS, 0.1f, 10.0f);
            ServerPlayer mp = (ServerPlayer)player;
            mp.f_36095_.m_38946_();
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.inventorySize(); ++i) {
            if (this.getItemHandler().m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private void tickRecipeKeep() {
        if (this.recipeKeepTicks > 0) {
            --this.recipeKeepTicks;
        } else {
            this.lastRecipe = null;
        }
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, TileAltar self) {
        List items = level.m_45976_(ItemEntity.class, new AABB(worldPosition.m_142022_(0.0, 1.25, 0.0), worldPosition.m_142022_(1.0, 2.0, 1.0)));
        boolean didChange = false;
        for (ItemEntity item : items) {
            didChange = self.collideEntityItem(item) || didChange;
        }
        if (didChange) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
        }
        self.tickRecipeKeep();
    }

    public static void clientTick(Level level, BlockPos worldPosition, BlockState state, TileAltar self) {
        ItemStack stackAt;
        for (int i = 0; i < self.inventorySize() && !(stackAt = self.getItemHandler().m_8020_(i)).m_41619_(); ++i) {
            if (!(Math.random() >= 0.97)) continue;
            ICustomApothecaryColor comp = self.getFlowerComponent(stackAt);
            int color = comp == null ? 0x888888 : comp.getParticleColor(stackAt);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            if (Math.random() >= 0.75) {
                level.m_5594_(null, worldPosition, SoundEvents.f_11917_, SoundSource.BLOCKS, 0.1f, 10.0f);
            }
            SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
            level.m_7106_((ParticleOptions)data, (double)worldPosition.m_123341_() + 0.5 + Math.random() * 0.4 - 0.2, (double)worldPosition.m_123342_() + 1.2, (double)worldPosition.m_123343_() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
        }
        if (self.getFluid() == IPetalApothecary.State.LAVA) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)worldPosition.m_123341_() + 0.5 + Math.random() * 0.4 - 0.2, (double)(worldPosition.m_123342_() + 1), (double)worldPosition.m_123343_() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.05, 0.0);
            if (Math.random() > 0.9) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)worldPosition.m_123341_() + 0.5 + Math.random() * 0.4 - 0.2, (double)(worldPosition.m_123342_() + 1), (double)worldPosition.m_123343_() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.01, 0.0);
            }
        }
        self.tickRecipeKeep();
    }

    public boolean m_7531_(int id, int param) {
        switch (id) {
            case 0: {
                this.recipeKeepTicks = param;
                return true;
            }
            case 1: {
                if (this.f_58857_.f_46443_) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.f_58857_.m_7106_((ParticleOptions)data, (double)this.f_58858_.m_123341_() + 0.5 + Math.random() * 0.4 - 0.2, (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                    this.f_58857_.m_7785_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), ModSounds.altarCraft, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                return true;
            }
        }
        return super.m_7531_(id, param);
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(16){

            public int m_6893_() {
                return 1;
            }
        };
    }

    @Override
    public void setFluid(IPetalApothecary.State fluid) {
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(BlockAltar.FLUID, (Comparable)((Object)fluid)));
    }

    @Override
    public IPetalApothecary.State getFluid() {
        return (IPetalApothecary.State)((Object)this.m_58900_().m_61143_(BlockAltar.FLUID));
    }

    public static class Hud {
        public static void render(TileAltar altar, PoseStack ms, Minecraft mc) {
            int xc = mc.m_91268_().m_85445_() / 2;
            int yc = mc.m_91268_().m_85446_() / 2;
            float angle = -90.0f;
            int radius = 24;
            int amt = 0;
            for (int i = 0; i < altar.inventorySize() && !altar.getItemHandler().m_8020_(i).m_41619_(); ++i) {
                ++amt;
            }
            if (amt > 0) {
                float anglePer = 360.0f / (float)amt;
                Optional maybeRecipe = altar.f_58857_.m_7465_().m_44015_(ModRecipeTypes.PETAL_TYPE, altar.getItemHandler(), altar.f_58857_);
                maybeRecipe.ifPresent(recipe -> {
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)HUDHandler.manaBar);
                    RenderHelper.drawTexturedModalRect(ms, xc + radius + 9, yc - 8, 0, 8, 22, 15);
                    ItemStack stack = recipe.m_5874_(altar.getItemHandler());
                    mc.m_91291_().m_115123_(stack, xc + radius + 32, yc - 8);
                    mc.m_91291_().m_115123_(new ItemStack((ItemLike)Items.f_42404_), xc + radius + 16, yc + 6);
                    mc.f_91062_.m_92883_(ms, "+", (float)(xc + radius + 14), (float)(yc + 10), 0xFFFFFF);
                });
                for (int i = 0; i < amt; ++i) {
                    double xPos = (double)xc + Math.cos((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                    double yPos = (double)yc + Math.sin((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                    PoseStack pose = RenderSystem.m_157191_();
                    pose.m_85836_();
                    pose.m_85837_(xPos, yPos, 0.0);
                    RenderSystem.m_157182_();
                    mc.m_91291_().m_115123_(altar.getItemHandler().m_8020_(i), 0, 0);
                    pose.m_85849_();
                    RenderSystem.m_157182_();
                    angle += anglePer;
                }
            } else if (altar.recipeKeepTicks > 0 && altar.getFluid() == IPetalApothecary.State.WATER) {
                String s = I18n.m_118938_((String)"botaniamisc.altarRefill0", (Object[])new Object[0]);
                mc.f_91062_.m_92883_(ms, s, (float)(xc - mc.f_91062_.m_92895_(s) / 2), (float)(yc + 10), 0xFFFFFF);
                s = I18n.m_118938_((String)"botaniamisc.altarRefill1", (Object[])new Object[0]);
                mc.f_91062_.m_92883_(ms, s, (float)(xc - mc.f_91062_.m_92895_(s) / 2), (float)(yc + 20), 0xFFFFFF);
            }
        }
    }
}

