/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.recipe.IOrechidRecipe;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.handler.OrechidManager;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.IXplatAbstractions;

public class SubTileOrechid
extends TileEntityFunctionalFlower {
    private static final int COST = 17500;
    private static final int COST_GOG = 700;
    private static final int DELAY = 100;
    private static final int DELAY_GOG = 2;
    private static final int RANGE = 5;
    private static final int RANGE_Y = 3;

    protected SubTileOrechid(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SubTileOrechid(BlockPos pos, BlockState state) {
        this(ModSubtiles.ORECHID, pos, state);
    }

    @Override
    public void tickFlower() {
        BlockState state;
        BlockPos coords;
        super.tickFlower();
        if (this.m_58904_().f_46443_ || this.redstoneSignal > 0 || !this.canOperate()) {
            return;
        }
        int cost = this.getCost();
        if (this.getMana() >= cost && this.ticksExisted % this.getDelay() == 0 && (coords = this.getCoordsToPut()) != null && (state = this.getOreToPut(coords, this.m_58904_().m_8055_(coords))) != null) {
            this.m_58904_().m_46597_(coords, state);
            if (BotaniaConfig.common().blockBreakParticles()) {
                this.m_58904_().m_46796_(2001, coords, Block.m_49956_((BlockState)state));
            }
            this.playSound(coords);
            this.addMana(-cost);
            this.sync();
        }
    }

    protected void playSound(BlockPos coords) {
        this.m_58904_().m_5594_(null, coords, ModSounds.orechid, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Nullable
    private BlockState getOreToPut(BlockPos coords, BlockState state) {
        ArrayList<Output> values = new ArrayList<Output>();
        for (IOrechidRecipe recipe : OrechidManager.getFor(this.m_58904_().m_7465_(), this.getRecipeType()).get((Object)state.m_60734_())) {
            Output output = new Output(recipe, recipe.getWeight(this.m_58904_(), coords));
            values.add(output);
        }
        return WeightedRandom.m_146317_((Random)this.m_58904_().f_46441_, values).map(oo -> oo.recipe.getOutput(this.m_58904_(), coords).pick(this.m_58904_().m_5822_())).orElse(null);
    }

    private BlockPos getCoordsToPut() {
        ArrayList<BlockPos> possibleCoords = new ArrayList<BlockPos>();
        Predicate<BlockState> matcher = this.getReplaceMatcher();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.getEffectivePos().m_142082_(-this.getRange(), -this.getRangeY(), -this.getRange()), (BlockPos)this.getEffectivePos().m_142082_(this.getRange(), this.getRangeY(), this.getRange()))) {
            BlockState state = this.m_58904_().m_8055_(pos);
            if (!matcher.test(state)) continue;
            possibleCoords.add(pos.m_7949_());
        }
        if (possibleCoords.isEmpty()) {
            return null;
        }
        return (BlockPos)possibleCoords.get(this.m_58904_().f_46441_.nextInt(possibleCoords.size()));
    }

    public boolean canOperate() {
        return true;
    }

    public RecipeType<? extends IOrechidRecipe> getRecipeType() {
        return ModRecipeTypes.ORECHID_TYPE;
    }

    public Predicate<BlockState> getReplaceMatcher() {
        ListMultimap<Block, ? extends IOrechidRecipe> map = OrechidManager.getFor(this.m_58904_().m_7465_(), this.getRecipeType());
        return state -> map.containsKey((Object)state.m_60734_());
    }

    public int getCost() {
        return IXplatAbstractions.INSTANCE.gogLoaded() ? 700 : 17500;
    }

    public int getDelay() {
        return IXplatAbstractions.INSTANCE.gogLoaded() ? 2 : 100;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), this.getRange());
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    public int getRange() {
        return 5;
    }

    public int getRangeY() {
        return 3;
    }

    @Override
    public int getColor() {
        return 0x818181;
    }

    @Override
    public int getMaxMana() {
        return this.getCost();
    }

    private static class Output
    implements WeightedEntry {
        private final Weight weight;
        private final IOrechidRecipe recipe;

        public Output(IOrechidRecipe recipe, int weight) {
            this.weight = Weight.m_146282_((int)weight);
            this.recipe = recipe;
        }

        public Weight m_142631_() {
            return this.weight;
        }
    }
}

