/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.internal_caps.LooniumComponent;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.xplat.IXplatAbstractions;

public class SubTileLoonuim
extends TileEntityFunctionalFlower {
    private static final int COST = 35000;
    private static final int RANGE = 5;
    private static final String TAG_LOOT_TABLE = "lootTable";
    public static final Set<Class<? extends Monster>> VALID_MOBS = Set.of(Creeper.class, EnderMan.class, Skeleton.class, Stray.class, Spider.class, Zombie.class);
    private ResourceLocation lootTable = new ResourceLocation("minecraft", "chests/simple_dungeon");

    public SubTileLoonuim(BlockPos pos, BlockState state) {
        super(ModSubtiles.LOONIUM, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        Level world = this.m_58904_();
        if (!world.f_46443_ && this.redstoneSignal == 0 && this.ticksExisted % 100 == 0 && this.getMana() >= 35000 && world.m_46791_() != Difficulty.PEACEFUL) {
            List stacks;
            ItemStack stack;
            Random rand = world.f_46441_;
            do {
                LootContext ctx = new LootContext.Builder((ServerLevel)world).m_78975_(LootContextParamSets.f_81410_);
                stacks = ((ServerLevel)world).m_142572_().m_129898_().m_79217_(this.lootTable).m_79129_(ctx);
                if (stacks.isEmpty()) {
                    return;
                }
                Collections.shuffle(stacks);
            } while ((stack = (ItemStack)stacks.get(0)).m_41619_() || ModTags.Items.LOONIUM_BLACKLIST.m_8110_((Object)stack.m_41720_()));
            int bound = 11;
            int xp = this.getEffectivePos().m_123341_() - 5 + rand.nextInt(bound);
            int yp = this.getEffectivePos().m_123342_();
            int zp = this.getEffectivePos().m_123343_() - 5 + rand.nextInt(bound);
            BlockPos pos = new BlockPos(xp, yp - 1, zp);
            do {
                if ((pos = pos.m_7494_()).m_123342_() < world.m_151558_()) continue;
                return;
            } while (world.m_8055_(pos).m_60828_((BlockGetter)world, pos));
            pos = pos.m_7494_();
            double x = (double)pos.m_123341_() + Math.random();
            double y = (double)pos.m_123342_() + Math.random();
            double z = (double)pos.m_123343_() + Math.random();
            Object entity = null;
            if (world.f_46441_.nextInt(50) == 0) {
                entity = new EnderMan(EntityType.f_20566_, world);
            } else if (world.f_46441_.nextInt(10) == 0) {
                entity = new Creeper(EntityType.f_20558_, world);
                if (world.f_46441_.nextInt(200) == 0) {
                    CompoundTag charged = new CompoundTag();
                    charged.m_128379_("powered", true);
                    entity.m_7378_(charged);
                }
            } else {
                switch (world.f_46441_.nextInt(3)) {
                    case 0: {
                        if (world.f_46441_.nextInt(10) == 0) {
                            entity = new Husk(EntityType.f_20458_, world);
                            break;
                        }
                        if (world.f_46441_.nextInt(5) == 0) {
                            entity = new Drowned(EntityType.f_20562_, world);
                            break;
                        }
                        entity = new Zombie(world);
                        break;
                    }
                    case 1: {
                        if (world.f_46441_.nextInt(10) == 0) {
                            entity = new Stray(EntityType.f_20481_, world);
                            break;
                        }
                        entity = new Skeleton(EntityType.f_20524_, world);
                        break;
                    }
                    case 2: {
                        entity = world.f_46441_.nextInt(10) == 0 ? new CaveSpider(EntityType.f_20554_, world) : new Spider(EntityType.f_20479_, world);
                    }
                }
            }
            entity.m_19890_(x, y, z, world.f_46441_.nextFloat() * 360.0f, 0.0f);
            entity.m_20256_(Vec3.f_82478_);
            entity.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("Loonium Modififer Health", 2.0, AttributeModifier.Operation.MULTIPLY_BASE));
            entity.m_21051_(Attributes.f_22281_).m_22125_(new AttributeModifier("Loonium Modififer Damage", 1.5, AttributeModifier.Operation.MULTIPLY_BASE));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, entity instanceof Creeper ? 100 : Integer.MAX_VALUE, 0));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, entity instanceof Creeper ? 100 : Integer.MAX_VALUE, 0));
            IXplatAbstractions.INSTANCE.looniumComponent((LivingEntity)entity).setDrop(stack);
            entity.m_6518_((ServerLevelAccessor)world, world.m_6436_(pos), MobSpawnType.SPAWNER, null, null);
            world.m_7967_((Entity)entity);
            entity.m_21373_();
            this.addMana(-35000);
            this.sync();
        }
    }

    @Override
    public int getColor() {
        return 2574848;
    }

    @Override
    public int getMaxMana() {
        return 35000;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 5);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        if (cmp.m_128441_(TAG_LOOT_TABLE)) {
            this.lootTable = new ResourceLocation(cmp.m_128461_(TAG_LOOT_TABLE));
        }
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128359_(TAG_LOOT_TABLE, this.lootTable.toString());
    }

    public static void dropLooniumItems(LivingEntity living, Consumer<ItemStack> consumer) {
        LooniumComponent comp = IXplatAbstractions.INSTANCE.looniumComponent(living);
        if (comp != null && !comp.getDrop().m_41619_()) {
            consumer.accept(comp.getDrop());
        }
    }
}

